/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.index;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSModuleFileReferenceSet;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6FileIncludeProvider
extends FileIncludeProvider {
    @NotNull
    public String getId() {
        String string = JavaScriptSupportLoader.ECMA_SCRIPT_6.getID();
        if (string == null) {
            ES6FileIncludeProvider.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean acceptFile(VirtualFile file2) {
        if (this.isAcceptableFileType(file2) && JavaScriptIndex.ourIndexedFilesFilter.acceptInput(file2)) {
            return !JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles().contains(file2);
        }
        return false;
    }

    public boolean isAcceptableFileType(VirtualFile file2) {
        FileType type = file2.getFileType();
        return DialectDetector.JAVASCRIPT_FILE_TYPES.contains(type) || TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(type);
    }

    public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
        if (fileTypeSink == null) {
            ES6FileIncludeProvider.$$$reportNull$$$0(1);
        }
        DialectDetector.JAVASCRIPT_FILE_TYPES.forEach(el -> {
            if (fileTypeSink == null) {
                ES6FileIncludeProvider.$$$reportNull$$$0(22);
            }
            fileTypeSink.consume(el);
        });
        TypeScriptUtil.TYPESCRIPT_FILE_TYPES.forEach(el -> {
            if (fileTypeSink == null) {
                ES6FileIncludeProvider.$$$reportNull$$$0(21);
            }
            fileTypeSink.consume(el);
        });
    }

    @NotNull
    public FileIncludeInfo[] getIncludeInfos(@NotNull FileContent content) {
        JSFile file2;
        boolean isAcceptableFile;
        if (content == null) {
            ES6FileIncludeProvider.$$$reportNull$$$0(2);
        }
        if (!(isAcceptableFile = this.isAcceptableFile(file2 = (JSFile)ObjectUtils.tryCast((Object)content.getPsiFile(), JSFile.class), content))) {
            if (FileIncludeInfo.EMPTY == null) {
                ES6FileIncludeProvider.$$$reportNull$$$0(3);
            }
            return FileIncludeInfo.EMPTY;
        }
        FileIncludeInfo[] fileIncludeInfoArray = ES6FileIncludeProvider.buildFileIncludeInfo(file2.getReferencedPaths());
        if (fileIncludeInfoArray == null) {
            ES6FileIncludeProvider.$$$reportNull$$$0(4);
        }
        return fileIncludeInfoArray;
    }

    @NotNull
    private static FileIncludeInfo[] buildFileIncludeInfo(@NotNull Collection<String> refSet) {
        if (refSet == null) {
            ES6FileIncludeProvider.$$$reportNull$$$0(5);
        }
        if (refSet.isEmpty()) {
            if (FileIncludeInfo.EMPTY == null) {
                ES6FileIncludeProvider.$$$reportNull$$$0(6);
            }
            return FileIncludeInfo.EMPTY;
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (String path : refSet) {
            int index = (path = ES6FileIncludeProvider.preProcessPath(path)).lastIndexOf("/");
            String name = index >= 0 ? path.substring(index + 1, path.length()) : path;
            result2.add(new FileIncludeInfo(name, path, -1, false));
        }
        FileIncludeInfo[] fileIncludeInfoArray = result2.toArray(FileIncludeInfo.EMPTY);
        if (fileIncludeInfoArray == null) {
            ES6FileIncludeProvider.$$$reportNull$$$0(7);
        }
        return fileIncludeInfoArray;
    }

    @NotNull
    public static String preProcessPath(@NotNull String path) {
        if (path == null) {
            ES6FileIncludeProvider.$$$reportNull$$$0(8);
        }
        String string = StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)StringUtil.unquoteString((String)path)), (String)"/");
        if (string == null) {
            ES6FileIncludeProvider.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public PsiFileSystemItem resolveIncludedFile(@NotNull FileIncludeInfo info, @NotNull PsiFile context) {
        if (info == null) {
            ES6FileIncludeProvider.$$$reportNull$$$0(10);
        }
        if (context == null) {
            ES6FileIncludeProvider.$$$reportNull$$$0(11);
        }
        if (!(context instanceof JSFile)) {
            return null;
        }
        if (DialectDetector.isTypeScript((PsiElement)context)) {
            return ES6FileIncludeProvider.resolveTypeScriptFile(info, context);
        }
        return new JSModuleFileReferenceSet(info.path, (PsiElement)context, 0, null, null){

            @Override
            @NotNull
            protected Collection<PsiDirectory> getAmdDirectories(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    1.$$$reportNull$$$0(1);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/ecmascript6/index/ES6FileIncludeProvider$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/ecmascript6/index/ES6FileIncludeProvider$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAmdDirectories";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getAmdDirectories";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }.resolve();
    }

    @Nullable
    private static PsiFileSystemItem resolveTypeScriptFile(@NotNull FileIncludeInfo info, @NotNull PsiFile context) {
        if (info == null) {
            ES6FileIncludeProvider.$$$reportNull$$$0(12);
        }
        if (context == null) {
            ES6FileIncludeProvider.$$$reportNull$$$0(13);
        }
        VirtualFile contextFile = context.getOriginalFile().getVirtualFile();
        TypeScriptFileImportsImpl fileImports = TypeScriptFileImportsImpl.createFileImports((PsiElement)context);
        if (fileImports == null) {
            return null;
        }
        VirtualFile resolvedFile = fileImports.resolveFile(info.path, contextFile);
        if (resolvedFile == null) {
            return null;
        }
        PsiManager manager = context.getManager();
        return resolvedFile.isDirectory() ? manager.findDirectory(resolvedFile) : manager.findFile(resolvedFile);
    }

    @NotNull
    public String getIncludeName(@NotNull PsiFile file2, @NotNull String originalName) {
        if (file2 == null) {
            ES6FileIncludeProvider.$$$reportNull$$$0(14);
        }
        if (originalName == null) {
            ES6FileIncludeProvider.$$$reportNull$$$0(15);
        }
        if (!(file2 instanceof JSFile)) {
            String string = originalName;
            if (string == null) {
                ES6FileIncludeProvider.$$$reportNull$$$0(16);
            }
            return string;
        }
        String extension = JSFileReference.findImplicitExtension(originalName);
        if (extension == null) {
            String string = originalName;
            if (string == null) {
                ES6FileIncludeProvider.$$$reportNull$$$0(17);
            }
            return string;
        }
        String string = JSFileReference.getFileNameWithoutExtension(originalName, JSFileReference.IMPLICIT_EXTENSIONS);
        if (string == null) {
            ES6FileIncludeProvider.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Contract(value="null,_->false")
    public boolean isAcceptableFile(@Nullable JSFile file2, @NotNull FileContent content) {
        if (content == null) {
            ES6FileIncludeProvider.$$$reportNull$$$0(19);
        }
        if (file2 == null) {
            return false;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfFile((PsiFile)file2);
        if (holder == null) {
            return false;
        }
        if (holder.isTypeScript) {
            return true;
        }
        return holder.isECMA6 && this.checkTextHasFromKeyword(content);
    }

    public boolean checkTextHasFromKeyword(@NotNull FileContent content) {
        if (content == null) {
            ES6FileIncludeProvider.$$$reportNull$$$0(20);
        }
        CharSequence text = content.getContentAsText();
        int start = CharArrayUtil.indexOf((CharSequence)text, (CharSequence)"from", (int)0);
        boolean hasFrom = false;
        while (start != -1) {
            if (start > 0 && Character.isWhitespace(text.charAt(start - 1)) && start < text.length() - "from".length() - 1 && Character.isWhitespace(text.charAt(start + "from".length()))) {
                hasFrom = true;
                break;
            }
            start = CharArrayUtil.indexOf((CharSequence)text, (CharSequence)"from", (int)(start + 1));
        }
        return hasFrom;
    }

    public int getVersion() {
        return 2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/index/ES6FileIncludeProvider";
                break;
            }
            case 1: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeSink";
                break;
            }
            case 2: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refSet";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/index/ES6FileIncludeProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludeInfos";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFileIncludeInfo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "preProcessPath";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludeName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerFileTypesUsedForIndexing";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIncludeInfos";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildFileIncludeInfo";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "preProcessPath";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveIncludedFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeScriptFile";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getIncludeName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableFile";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "checkTextHasFromKeyword";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$registerFileTypesUsedForIndexing$1";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$registerFileTypesUsedForIndexing$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

