/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.javascript.nodejs.NodeJSSettingsManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterType;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreterType;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.GuiUtils;
import org.jetbrains.annotations.NotNull;

public class NodeJsInterpreterManagerStartupActivity
implements StartupActivity,
DumbAware {
    private static final Logger LOG = Logger.getInstance(NodeJsInterpreterManagerStartupActivity.class);
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Node.js interpreter", NotificationDisplayType.BALLOON, true, null);

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            NodeJsInterpreterManagerStartupActivity.$$$reportNull$$$0(0);
        }
        GuiUtils.invokeLaterIfNeeded(() -> {
            if (project == null) {
                NodeJsInterpreterManagerStartupActivity.$$$reportNull$$$0(3);
            }
            if (project.isDefault()) {
                return;
            }
            NodeJsInterpreterManager interpreterManager = NodeJsInterpreterManager.getInstance(project);
            NodeJsInterpreterRef interpreterRef = interpreterManager.getInterpreterRef();
            boolean clonedFromDefaultProject = interpreterManager.isClonedFromDefaultProject();
            if (interpreterRef.isConstantRef()) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    if (project == null) {
                        NodeJsInterpreterManagerStartupActivity.$$$reportNull$$$0(4);
                    }
                    ReadAction.run(() -> {
                        NodeJsInterpreter interpreter;
                        if (project == null) {
                            NodeJsInterpreterManagerStartupActivity.$$$reportNull$$$0(5);
                        }
                        if (!project.isDisposed() && !NodeJsRemoteInterpreterType.getInstance().isRemoteReference(interpreterRef) && (interpreter = interpreterRef.resolveWithoutAliases()) instanceof NodeJsLocalInterpreter && !((NodeJsLocalInterpreter)interpreter).isValid()) {
                            ApplicationManager.getApplication().invokeLater(() -> {
                                if (project == null) {
                                    NodeJsInterpreterManagerStartupActivity.$$$reportNull$$$0(6);
                                }
                                LOG.info("Invalid project interpreter " + interpreterRef.getReferenceName() + ", updated to 'node', clonedFromDefaultProject: " + clonedFromDefaultProject);
                                NodeJsInterpreterManagerStartupActivity.updateProjectInterpreterRef(project, !clonedFromDefaultProject);
                            }, project.getDisposed());
                        }
                    });
                });
            }
            NpmManager.resetOnceDefaultProjectNpmPath();
        }, (ModalityState)ModalityState.defaultModalityState(), (Condition)project.getDisposed());
    }

    private static void updateProjectInterpreterRef(@NotNull Project project, boolean showNotification) {
        if (project == null) {
            NodeJsInterpreterManagerStartupActivity.$$$reportNull$$$0(1);
        }
        NodeJsInterpreterManager.getInstance(project).setInterpreterRef(NodeJsLocalInterpreterType.createNodeFromPathRef());
        if (showNotification) {
            Notification notification2 = NOTIFICATION_GROUP.createNotification(null, null, "The project used an invalid path to Node.js.<br>It was updated to use Node.js from " + (SystemInfo.isWindows ? "%PATH%" : "$PATH") + ".", NotificationType.INFORMATION, null);
            notification2.addAction((AnAction)DumbAwareAction.create((String)"OK", event -> notification2.expire()));
            notification2.addAction((AnAction)DumbAwareAction.create((String)"Configure Node.js", event -> {
                if (project == null) {
                    NodeJsInterpreterManagerStartupActivity.$$$reportNull$$$0(2);
                }
                notification2.expire();
                NodeJSSettingsManager.editSettingsAppropriately(project);
            }));
            notification2.notify(project);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterManagerStartupActivity";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateProjectInterpreterRef";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$updateProjectInterpreterRef$5";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$runActivity$3";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$2";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$1";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

