/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.documentation;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.packageJson.NpmRegistryService;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.SwingHelper;
import java.awt.Color;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsPackageDocumentation {
    private final String myPackageName;
    private final String myDescription;
    private final String myReadmeHtml;
    private final VirtualFile myPackageDir;

    public NodeJsPackageDocumentation(@NotNull String packageName, @Nullable String description, @Nullable String readmeHtml, @Nullable VirtualFile packageDir) {
        if (packageName == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(0);
        }
        this.myPackageName = packageName;
        this.myDescription = description;
        this.myReadmeHtml = readmeHtml;
        this.myPackageDir = packageDir;
    }

    @NotNull
    public String getQuickInfoHtml() {
        String string = this.getQuickInfoHtml(this.myDescription, false, true);
        if (string == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private String getQuickInfoHtml(@Nullable String description, boolean showInstalledVersion, boolean showLatestVersion) {
        if (showInstalledVersion) {
            String string = NodeJsPackageDocumentation.html(this.myPackageName, true, this.getInstalledVersion(), false, null, description);
            if (string == null) {
                NodeJsPackageDocumentation.$$$reportNull$$$0(2);
            }
            return string;
        }
        List<Pair<String, SemVer>> tags = NpmRegistryService.getInstance().getCachedPackageDistTags(this.myPackageName);
        if (tags != null) {
            String string = NodeJsPackageDocumentation.html(this.myPackageName, false, null, showLatestVersion, NodeJsPackageDocumentation.getLatest(tags), description);
            if (string == null) {
                NodeJsPackageDocumentation.$$$reportNull$$$0(3);
            }
            return string;
        }
        NpmRegistryService.getInstance().asyncUpdateAndGetPackageDistTags(this.myPackageName).processed(pairs -> ApplicationManager.getApplication().invokeLater(() -> {
            Project[] projects;
            ProjectManager projectManager = ProjectManager.getInstance();
            for (Project project : projects = projectManager.getOpenProjects()) {
                PsiModificationTrackerImpl trackerImpl = (PsiModificationTrackerImpl)ObjectUtils.tryCast((Object)PsiModificationTracker.SERVICE.getInstance((Project)project), PsiModificationTrackerImpl.class);
                if (trackerImpl == null) continue;
                trackerImpl.incCounter();
            }
        }));
        String string = NodeJsPackageDocumentation.html(this.myPackageName, false, null, true, null, description);
        if (string == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private SemVer getInstalledVersion() {
        VirtualFile packageJson;
        VirtualFile virtualFile = packageJson = this.myPackageDir != null ? PackageJsonUtil.findChildPackageJsonFile(this.myPackageDir) : null;
        if (packageJson != null) {
            return PackageJsonData.getOrCreate(packageJson).getVersion();
        }
        return null;
    }

    @Nullable
    private static SemVer getLatest(@NotNull List<Pair<String, SemVer>> tags) {
        if (tags == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(5);
        }
        for (Pair<String, SemVer> tag : tags) {
            if (!((String)tag.getFirst()).equals("latest")) continue;
            return (SemVer)tag.getSecond();
        }
        return null;
    }

    @NotNull
    private static String html(@NotNull String packageName, boolean showInstalledVersion, @Nullable SemVer installedVersion, boolean showLatestVersion, @Nullable SemVer latestVersion, @Nullable String description) {
        if (packageName == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(6);
        }
        String versionStr = null;
        if (showInstalledVersion) {
            if (installedVersion != null) {
                versionStr = "Installed version: " + installedVersion.getRawVersion();
            }
        } else if (showLatestVersion) {
            if (latestVersion == null) {
                versionStr = "loading...";
            } else {
                versionStr = latestVersion.getRawVersion();
                if (StringUtil.isEmptyOrSpaces((String)versionStr)) {
                    versionStr = "n/a";
                }
            }
            versionStr = "Latest version: " + versionStr;
        }
        JBColor versionColor = new JBColor((Color)Gray.get((int)96), (Color)Gray.get((int)160));
        String string = "<table cellspacing='0' cellpadding='0' style='border: none;'> <tr>  <td style='text-align:left'><b>" + StringEscapeUtils.escapeXml((String)packageName) + "</b></td>" + (versionStr == null ? "" : "  <td style='width:20px'></td>  <td style='text-align:right'>    <div style='color:#" + ColorUtil.toHex((Color)versionColor) + ";'>" + StringEscapeUtils.escapeXml((String)versionStr) + "    </div>  </td>") + " </tr>" + (StringUtil.isEmptyOrSpaces((String)description) ? "" : " <tr>  <td colspan='3' style='white-space:nowrap'>" + StringEscapeUtils.escapeXml((String)description) + "</td> </tr>") + "</table>";
        if (string == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private String getBodyHtml() {
        if (this.myReadmeHtml != null) {
            String prefix = "<h1>" + this.myPackageName + "</h1>";
            if (StringUtil.startsWithIgnoreCase((String)this.myReadmeHtml, (String)prefix)) {
                String string = this.getQuickInfoHtml(null, true, false) + this.myReadmeHtml.substring(prefix.length());
                if (string == null) {
                    NodeJsPackageDocumentation.$$$reportNull$$$0(8);
                }
                return string;
            }
            String string = this.myReadmeHtml;
            if (string == null) {
                NodeJsPackageDocumentation.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = this.getQuickInfoHtml();
        if (string == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getFullDocHtml() {
        String html = this.getBodyHtml();
        String string = SwingHelper.buildHtml((String)"", (String)html);
        if (string == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/documentation/NodeJsPackageDocumentation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/documentation/NodeJsPackageDocumentation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickInfoHtml";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "html";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBodyHtml";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullDocHtml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLatest";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "html";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

