/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest;

import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.javascript.jest.JestRunConfiguration;
import com.intellij.javascript.jest.JestRunSettings;
import com.intellij.javascript.jest.JestUtil;
import com.intellij.javascript.jest.scope.JestScopeKind;
import com.intellij.javascript.jest.scope.JestScopeView;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.webcore.ui.PathShortener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JestRunConfigurationEditor
extends SettingsEditor<JestRunConfiguration> {
    private final Project myProject;
    private final TextFieldWithHistoryWithBrowseButton myConfigPathTextFieldWithBrowseButton;
    private final NodeJsInterpreterField myInterpreterField;
    private final RawCommandLineEditor myNodeOptionsEditor;
    private final NodePackageField myJestPackageField;
    private final TextFieldWithBrowseButton myWorkingDirComponent;
    private final RawCommandLineEditor myJestOptionsEditor;
    private final EnvironmentVariablesTextFieldWithBrowseButton myEnvVarsComponent;
    private final Map<JestScopeKind, JRadioButton> myRadioButtonMap;
    private final Map<JestScopeKind, JestScopeView> myScopeKindViewMap;
    private final JPanel mySelectedScopeKindPanel;
    private final JPanel myPanel;
    private final int myLongestLabelWidth;

    public JestRunConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        this.myRadioButtonMap = ContainerUtil.newHashMap();
        this.myScopeKindViewMap = ContainerUtil.newHashMap();
        this.myLongestLabelWidth = new JLabel((String)"Environment variables:").getPreferredSize().width;
        this.myProject = project;
        this.myConfigPathTextFieldWithBrowseButton = JestRunConfigurationEditor.createConfigurationFileTextField(project);
        PathShortener.enablePathShortening((JTextField)((TextFieldWithHistory)this.myConfigPathTextFieldWithBrowseButton.getChildComponent()).getTextEditor(), null);
        this.myInterpreterField = new NodeJsInterpreterField(project, false);
        this.myNodeOptionsEditor = JestRunConfigurationEditor.createNodeOptionsEditor();
        this.myWorkingDirComponent = JestRunConfigurationEditor.createWorkingDirComponent(project);
        PathShortener.enablePathShortening((JTextField)this.myWorkingDirComponent.getTextField(), null);
        this.myJestPackageField = new NodePackageField(this.myInterpreterField, JestUtil.PKG_DESCRIPTOR, () -> {
            String text = PathShortener.getAbsolutePath((JTextField)this.myWorkingDirComponent.getTextField());
            return !text.isEmpty() ? LocalFileSystem.getInstance().findFileByPath(text) : null;
        });
        this.myJestOptionsEditor = JestRunConfigurationEditor.createJestOptionsEditor();
        this.myEnvVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        JPanel scopeKindPanel = this.createScopeKindRadioButtonPanel();
        this.mySelectedScopeKindPanel = new JPanel(new BorderLayout());
        this.myPanel = new FormBuilder().setAlignLabelOnRight(false).addLabeledComponent("&Configuration file:", (JComponent)this.myConfigPathTextFieldWithBrowseButton).addSeparator(8).addLabeledComponent("Node &interpreter:", (JComponent)((Object)this.myInterpreterField), 8).addLabeledComponent("Node o&ptions:", (JComponent)this.myNodeOptionsEditor).addLabeledComponent("&Jest package:", (JComponent)((Object)this.myJestPackageField)).addLabeledComponent("&Working directory:", (JComponent)this.myWorkingDirComponent).addLabeledComponent("Jest &options:", (JComponent)this.myJestOptionsEditor).addLabeledComponent("&Environment variables:", (JComponent)this.myEnvVarsComponent).addSeparator(8).addComponent((JComponent)scopeKindPanel).addComponent((JComponent)this.mySelectedScopeKindPanel).getPanel();
    }

    @NotNull
    private static RawCommandLineEditor createNodeOptionsEditor() {
        RawCommandLineEditor editor = new RawCommandLineEditor();
        editor.setDialogCaption("Node Options");
        JTextField field = editor.getTextField();
        if (field instanceof ExpandableTextField) {
            field.putClientProperty("monospaced", false);
        }
        RawCommandLineEditor rawCommandLineEditor = editor;
        if (rawCommandLineEditor == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        return rawCommandLineEditor;
    }

    @NotNull
    private static RawCommandLineEditor createJestOptionsEditor() {
        RawCommandLineEditor editor = new RawCommandLineEditor();
        editor.setDialogCaption("Jest Options");
        JTextField field = editor.getTextField();
        if (field instanceof ExpandableTextField) {
            field.putClientProperty("monospaced", false);
        }
        if (field instanceof ComponentWithEmptyText) {
            ((ComponentWithEmptyText)field).getEmptyText().setText("CLI options, e.g. --watch or --env=jsdom");
        }
        RawCommandLineEditor rawCommandLineEditor = editor;
        if (rawCommandLineEditor == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        return rawCommandLineEditor;
    }

    @NotNull
    private static TextFieldWithHistoryWithBrowseButton createConfigurationFileTextField(@NotNull Project project) {
        if (project == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = new TextFieldWithHistoryWithBrowseButton();
        final TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)textFieldWithHistoryWithBrowseButton.getChildComponent();
        textFieldWithHistory.setHistorySize(-1);
        textFieldWithHistory.setMinimumAndPreferredWidth(0);
        SwingHelper.addHistoryOnExpansion((TextFieldWithHistory)textFieldWithHistory, () -> {
            if (project == null) {
                JestRunConfigurationEditor.$$$reportNull$$$0(16);
            }
            List<VirtualFile> newFiles = JestUtil.listPossibleConfigFilesInProject(project);
            List newFilePaths = ContainerUtil.map(newFiles, file2 -> FileUtil.toSystemDependentName((String)file2.getPath()));
            Collections.sort(newFilePaths);
            return newFilePaths;
        });
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithHistoryWithBrowseButton)textFieldWithHistoryWithBrowseButton, (String)"Select Jest Configuration File", (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        textFieldWithHistory.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){
            private String myLastAddedText;

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                String currentText = textFieldWithHistory.getText();
                if (currentText == null || currentText.equals(this.myLastAddedText)) {
                    return;
                }
                List oldHistory = textFieldWithHistory.getHistory();
                HashSet<String> newHistory = new HashSet<String>(oldHistory);
                newHistory.remove(this.myLastAddedText);
                this.myLastAddedText = null;
                if (!oldHistory.contains(currentText)) {
                    newHistory.add(currentText);
                    this.myLastAddedText = currentText;
                }
                ArrayList result2 = new ArrayList(newHistory);
                Collections.sort(result2);
                if (!result2.equals(oldHistory)) {
                    textFieldWithHistory.setHistory(result2);
                    textFieldWithHistory.setSelectedItem((Object)currentText);
                }
            }
        });
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton2 = textFieldWithHistoryWithBrowseButton;
        if (textFieldWithHistoryWithBrowseButton2 == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(4);
        }
        return textFieldWithHistoryWithBrowseButton2;
    }

    @NotNull
    private static TextFieldWithBrowseButton createWorkingDirComponent(@NotNull Project project) {
        if (project == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(5);
        }
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithBrowseButton)textFieldWithBrowseButton, (String)"Select Working Directory", (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor());
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = textFieldWithBrowseButton;
        if (textFieldWithBrowseButton2 == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(6);
        }
        return textFieldWithBrowseButton2;
    }

    @NotNull
    private JPanel createScopeKindRadioButtonPanel() {
        JPanel testKindPanel = new JPanel(new FlowLayout(1, JBUI.scale((int)40), 0));
        testKindPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (final JestScopeKind scopeKind : JestScopeKind.values()) {
            JRadioButton radioButton = new JRadioButton(UIUtil.removeMnemonic((String)scopeKind.getName()));
            int index = UIUtil.getDisplayMnemonicIndex((String)scopeKind.getName());
            if (index != -1) {
                radioButton.setMnemonic(scopeKind.getName().charAt(index + 1));
                radioButton.setDisplayedMnemonicIndex(index);
            }
            radioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JestRunConfigurationEditor.this.setScopeKind(scopeKind);
                }
            });
            this.myRadioButtonMap.put(scopeKind, radioButton);
            testKindPanel.add(radioButton);
            buttonGroup.add(radioButton);
        }
        JPanel jPanel = testKindPanel;
        if (jPanel == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    private void setScopeKind(@NotNull JestScopeKind scopeKind) {
        JestScopeKind selectedScopeKind;
        if (scopeKind == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(8);
        }
        if ((selectedScopeKind = this.getScopeKind()) != scopeKind) {
            JRadioButton radioButton = this.myRadioButtonMap.get((Object)scopeKind);
            radioButton.setSelected(true);
        }
        JestScopeView view = this.getScopeKindView(scopeKind);
        JestRunConfigurationEditor.setCenterBorderLayoutComponent(this.mySelectedScopeKindPanel, view.getComponent());
    }

    @NotNull
    private JestScopeView getScopeKindView(@NotNull JestScopeKind scopeKind) {
        JestScopeView view;
        if (scopeKind == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(9);
        }
        if ((view = this.myScopeKindViewMap.get((Object)scopeKind)) == null) {
            view = scopeKind.createView(this.myProject);
            this.myScopeKindViewMap.put(scopeKind, view);
            JComponent component = view.getComponent();
            if (component.getLayout() instanceof GridBagLayout) {
                component.add(Box.createHorizontalStrut(this.myLongestLabelWidth), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, (Insets)JBUI.insets((int)0, (int)0, (int)0, (int)10), 0, 0));
            }
        }
        JestScopeView jestScopeView = view;
        if (jestScopeView == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(10);
        }
        return jestScopeView;
    }

    private static void setCenterBorderLayoutComponent(@NotNull JPanel panel, @NotNull Component child) {
        Component prevChild;
        if (panel == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(11);
        }
        if (child == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(12);
        }
        if ((prevChild = ((BorderLayout)panel.getLayout()).getLayoutComponent("Center")) != null) {
            panel.remove(prevChild);
        }
        panel.add(child, "Center");
        panel.revalidate();
        panel.repaint();
    }

    @Nullable
    private JestScopeKind getScopeKind() {
        for (Map.Entry<JestScopeKind, JRadioButton> entry : this.myRadioButtonMap.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            return entry.getKey();
        }
        return null;
    }

    protected void resetEditorFrom(@NotNull JestRunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(13);
        }
        JestRunSettings runSettings = runConfiguration.getRunSettings();
        this.myConfigPathTextFieldWithBrowseButton.setTextAndAddToHistory(runSettings.getConfigFileSystemDependentPath());
        this.myInterpreterField.setInterpreterRef(runSettings.getInterpreterRef());
        this.myNodeOptionsEditor.setText(runSettings.getNodeOptions());
        NodeJsInterpreter interpreter = runSettings.getInterpreterRef().resolve(this.myProject);
        NodePackage pkg = JestUtil.getJestPackage(this.myProject, interpreter);
        this.myJestPackageField.setSelected(pkg);
        this.myWorkingDirComponent.setText(runSettings.getWorkingDirSystemDependentPath());
        this.myJestOptionsEditor.setText(runSettings.getJestOptions());
        this.myEnvVarsComponent.setData(runSettings.getEnvData());
        this.setScopeKind(runSettings.getScopeKind());
        JestScopeView view = this.getScopeKindView(runSettings.getScopeKind());
        view.resetFrom(runSettings);
        this.updatePreferredWidth();
    }

    private void updatePreferredWidth() {
        DialogWrapper dialogWrapper = DialogWrapper.findInstance((Component)this.myPanel);
        if (dialogWrapper instanceof SingleConfigurableEditor) {
            this.myInterpreterField.setPreferredWidthToFitText();
            this.myJestPackageField.setPreferredWidthToFitText();
            SwingHelper.setPreferredWidthToFitText((TextFieldWithHistoryWithBrowseButton)this.myConfigPathTextFieldWithBrowseButton);
            ApplicationManager.getApplication().invokeLater(() -> SwingHelper.adjustDialogSizeToFitPreferredSize((DialogWrapper)dialogWrapper), ModalityState.stateForComponent((Component)this.myPanel));
        }
    }

    protected void applyEditorTo(@NotNull JestRunConfiguration runConfiguration) throws ConfigurationException {
        if (runConfiguration == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(14);
        }
        JestRunSettings.Builder builder = JestRunSettings.builder();
        builder.setConfigFilePath(PathShortener.getAbsolutePath((JTextField)((TextFieldWithHistory)this.myConfigPathTextFieldWithBrowseButton.getChildComponent()).getTextEditor()));
        builder.setInterpreterRef(this.myInterpreterField.getInterpreterRef());
        builder.setNodeOptions(this.myNodeOptionsEditor.getText());
        JestUtil.setJestPackage(this.myProject, this.myJestPackageField.getSelected());
        builder.setWorkingDir(PathShortener.getAbsolutePath((JTextField)this.myWorkingDirComponent.getTextField()));
        builder.setJestOptions(this.myJestOptionsEditor.getText());
        builder.setEnvData(this.myEnvVarsComponent.getData());
        JestScopeKind scopeKind = this.getScopeKind();
        if (scopeKind != null) {
            builder.setScopeKind(scopeKind);
            JestScopeView view = this.getScopeKindView(scopeKind);
            view.applyTo(builder);
        }
        runConfiguration.setRunSettings(builder.build());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(15);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/jest/JestRunConfigurationEditor";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeKind";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/jest/JestRunConfigurationEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodeOptionsEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createJestOptionsEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurationFileTextField";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createWorkingDirComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createScopeKindRadioButtonPanel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeKindView";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 15: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurationFileTextField";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createWorkingDirComponent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setScopeKind";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getScopeKindView";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setCenterBorderLayoutComponent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createConfigurationFileTextField$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

