/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.javascript.JavaScriptReferenceContributor;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.resolve.CssClassOrIdReference;
import com.intellij.psi.css.resolve.CssSimpleSelectorReference;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptCssReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            JavaScriptCssReferenceContributor.$$$reportNull$$$0(0);
        }
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(JSLiteralExpression.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                return ((JSLiteralExpression)element).isQuotedLiteral() && JavaScriptReferenceContributor.isLiteralInCssContext((PsiElement)element, true) && JavaScriptCssReferenceContributor.isSimpleCss(StringUtil.unquoteString((String)((PsiElement)element).getText()), true, true);
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        })), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext processingContext) {
                String rawText;
                String text;
                int offset;
                if (psiElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (processingContext == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((offset = JavaScriptReferenceContributor.skipChars(text = StringUtil.unquoteString((String)(rawText = psiElement.getText())), false, true)) == text.length()) {
                    String name;
                    JSReferenceExpression invokedMethod = JSUtils.getMethodNameIfInsideCall(psiElement.getParent());
                    String string = name = invokedMethod != null ? invokedMethod.getReferencedName() : null;
                    if (name != null && name.contains("Class")) {
                        int end;
                        ArrayList<MyCssClassOrIdReference> result2 = new ArrayList<MyCssClassOrIdReference>();
                        int start = 0;
                        while (start < text.length() && (end = JavaScriptCssReferenceContributor.skipChars(text, start, false)) != start) {
                            result2.add(new MyCssClassOrIdReference(psiElement, CssSelectorSuffixType.CLASS, new TextRange(start + 1, end + 1), false, false));
                            if (end == text.length()) break;
                            start = JavaScriptCssReferenceContributor.skipChars(text, end, true);
                        }
                        PsiReference[] psiReferenceArray = result2.isEmpty() ? PsiReference.EMPTY_ARRAY : result2.toArray(PsiReference.EMPTY_ARRAY);
                        if (psiReferenceArray == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return psiReferenceArray;
                    }
                    PsiReference[] psiReferenceArray = new PsiReference[]{new MyCssClassOrIdReference(psiElement, CssSelectorSuffixType.ID, null, false, false)};
                    if (psiReferenceArray == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return psiReferenceArray;
                }
                if (offset == 0 && offset < text.length() && (text.charAt(offset) == '.' || text.charAt(offset) == '#')) {
                    PsiReference[] psiReferenceArray = new PsiReference[]{new MyCssClassOrIdReference(psiElement, text.charAt(0) == '#' ? CssSelectorSuffixType.ID : CssSelectorSuffixType.CLASS, null, true, true)};
                    if (psiReferenceArray == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return psiReferenceArray;
                }
                if (offset < text.length() && (text.charAt(offset) == '.' || text.charAt(offset) == '#')) {
                    CssSelectorSuffixType selectorType = text.charAt(offset) == '#' ? CssSelectorSuffixType.ID : CssSelectorSuffixType.CLASS;
                    PsiReference[] psiReferenceArray = new PsiReference[]{new CssSimpleSelectorReference(psiElement, new TextRange(1, offset + 1)), new MyCssClassOrIdReference(psiElement, selectorType, new TextRange(offset + 1 + 1, text.length() + 1), true, false)};
                    if (psiReferenceArray == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return psiReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    1.$$$reportNull$$$0(6);
                }
                return PsiReference.EMPTY_ARRAY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiElement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "processingContext";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javascript/JavaScriptCssReferenceContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javascript/JavaScriptCssReferenceContributor$1";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(JSLiteralExpression.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                return JavaScriptCssReferenceContributor.isHtmlAttributeReference((PsiElement)element);
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        })), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext processingContext) {
                JSReferenceExpression methodExpression;
                if (psiElement == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (processingContext == null) {
                    3.$$$reportNull$$$0(1);
                }
                CssSelectorSuffixType selectorType = "getElementById".equals((methodExpression = JSUtils.getMethodNameIfInsideCall(psiElement.getParent())).getReferencedName()) ? CssSelectorSuffixType.ID : CssSelectorSuffixType.CLASS;
                PsiReference[] psiReferenceArray = new PsiReference[]{new MyCssClassOrIdReference(psiElement, selectorType, null, false, false)};
                if (psiReferenceArray == null) {
                    3.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiElement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "processingContext";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javascript/JavaScriptCssReferenceContributor$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javascript/JavaScriptCssReferenceContributor$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static boolean isSimpleCss(String text, boolean allowDotsOrSharps, boolean allowWhiteSpaceSeparators) {
        return JavaScriptReferenceContributor.skipChars(text, allowDotsOrSharps, allowWhiteSpaceSeparators) == text.length();
    }

    private static int skipChars(String text, int start, boolean whiteSpace) {
        int result2;
        for (result2 = start; result2 < text.length() && whiteSpace == Character.isWhitespace(text.charAt(result2)); ++result2) {
        }
        return result2;
    }

    private static boolean isHtmlAttributeReference(PsiElement element) {
        if (!(element instanceof JSLiteralExpression) || !((JSLiteralExpression)element).isQuotedLiteral()) {
            return false;
        }
        JSReferenceExpression methodExpression = JSUtils.getMethodNameIfInsideCall(element.getParent());
        if (methodExpression == null) {
            return false;
        }
        String referencedName = methodExpression.getReferencedName();
        return "getElementsByClassName".equals(referencedName) || "getElementById".equals(referencedName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/javascript/JavaScriptCssReferenceContributor", "registerReferenceProviders"));
    }

    private static class MyCssClassOrIdReference
    extends CssClassOrIdReference {
        @NotNull
        private final CssSelectorSuffixType mySelectorType;
        private final boolean myHasExplicitIdMark;
        private final boolean myHasExplicitClassMark;

        public MyCssClassOrIdReference(PsiElement psiElement, @NotNull CssSelectorSuffixType selectorType, @Nullable TextRange range, boolean hasExplicitIdMark, boolean hasExplicitClassMark) {
            if (selectorType == null) {
                MyCssClassOrIdReference.$$$reportNull$$$0(0);
            }
            super(psiElement, range);
            this.mySelectorType = selectorType;
            this.myHasExplicitIdMark = hasExplicitIdMark;
            this.myHasExplicitClassMark = hasExplicitClassMark;
        }

        protected boolean isId() {
            return this.mySelectorType == CssSelectorSuffixType.ID;
        }

        protected boolean hasExplicitIdMark() {
            return this.myHasExplicitIdMark;
        }

        protected boolean hasExplicitClassMark() {
            return this.myHasExplicitClassMark;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorType", "com/intellij/javascript/JavaScriptCssReferenceContributor$MyCssClassOrIdReference", "<init>"));
        }
    }
}

