/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.paint;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.JBUI;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaintUtil {
    /*
     * WARNING - void declaration
     */
    public static ParityMode getParityMode(double usrValue, @NotNull Graphics2D graphics2D) {
        void g;
        if (graphics2D == null) {
            PaintUtil.$$$reportNull$$$0(0);
        }
        return PaintUtil.getParityMode(usrValue, JBUI.ScaleContext.create((Graphics2D)g), null);
    }

    /*
     * WARNING - void declaration
     */
    public static ParityMode getParityMode(double usrValue, @NotNull JBUI.ScaleContext ctx, @Nullable RoundingMode roundingMode) {
        void rm;
        if (ctx == null) {
            PaintUtil.$$$reportNull$$$0(1);
        }
        int devValue = PaintUtil.devValue(usrValue, PaintUtil.getScale(ctx), (RoundingMode)((Object)(rm == null ? RoundingMode.ROUND : rm)));
        return ParityMode.of(devValue);
    }

    /*
     * WARNING - void declaration
     */
    public static double alignToInt(double usrValue, @NotNull Graphics2D graphics2D) {
        void g;
        if (graphics2D == null) {
            PaintUtil.$$$reportNull$$$0(2);
        }
        return PaintUtil.alignToInt(usrValue, JBUI.ScaleContext.create((Graphics2D)g), null, null);
    }

    /*
     * WARNING - void declaration
     */
    public static double alignToInt(double usrValue, @NotNull Graphics2D g, @Nullable RoundingMode roundingMode) {
        void rm;
        if (g == null) {
            PaintUtil.$$$reportNull$$$0(3);
        }
        return PaintUtil.alignToInt(usrValue, JBUI.ScaleContext.create(g), (RoundingMode)rm, null);
    }

    /*
     * WARNING - void declaration
     */
    public static double alignToInt(double usrValue, @NotNull Graphics2D g, @Nullable ParityMode parityMode) {
        void pm;
        if (g == null) {
            PaintUtil.$$$reportNull$$$0(4);
        }
        return PaintUtil.alignToInt(usrValue, JBUI.ScaleContext.create(g), null, (ParityMode)pm);
    }

    /*
     * WARNING - void declaration
     */
    public static double alignToInt(double usrValue, @NotNull JBUI.ScaleContext ctx, @Nullable RoundingMode rm, @Nullable ParityMode parityMode) {
        void pm;
        if (ctx == null) {
            PaintUtil.$$$reportNull$$$0(5);
        }
        if (rm == null) {
            rm = RoundingMode.ROUND;
        }
        double scale = PaintUtil.getScale(ctx);
        int devValue = PaintUtil.devValue(usrValue, scale, pm != null && rm == RoundingMode.ROUND ? RoundingMode.FLOOR : rm);
        if (pm != null && ParityMode.of(devValue) != pm) {
            devValue += rm == RoundingMode.FLOOR ? -1 : 1;
        }
        return (double)devValue / scale;
    }

    /*
     * WARNING - void declaration
     */
    public static double devValue(double usrValue, @NotNull Graphics2D graphics2D) {
        void g;
        if (graphics2D == null) {
            PaintUtil.$$$reportNull$$$0(6);
        }
        return PaintUtil.devValue(usrValue, JBUI.ScaleContext.create((Graphics2D)g));
    }

    /*
     * WARNING - void declaration
     */
    public static double devValue(double usrValue, @NotNull JBUI.ScaleContext scaleContext) {
        void ctx;
        if (scaleContext == null) {
            PaintUtil.$$$reportNull$$$0(7);
        }
        return usrValue * PaintUtil.getScale((JBUI.ScaleContext)ctx);
    }

    private static int devValue(double usrValue, double scale, @Nullable RoundingMode rm) {
        if (rm == null) {
            rm = RoundingMode.ROUND;
        }
        return rm.round(usrValue * scale);
    }

    public static double devPixel(Graphics2D g) {
        return 1.0 / PaintUtil.devValue(1.0, g);
    }

    private static double getScale(JBUI.ScaleContext ctx) {
        return ctx.getScale(JBUI.ScaleType.USR_SCALE) == 0.0 ? 0.0 : ctx.getScale(JBUI.ScaleType.PIX_SCALE) / ctx.getScale(JBUI.ScaleType.USR_SCALE);
    }

    public static AffineTransform alignTxToInt(@NotNull Graphics2D g, boolean alignX, boolean alignY, RoundingMode rm) {
        if (g == null) {
            PaintUtil.$$$reportNull$$$0(8);
        }
        try {
            AffineTransform tx = g.getTransform();
            if (PaintUtil.isFractionalScale(tx)) {
                double scaleX = tx.getScaleX();
                double scaleY = tx.getScaleY();
                AffineTransform alignedTx = new AffineTransform();
                double trX = alignX ? (double)rm.round(tx.getTranslateX()) : tx.getTranslateX();
                double trY = alignY ? (double)rm.round(tx.getTranslateY()) : tx.getTranslateY();
                alignedTx.translate(trX, trY);
                alignedTx.scale(scaleX, scaleY);
                assert (tx.getShearX() == 0.0 && tx.getShearY() == 0.0);
                g.setTransform(alignedTx);
                return tx;
            }
        }
        catch (Exception e) {
            Logger.getInstance("#com.intellij.ui.paint.PaintUtil").error(e);
        }
        return null;
    }

    public static Shape alignClipToInt(@NotNull Graphics2D g, boolean alignH, boolean alignV, RoundingMode xyRM, RoundingMode whRM) {
        Shape clip;
        if (g == null) {
            PaintUtil.$$$reportNull$$$0(9);
        }
        if ((clip = g.getClip()) instanceof Rectangle2D && PaintUtil.isFractionalScale(g.getTransform())) {
            Rectangle2D rect = (Rectangle2D)clip;
            double x = rect.getX();
            double y = rect.getY();
            double w = rect.getWidth();
            double h = rect.getHeight();
            if (alignH) {
                x = PaintUtil.alignToInt(rect.getX(), g, xyRM);
                w = PaintUtil.alignToInt(rect.getX() + rect.getWidth(), g, whRM) - x;
            }
            if (alignV) {
                y = PaintUtil.alignToInt(rect.getY(), g, xyRM);
                h = PaintUtil.alignToInt(rect.getY() + rect.getHeight(), g, whRM) - y;
            }
            g.setClip(new Rectangle2D.Double(x, y, w, h));
            return clip;
        }
        return null;
    }

    public static boolean isFractionalScale(@NotNull AffineTransform tx) {
        if (tx == null) {
            PaintUtil.$$$reportNull$$$0(10);
        }
        double scaleX = tx.getScaleX();
        double scaleY = tx.getScaleY();
        return scaleX != (double)((int)scaleX) || scaleY != (double)((int)scaleY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintWithAA(@NotNull Graphics2D g, @NotNull Object valueAA, @NotNull Runnable paint) {
        if (g == null) {
            PaintUtil.$$$reportNull$$$0(11);
        }
        if (valueAA == null) {
            PaintUtil.$$$reportNull$$$0(12);
        }
        if (paint == null) {
            PaintUtil.$$$reportNull$$$0(13);
        }
        if (valueAA == RenderingHints.VALUE_ANTIALIAS_DEFAULT) {
            paint.run();
            return;
        }
        Object key = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, valueAA);
        try {
            paint.run();
        }
        finally {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, key);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tx";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueAA";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paint";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/paint/PaintUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getParityMode";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "alignToInt";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "devValue";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "alignTxToInt";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "alignClipToInt";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isFractionalScale";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "paintWithAA";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum ParityMode {
        EVEN,
        ODD;


        public boolean even() {
            return this == EVEN;
        }

        public static ParityMode of(int value) {
            return value % 2 == 0 ? EVEN : ODD;
        }

        public static ParityMode invert(ParityMode pm) {
            return pm == EVEN ? ODD : EVEN;
        }
    }

    public static enum RoundingMode {
        FLOOR{

            @Override
            public int round(double value) {
                return (int)Math.floor(value);
            }
        }
        ,
        CEIL{

            @Override
            public int round(double value) {
                return (int)Math.ceil(value);
            }
        }
        ,
        ROUND{

            @Override
            public int round(double value) {
                return (int)Math.round(value);
            }
        };


        public abstract int round(double var1);
    }
}

