/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.docker.console;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.DockerCredentialsType;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteProcess;
import com.intellij.util.net.NetUtils;
import com.jetbrains.python.console.PydevRemoteConsoleCommunication;
import com.jetbrains.python.console.PythonConsoleRemoteProcessCreator;
import com.jetbrains.python.console.RemoteConsoleProcessData;
import com.jetbrains.python.debugger.PySourcePosition;
import com.jetbrains.python.docker.DockerNetworkUtilKt;
import com.jetbrains.python.docker.PyDockerProcessConnectionData;
import com.jetbrains.python.docker.PyDockerProcessUtil;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteProcessHandler;
import com.jetbrains.python.remote.PyRemoteProcessHandlerBase;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002JH\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0012H\u0017R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006!"}, d2={"Lcom/jetbrains/python/docker/console/PythonConsoleDockerProcessCreator;", "Lcom/jetbrains/python/console/PythonConsoleRemoteProcessCreator;", "Lcom/intellij/docker/remote/DockerCredentialsHolder;", "()V", "credentialsType", "Lcom/intellij/remote/CredentialsType;", "getCredentialsType", "()Lcom/intellij/remote/CredentialsType;", "createDefaultVolumeBindings", "Ljava/util/ArrayList;", "Lcom/intellij/docker/agent/settings/DockerVolumeBindingImpl;", "Lkotlin/collections/ArrayList;", "project", "Lcom/intellij/openapi/project/Project;", "createPythonConsolePortBindings", "", "Lcom/intellij/docker/agent/settings/DockerPortBindingImpl;", "pythonConsolePort", "", "createRemoteConsoleProcess", "Lcom/jetbrains/python/console/RemoteConsoleProcessData;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "pathMapper", "Lcom/jetbrains/python/remote/PyRemotePathMapper;", "data", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;", "runnerFileFromHelpers", "", "credentials", "scriptPort", "idePort", "Companion", "intellij.python.docker"})
public final class PythonConsoleDockerProcessCreator
implements PythonConsoleRemoteProcessCreator<DockerCredentialsHolder> {
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public CredentialsType<DockerCredentialsHolder> getCredentialsType() {
        DockerCredentialsType dockerCredentialsType = DockerCredentialsType.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)dockerCredentialsType, (String)"DockerCredentialsType.getInstance()");
        return (CredentialsType)dockerCredentialsType;
    }

    @NotNull
    public RemoteConsoleProcessData createRemoteConsoleProcess(@NotNull GeneralCommandLine commandLine, @NotNull PyRemotePathMapper pathMapper, @NotNull Project project, @NotNull PyRemoteSdkAdditionalDataBase data, @NotNull String runnerFileFromHelpers, @NotNull DockerCredentialsHolder credentials, int scriptPort, int idePort) throws ExecutionException {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        Intrinsics.checkParameterIsNotNull((Object)pathMapper, (String)"pathMapper");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)runnerFileFromHelpers, (String)"runnerFileFromHelpers");
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        ParametersList parametersList = commandLine.getParametersList();
        Intrinsics.checkExpressionValueIsNotNull((Object)parametersList, (String)"commandLine.parametersList");
        String[] command = parametersList.getArray();
        Map env = commandLine.getEnvironment();
        File workDirectory = commandLine.getWorkDirectory();
        GeneralCommandLine patchedCommandLine = new GeneralCommandLine();
        patchedCommandLine.setWorkDirectory(workDirectory);
        patchedCommandLine.withParameters(Arrays.copyOf(command, command.length));
        Map map = patchedCommandLine.getEnvironment();
        Map map2 = env;
        Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"env");
        map.putAll(map2);
        patchedCommandLine.getParametersList().set(0, PythonRemoteInterpreterManager.toSystemDependent((String)new File(data.getHelpersPath(), runnerFileFromHelpers).getPath(), (boolean)PySourcePosition.isWindowsPath((String)data.getInterpreterPath())));
        try {
            PyRemoteProcessHandler remoteProcessHandlerBase;
            int[] availableSocketPorts = NetUtils.findAvailableSocketPorts((int)2);
            DockerCloudConfiguration configuration = DockerNetworkUtilKt.getDockerCloudConfiguration(credentials);
            String serverHost = DockerNetworkUtilKt.getHostAddress(configuration);
            int serverPort = availableSocketPorts[0];
            String clientHost = DockerNetworkUtilKt.getINADDR_ANY();
            int clientPort = availableSocketPorts[1];
            patchedCommandLine.getParametersList().set(1, Integer.toString(clientPort));
            patchedCommandLine.getParametersList().set(2, Integer.toString(serverPort));
            patchedCommandLine.getParametersList().add(clientHost);
            patchedCommandLine.getParametersList().add(serverHost);
            DockerContainerSettings dockerContainerSettings = new DockerContainerSettings();
            dockerContainerSettings.setVolumeBindings((List)this.createDefaultVolumeBindings(project));
            dockerContainerSettings.setPortBindings(this.createPythonConsolePortBindings(clientPort));
            patchedCommandLine.putUserData(DockerContainerSettings.KEY, (Object)dockerContainerSettings);
            PyDockerProcessConnectionData connectionData = PyDockerProcessUtil.getPyDockerProcessConnectionData(data);
            PyRemoteProcessHandler pyRemoteProcessHandler = remoteProcessHandlerBase = PyDockerProcessUtil.startDockerProcess(project, connectionData, patchedCommandLine, pathMapper);
            Intrinsics.checkExpressionValueIsNotNull((Object)pyRemoteProcessHandler, (String)"remoteProcessHandlerBase");
            RemoteProcess remoteProcess = (RemoteProcess)pyRemoteProcessHandler.getProcess();
            Logger logger = PythonConsoleDockerProcessCreator.Companion.getLOG();
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
            if (logger.isDebugEnabled()) {
                PythonConsoleDockerProcessCreator.Companion.getLOG().debug("Using communication for Python console: port " + serverPort + " on IDE side, port " + clientPort + " on pydevconsole.py side");
            }
            String dockerHost = DockerNetworkUtilKt.getDockerEngineAddress(configuration);
            Logger logger2 = PythonConsoleDockerProcessCreator.Companion.getLOG();
            Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"LOG");
            if (logger2.isDebugEnabled()) {
                Logger logger3 = PythonConsoleDockerProcessCreator.Companion.getLOG();
                StringBuilder stringBuilder = new StringBuilder().append("Using ");
                String string = dockerHost;
                if (string == null) {
                    string = "loopback interface";
                }
                logger3.debug(stringBuilder.append(string).append(" address to connect to pydevconsole.py side").toString());
            }
            PydevRemoteConsoleCommunication pydevConsoleCommunication = new PydevRemoteConsoleCommunication(project, clientPort, (Process)remoteProcess, serverPort, dockerHost);
            return new RemoteConsoleProcessData((PyRemoteProcessHandlerBase)remoteProcessHandlerBase, pydevConsoleCommunication);
        }
        catch (Exception e) {
            throw (Throwable)new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private final List<DockerPortBindingImpl> createPythonConsolePortBindings(int pythonConsolePort) {
        DockerPortBindingImpl portBinding = new DockerPortBindingImpl();
        portBinding.setHostIp(DockerNetworkUtilKt.getINADDR_ANY());
        portBinding.setHostPort(Integer.valueOf(pythonConsolePort));
        portBinding.setContainerPort(pythonConsolePort);
        return CollectionsKt.arrayListOf((Object[])new DockerPortBindingImpl[]{portBinding});
    }

    private final ArrayList<DockerVolumeBindingImpl> createDefaultVolumeBindings(Project project) {
        return CollectionsKt.arrayListOf((Object[])new DockerVolumeBindingImpl[]{new DockerVolumeBindingImpl("/opt/project", project.getBasePath(), false)});
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance((String)PythonConsoleDockerProcessCreator.class.getName());
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/docker/console/PythonConsoleDockerProcessCreator$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.python.docker"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

