/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.docker.compose.debugger;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.compose.configuration.beans.common.DockerComposePort;
import com.intellij.docker.compose.service.DockerComposeServiceClient;
import com.intellij.docker.compose.service.commands.ComposeServiceUpCmd;
import com.intellij.docker.compose.service.commands.SharedVolume;
import com.intellij.docker.remote.DockerComposeCredentialsType;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.docker.remote.run.runtime.WrappedInternalServerErrorException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.AbstractPathMapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathMapper;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.plugins.remotesdk.RemoteProcessUtil;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.docker.PyDockerProcessUtil;
import com.jetbrains.python.docker.compose.DockerComposeProcessStarterManager;
import com.jetbrains.python.docker.compose.PyDockerComposeProcessConnectionData;
import com.jetbrains.python.docker.debugger.PyDockerDebugSessionFactoryBase;
import com.jetbrains.python.docker.remote.PyDockerComposeProcessHandler;
import com.jetbrains.python.remote.PyCommandLineStateUtil;
import com.jetbrains.python.remote.PyRemoteInterpreterManagerImpl;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import com.jetbrains.python.remote.PySshCommandLineStateUtil;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.sdk.PythonEnvUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDockerComposeDebugSessionFactory
extends PyDockerDebugSessionFactoryBase {
    protected boolean appliesTo(@NotNull Sdk sdk) {
        if (sdk == null) {
            PyDockerComposeDebugSessionFactory.$$$reportNull$$$0(0);
        }
        return PyDockerComposeDebugSessionFactory.appliesTo(sdk, (CredentialsType)DockerComposeCredentialsType.getInstance());
    }

    @Override
    @NotNull
    protected PyDebugProcess createDebugProcess(@NotNull XDebugSession session, @NotNull ExecutionResult result, @NotNull String host, int port) {
        if (session == null) {
            PyDockerComposeDebugSessionFactory.$$$reportNull$$$0(1);
        }
        if (result == null) {
            PyDockerComposeDebugSessionFactory.$$$reportNull$$$0(2);
        }
        if (host == null) {
            PyDockerComposeDebugSessionFactory.$$$reportNull$$$0(3);
        }
        PyDebugProcess pyDebugProcess = new PyDebugProcess(session, result.getExecutionConsole(), result.getProcessHandler(), host, port){

            protected void detachDebuggedProcess() {
                this.getProcessHandler().waitFor();
            }
        };
        if (pyDebugProcess == null) {
            PyDockerComposeDebugSessionFactory.$$$reportNull$$$0(4);
        }
        return pyDebugProcess;
    }

    @Override
    @NotNull
    protected ExecutionResult executeDebuggingScript(@NotNull PythonCommandLineState pyState, @NotNull PyRemoteSdkAdditionalData remoteSdkAdditionalData, @NotNull ExecutionEnvironment environment, int serverPort) throws ExecutionException {
        if (pyState == null) {
            PyDockerComposeDebugSessionFactory.$$$reportNull$$$0(5);
        }
        if (remoteSdkAdditionalData == null) {
            PyDockerComposeDebugSessionFactory.$$$reportNull$$$0(6);
        }
        if (environment == null) {
            PyDockerComposeDebugSessionFactory.$$$reportNull$$$0(7);
        }
        Project project = environment.getProject();
        RunProfile profile = environment.getRunProfile();
        Executor executor = environment.getExecutor();
        ExecutionResult executionResult = pyState.execute(executor, this.createDockerComposeProcessStarter(project, remoteSdkAdditionalData, serverPort), this.createCommandLinePatchers(project, pyState, profile, serverPort));
        if (executionResult == null) {
            PyDockerComposeDebugSessionFactory.$$$reportNull$$$0(8);
        }
        return executionResult;
    }

    @NotNull
    private PythonCommandLineState.PythonProcessStarter createDockerComposeProcessStarter(@NotNull Project project, @NotNull PyRemoteSdkAdditionalData additionalData, int serverPort) {
        if (project == null) {
            PyDockerComposeDebugSessionFactory.$$$reportNull$$$0(9);
        }
        if (additionalData == null) {
            PyDockerComposeDebugSessionFactory.$$$reportNull$$$0(10);
        }
        PythonCommandLineState.PythonProcessStarter pythonProcessStarter = (config, commandLine) -> {
            if (project == null) {
                PyDockerComposeDebugSessionFactory.$$$reportNull$$$0(19);
            }
            if (additionalData == null) {
                PyDockerComposeDebugSessionFactory.$$$reportNull$$$0(20);
            }
            return this.startDockerComposeProcess(config, commandLine, project, additionalData, serverPort);
        };
        if (pythonProcessStarter == null) {
            PyDockerComposeDebugSessionFactory.$$$reportNull$$$0(11);
        }
        return pythonProcessStarter;
    }

    @NotNull
    protected ProcessHandler startDockerComposeProcess(@NotNull AbstractPythonRunConfiguration config, @NotNull GeneralCommandLine commandLine, @NotNull Project project, @NotNull PyRemoteSdkAdditionalData remoteSdkAdditionalData, int serverPort) throws ExecutionException {
        PyDockerComposeProcessHandler processHandler;
        ParamsGroup coverageParams;
        ParamsGroup profileParams;
        if (config == null) {
            PyDockerComposeDebugSessionFactory.$$$reportNull$$$0(12);
        }
        if (commandLine == null) {
            PyDockerComposeDebugSessionFactory.$$$reportNull$$$0(13);
        }
        if (project == null) {
            PyDockerComposeDebugSessionFactory.$$$reportNull$$$0(14);
        }
        if (remoteSdkAdditionalData == null) {
            PyDockerComposeDebugSessionFactory.$$$reportNull$$$0(15);
        }
        PyRemotePathMapper pathMapper = PyDockerComposeDebugSessionFactory.createRemotePathMapper(config);
        PyRemotePathMapper extendedPathMapper = PyRemoteInterpreterManagerImpl.appendBasicMappings((Project)project, (PyRemotePathMapper)pathMapper, (RemoteSdkAdditionalData)remoteSdkAdditionalData);
        PathMappingSettings additionalMappings = (PathMappingSettings)commandLine.getUserData(PythonRemoteInterpreterManager.ADDITIONAL_MAPPINGS);
        PyDockerComposeProcessConnectionData processConnectionData = PyDockerProcessUtil.getPyDockerComposeProcessConnectionData((PyRemoteSdkAdditionalDataBase)remoteSdkAdditionalData);
        ParamsGroup exeGroup = commandLine.getParametersList().getParamsGroup("Exe Options");
        if (exeGroup != null) {
            PythonRemoteInterpreterManager.addUnbuffered((ParamsGroup)exeGroup);
        }
        PyRemoteSocketToLocalHostProvider dockerSocketProvider = processConnectionData.getPyRemoteSocketToLocalHostProvider();
        ParamsGroup debugParams = commandLine.getParametersList().getParamsGroup("Debugger");
        if (debugParams != null && debugParams.getParameters().size() > 0) {
            PyDockerProcessUtil.patchDebugParams(processConnectionData.getHelpersPath(), debugParams);
        }
        if ((profileParams = commandLine.getParametersList().getParamsGroup("Profiler")) != null && profileParams.getParameters().size() > 0) {
            PySshCommandLineStateUtil.patchProfileParams((String)processConnectionData.getInterpreterPath(), (PyRemoteSocketToLocalHostProvider)dockerSocketProvider, (ParamsGroup)profileParams, (File)commandLine.getWorkDirectory(), (PathMapper)extendedPathMapper);
        }
        if ((coverageParams = commandLine.getParametersList().getParamsGroup("Coverage")) != null && coverageParams.getParameters().size() > 0) {
            PySshCommandLineStateUtil.patchCoverageParams((String)processConnectionData.getInterpreterPath(), (ParamsGroup)coverageParams, (File)commandLine.getWorkDirectory(), (PathMapper)extendedPathMapper);
        }
        PyCommandLineStateUtil.remap((String)processConnectionData.getInterpreterPath(), (GeneralCommandLine)commandLine, (PathMapper)extendedPathMapper);
        if (commandLine.getWorkDirectory() != null) {
            commandLine.setWorkDirectory(extendedPathMapper.convertToRemote(commandLine.getWorkDirectory().getPath()));
        }
        String[] command = ArrayUtil.toStringArray((Collection)commandLine.getCommandLineList(null));
        String workingDir = commandLine.getWorkDirectory() != null ? commandLine.getWorkDirectory().getPath() : null;
        VolumesBuilder volumesBinds = DockerComposeProcessStarterManager.setupVolumeBinds(project, additionalMappings);
        Pair commandWithWorkingDir = RemoteProcessUtil.buildRemoteCommandLine((AbstractPathMapper)extendedPathMapper, (String[])command, (String)workingDir, (String)processConnectionData.getInterpreterPath());
        HashMap env = ContainerUtil.newHashMap((Map)commandLine.getEnvironment());
        PythonEnvUtil.setPythonUnbuffered((Map)env);
        try {
            RemoteDockerRuntime dockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)processConnectionData.getAccount(), (Project)project);
            SharedVolume helpersSharedVolume = PyDockerProcessUtil.getPyCharmHelpersSharedVolume(dockerRuntime);
            DockerComposeServiceClient serviceClient = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime);
            ComposeServiceUpCmd upServicesCmd = (ComposeServiceUpCmd)((ComposeServiceUpCmd)((ComposeServiceUpCmd)((ComposeServiceUpCmd)((ComposeServiceUpCmd)((ComposeServiceUpCmd)((ComposeServiceUpCmd)((ComposeServiceUpCmd)((ComposeServiceUpCmd)serviceClient.upServicesCmd().withConfigurationPath(processConnectionData.getComposeFilePaths())).withEnvs(processConnectionData.getEnvs())).withServiceName(processConnectionData.getComposeServiceName())).withEnvironment((Map)env)).withCommand((String[])commandWithWorkingDir.getFirst())).withWorkingDir((String)commandWithWorkingDir.getSecond())).withSharedVolume(helpersSharedVolume)).withVolumes(DockerComposeProcessStarterManager.removeRepeatedContainerPaths(volumesBinds.build()))).withPorts(Collections.singletonList(new DockerComposePort("0.0.0.0", Integer.valueOf(serverPort), Integer.valueOf(serverPort))));
            processHandler = new PyDockerComposeProcessHandler(upServicesCmd.buildCommandLine(), extendedPathMapper, dockerSocketProvider);
        }
        catch (WrappedInternalServerErrorException e) {
            throw DockerUtil.propagateInternalServerErrorException((ServerRuntimeException)((Object)e));
        }
        catch (ServerRuntimeException | IOException e) {
            throw DockerUtil.propagateRemoteSdkException((Throwable)e);
        }
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        PyDockerComposeProcessHandler pyDockerComposeProcessHandler = processHandler;
        if (pyDockerComposeProcessHandler == null) {
            PyDockerComposeDebugSessionFactory.$$$reportNull$$$0(16);
        }
        return pyDockerComposeProcessHandler;
    }

    @Nullable
    private static PyRemotePathMapper createRemotePathMapper(AbstractPythonRunConfiguration<?> config) {
        if (config.getMappingSettings() == null) {
            return null;
        }
        return PyRemotePathMapper.fromSettings((PathMappingSettings)config.getMappingSettings(), (PyRemotePathMapper.PyPathMappingType)PyRemotePathMapper.PyPathMappingType.USER_DEFINED);
    }

    @Override
    protected void configureExtraDebugParameters(@NotNull Project project, int serverLocalPort, @NotNull GeneralCommandLine cmd) {
        if (project == null) {
            PyDockerComposeDebugSessionFactory.$$$reportNull$$$0(17);
        }
        if (cmd == null) {
            PyDockerComposeDebugSessionFactory.$$$reportNull$$$0(18);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/docker/compose/debugger/PyDockerComposeDebugSessionFactory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyState";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteSdkAdditionalData";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 9: 
            case 14: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/docker/compose/debugger/PyDockerComposeDebugSessionFactory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDebugProcess";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "executeDebuggingScript";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createDockerComposeProcessStarter";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "startDockerComposeProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appliesTo";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDebugProcess";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 16: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "executeDebuggingScript";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDockerComposeProcessStarter";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "startDockerComposeProcess";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "configureExtraDebugParameters";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createDockerComposeProcessStarter$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

