/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.docker.compose.console;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.compose.configuration.beans.common.DockerComposePort;
import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.docker.remote.DockerComposeCredentialsType;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.remote.CredentialsType;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.net.NetUtils;
import com.jetbrains.python.console.PydevRemoteConsoleCommunication;
import com.jetbrains.python.console.PythonConsoleRemoteProcessCreator;
import com.jetbrains.python.console.RemoteConsoleProcessData;
import com.jetbrains.python.debugger.PySourcePosition;
import com.jetbrains.python.docker.DockerNetworkUtilKt;
import com.jetbrains.python.docker.PyDockerProcessUtil;
import com.jetbrains.python.docker.compose.PyDockerComposeProcessConnectionData;
import com.jetbrains.python.docker.compose.console.PythonConsoleDockerComposeProcessCreatorKt;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0003JH\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0017R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/python/docker/compose/console/PythonConsoleDockerComposeProcessCreator;", "Lcom/jetbrains/python/console/PythonConsoleRemoteProcessCreator;", "Lcom/intellij/docker/remote/DockerComposeCredentialsHolder;", "()V", "credentialsType", "Lcom/intellij/remote/CredentialsType;", "getCredentialsType", "()Lcom/intellij/remote/CredentialsType;", "createRemoteConsoleProcess", "Lcom/jetbrains/python/console/RemoteConsoleProcessData;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "pathMapper", "Lcom/jetbrains/python/remote/PyRemotePathMapper;", "project", "Lcom/intellij/openapi/project/Project;", "data", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;", "runnerFileFromHelpers", "", "credentials", "scriptPort", "", "idePort", "Companion", "intellij.python.docker"})
public final class PythonConsoleDockerComposeProcessCreator
implements PythonConsoleRemoteProcessCreator<DockerComposeCredentialsHolder> {
    private static final Logger LOG;
    private static final String DOCKER_CONTAINER_PROJECT_PATH = "/opt/project";
    public static final Companion Companion;

    @NotNull
    public CredentialsType<DockerComposeCredentialsHolder> getCredentialsType() {
        DockerComposeCredentialsType dockerComposeCredentialsType = DockerComposeCredentialsType.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)dockerComposeCredentialsType, (String)"DockerComposeCredentialsType.getInstance()");
        return (CredentialsType)dockerComposeCredentialsType;
    }

    @NotNull
    public RemoteConsoleProcessData createRemoteConsoleProcess(@NotNull GeneralCommandLine commandLine, @NotNull PyRemotePathMapper pathMapper, @NotNull Project project, @NotNull PyRemoteSdkAdditionalDataBase data, @NotNull String runnerFileFromHelpers, @NotNull DockerComposeCredentialsHolder credentials, int scriptPort, int idePort) throws ExecutionException {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        Intrinsics.checkParameterIsNotNull((Object)pathMapper, (String)"pathMapper");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)runnerFileFromHelpers, (String)"runnerFileFromHelpers");
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        ParametersList parametersList = commandLine.getParametersList();
        Intrinsics.checkExpressionValueIsNotNull((Object)parametersList, (String)"commandLine.parametersList");
        String[] command = parametersList.getArray();
        Map env = commandLine.getEnvironment();
        File workDirectory = commandLine.getWorkDirectory();
        GeneralCommandLine patchedCommandLine = new GeneralCommandLine();
        patchedCommandLine.setWorkDirectory(workDirectory);
        patchedCommandLine.withParameters(Arrays.copyOf(command, command.length));
        Map map = patchedCommandLine.getEnvironment();
        Map map2 = env;
        Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"env");
        map.putAll(map2);
        patchedCommandLine.getParametersList().set(0, PythonRemoteInterpreterManager.toSystemDependent((String)new File(data.getHelpersPath(), runnerFileFromHelpers).getPath(), (boolean)PySourcePosition.isWindowsPath((String)data.getInterpreterPath())));
        try {
            patchedCommandLine.putUserData(PythonRemoteInterpreterManager.ADDITIONAL_MAPPINGS, (Object)PythonConsoleDockerComposeProcessCreator.Companion.buildDockerPathMappings(project));
            int[] availableSocketPorts = NetUtils.findAvailableSocketPorts((int)2);
            DockerCloudConfiguration configuration = DockerNetworkUtilKt.getDockerCloudConfiguration(credentials);
            String serverHost = DockerNetworkUtilKt.getHostAddress(configuration);
            int serverPort = availableSocketPorts[0];
            String clientHost = DockerNetworkUtilKt.getINADDR_ANY();
            int clientPort = availableSocketPorts[1];
            patchedCommandLine.getParametersList().set(1, Integer.toString(clientPort));
            patchedCommandLine.getParametersList().set(2, Integer.toString(serverPort));
            patchedCommandLine.getParametersList().add(clientHost);
            patchedCommandLine.getParametersList().add(serverHost);
            List portBindings = CollectionsKt.listOf((Object)new DockerComposePort(DockerNetworkUtilKt.getINADDR_ANY(), Integer.valueOf(clientPort), Integer.valueOf(clientPort)));
            BaseOSProcessHandler processHandler = PythonConsoleDockerComposeProcessCreatorKt.access$startDockerComposeProcess(project, patchedCommandLine, data, pathMapper, portBindings);
            Process process = processHandler.getProcess();
            Logger logger = PythonConsoleDockerComposeProcessCreator.Companion.getLOG();
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
            if (logger.isDebugEnabled()) {
                PythonConsoleDockerComposeProcessCreator.Companion.getLOG().debug("Using communication for Python console: port " + serverPort + " on IDE side, port " + clientPort + " on pydevconsole.py side");
            }
            String dockerHost = DockerNetworkUtilKt.getDockerEngineAddress(configuration);
            Logger logger2 = PythonConsoleDockerComposeProcessCreator.Companion.getLOG();
            Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"LOG");
            if (logger2.isDebugEnabled()) {
                Logger logger3 = PythonConsoleDockerComposeProcessCreator.Companion.getLOG();
                StringBuilder stringBuilder = new StringBuilder().append("Using ");
                String string = dockerHost;
                if (string == null) {
                    string = "loopback interface";
                }
                logger3.debug(stringBuilder.append(string).append(" address to connect to pydevconsole.py side").toString());
            }
            PydevRemoteConsoleCommunication pydevConsoleCommunication = new PydevRemoteConsoleCommunication(project, clientPort, process, serverPort, dockerHost);
            PyDockerComposeProcessConnectionData pyDockerComposeProcessConnectionData = PyDockerProcessUtil.getPyDockerComposeProcessConnectionData(data);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pyDockerComposeProcessConnectionData), (String)"PyDockerProcessUtil.getP\u2026ocessConnectionData(data)");
            PyRemoteSocketToLocalHostProvider socketProvider = pyDockerComposeProcessConnectionData.getPyRemoteSocketToLocalHostProvider();
            ProcessHandler processHandler2 = (ProcessHandler)processHandler;
            String string = processHandler.getCommandLine();
            Process process2 = process;
            Intrinsics.checkExpressionValueIsNotNull((Object)process2, (String)"process");
            PyRemoteSocketToLocalHostProvider pyRemoteSocketToLocalHostProvider = socketProvider;
            Intrinsics.checkExpressionValueIsNotNull((Object)pyRemoteSocketToLocalHostProvider, (String)"socketProvider");
            return new RemoteConsoleProcessData(processHandler2, pydevConsoleCommunication, string, process2, pyRemoteSocketToLocalHostProvider);
        }
        catch (Exception e) {
            throw (Throwable)new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance((String)PythonConsoleDockerComposeProcessCreator.class.getName());
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/docker/compose/console/PythonConsoleDockerComposeProcessCreator$Companion;", "", "()V", "DOCKER_CONTAINER_PROJECT_PATH", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "buildDockerPathMappings", "Lcom/intellij/util/PathMappingSettings;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.python.docker"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        private final PathMappingSettings buildDockerPathMappings(Project project) {
            return new PathMappingSettings(CollectionsKt.listOf((Object)new PathMappingSettings.PathMapping(project.getBasePath(), PythonConsoleDockerComposeProcessCreator.DOCKER_CONTAINER_PROJECT_PATH)));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

