/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.docker;

import com.google.common.base.Joiner;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.compose.configuration.beans.common.RestartPolicy;
import com.intellij.docker.compose.remote.process.DockerComposeProcessUtil;
import com.intellij.docker.compose.service.DockerComposeServiceClient;
import com.intellij.docker.compose.service.commands.ComposeServiceRunCmd;
import com.intellij.docker.compose.service.commands.SharedVolume;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remote.run.runtime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.AbstractPathMapper;
import com.intellij.util.ArrayUtil;
import com.jetbrains.plugins.remotesdk.RemoteProcessUtil;
import com.jetbrains.python.docker.PyDockerProcessUtil;
import com.jetbrains.python.docker.PyDockerSkeletonGeneratorBase;
import com.jetbrains.python.docker.compose.PyDockerComposeProcessConnectionData;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.sdk.InvalidSdkException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDockerComposeSkeletonGenerator
extends PyDockerSkeletonGeneratorBase {
    private static final String ROOT_USER_ID = "0";

    public PyDockerComposeSkeletonGenerator(@Nullable Project project, @NotNull String skeletonsPath, @NotNull Sdk sdk) {
        if (skeletonsPath == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(0);
        }
        if (sdk == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(1);
        }
        super(project, skeletonsPath, sdk);
    }

    @NotNull
    protected ProcessOutput getProcessOutput(@NotNull String homePath, @NotNull String[] commandLine, @Nullable Map<String, String> extraEnv, int timeout) throws InvalidSdkException {
        ProcessOutput processOutput;
        if (homePath == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(2);
        }
        if (commandLine == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(3);
        }
        Object[] extendedCommandLine = PyDockerComposeSkeletonGenerator.addUnbuffered((String)homePath, (String[])commandLine);
        try {
            ComposeServiceRunCmd serviceRunCmd = this.buildDockerComposeRunCmd(extraEnv, (String[])extendedCommandLine).withRemove(true);
            processOutput = new CapturingProcessRunner((BaseProcessHandler)serviceRunCmd.execute()).runProcess(timeout);
        }
        catch (ProcessNotCreatedException e) {
            LOG.debug("Unable to execute command ", new Object[]{Joiner.on((String)" ").join(extendedCommandLine), e});
            DockerComposeCliUtil.notifyDockerComposeExecutionFailed((Project)this.getProject(), (ProcessNotCreatedException)e);
            throw PyDockerComposeSkeletonGenerator.propagateRecoverableException((Exception)((Object)e));
        }
        catch (ExecutionException | ServerRuntimeException | IOException e) {
            LOG.debug("Unable to execute command ", new Object[]{Joiner.on((String)" ").join(extendedCommandLine), e});
            throw PyDockerComposeSkeletonGenerator.propagateRecoverableException((Exception)e);
        }
        if (processOutput == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(4);
        }
        return processOutput;
    }

    @NotNull
    private ComposeServiceRunCmd buildDockerComposeRunCmd(@Nullable Map<String, String> extraEnv, @NotNull String[] extendedCommandLine) throws ServerRuntimeException, RemoteSdkException, IOException {
        if (extendedCommandLine == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(5);
        }
        PyDockerComposeProcessConnectionData data = this.getProcessConnectionData();
        PyRemotePathMapper pathMapper = this.createPathMappings(this.getProject(), (PyRemoteSdkAdditionalDataBase)this.getRemoteSdkAdditionalData());
        Pair commandWithWorkingDir = RemoteProcessUtil.buildRemoteCommandLine((AbstractPathMapper)pathMapper, (String[])extendedCommandLine, null, (String)data.getInterpreterPath());
        RemoteDockerRuntime dockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)data.getAccount(), (Project)this.getProject());
        SharedVolume helpersSharedVolume = PyDockerProcessUtil.getPyCharmHelpersSharedVolume(dockerRuntime);
        String skeletonsVolume = this.prepareSkeletonsVolume();
        VolumesBuilder volumesBinds = VolumesBuilder.builder();
        volumesBinds.addBoundVolume(this.getRemoteSkeletonsPath(), skeletonsVolume);
        ComposeServiceRunCmd composeServiceRunCmd = (ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime).runServiceCmd().withConfigurationPath(data.getComposeFilePaths())).withEnvs(data.getEnvs())).withServiceName(data.getComposeServiceName())).withCommand((String[])commandWithWorkingDir.getFirst())).withWorkingDir((String)commandWithWorkingDir.getSecond())).withEnvironment(extraEnv)).withSharedVolume(helpersSharedVolume)).withVolumes(volumesBinds.build())).withRestartPolicy((RestartPolicy)RestartPolicy.noRestart());
        if (composeServiceRunCmd == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(6);
        }
        return composeServiceRunCmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessOutput runSkeletonGeneration(String modname, String modfilename, List<String> assemblyRefs, String binaryPath, String extraSyspath) throws InvalidSdkException {
        try {
            Object object = this.getSkeletonGenerationContainerLock();
            synchronized (object) {
                RemoteDockerApplicationRuntime skeletonGenerationContainer = this.getSkeletonGenerationContainer();
                if (skeletonGenerationContainer == null) {
                    String containerName = "skeleton_generator_" + FileUtil.toSystemIndependentName((String)this.getSdk().getHomePath()).hashCode();
                    RemoteDockerApplicationRuntime obsoleteContainer = this.createDockerRuntime().findContainerByName(containerName);
                    if (obsoleteContainer != null) {
                        LOG.debug("Obsolete skeleton generation container " + containerName + " found and it will be removed");
                        obsoleteContainer.removeContainer();
                    }
                    String parentDir = new File(binaryPath).getParent();
                    List<String> commandLine = this.buildSkeletonGeneratorCommandLine(binaryPath, extraSyspath, this.getSkeletonsPath());
                    String[] extendedCommandLine = PyDockerComposeSkeletonGenerator.addUnbuffered((String)parentDir, (String[])ArrayUtil.toStringArray(commandLine));
                    ComposeServiceRunCmd dockerComposeRunCmd = this.buildDockerComposeRunCmd(null, extendedCommandLine).withName(containerName);
                    dockerComposeRunCmd.execute();
                    try {
                        skeletonGenerationContainer = DockerComposeProcessUtil.waitForContainer((RemoteDockerRuntime)dockerComposeRunCmd.getDockerRuntime(), (String)containerName);
                    }
                    catch (InterruptedException e) {
                        throw new InvalidSdkException("Interrupted", (Throwable)e);
                    }
                    this.setSkeletonGenerationContainer(skeletonGenerationContainer);
                    skeletonGenerationContainer.attach();
                } else {
                    skeletonGenerationContainer.startAndAttach();
                }
                try (PrintStream stdin = new PrintStream(skeletonGenerationContainer.getStdin());){
                    PyDockerComposeSkeletonGenerator.printToContainer(stdin, modname, modfilename, assemblyRefs);
                }
                return skeletonGenerationContainer.wait4AndGetOutput();
            }
        }
        catch (ProcessNotCreatedException e) {
            LOG.debug("Skeleton generation for " + modname + " failed", (Throwable)e);
            DockerComposeCliUtil.notifyDockerComposeExecutionFailed((Project)this.getProject(), (ProcessNotCreatedException)e);
            throw PyDockerComposeSkeletonGenerator.propagateRecoverableException((Exception)((Object)e));
        }
        catch (ExecutionException | ServerRuntimeException | IOException e) {
            LOG.debug("Skeleton generation for " + modname + " failed", e);
            throw PyDockerComposeSkeletonGenerator.propagateRecoverableException((Exception)e);
        }
    }

    private static void printToContainer(@NotNull PrintStream stdin, @NotNull String modname, @Nullable String modfilename, @Nullable List<String> assemblyRefs) {
        if (stdin == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(7);
        }
        if (modname == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(8);
        }
        stdin.println(modname);
        stdin.println(modfilename);
        stdin.println(assemblyRefs != null ? StringUtil.join(assemblyRefs, (String)";") : "");
        stdin.flush();
    }

    @Override
    @NotNull
    protected String setupSkeletonsVolume() throws ExecutionException, ServerRuntimeException {
        String volumeName = this.getSkeletonsVolumeName();
        PyDockerComposeProcessConnectionData data = this.getProcessConnectionData();
        String serviceName = data.getComposeServiceName();
        RemoteDockerRuntime dockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)data.getAccount(), (Project)this.getProject());
        String user = PyDockerComposeSkeletonGenerator.getServiceUser(dockerRuntime, data, serviceName);
        if (StringUtil.isNotEmpty((String)user)) {
            LOG.debug("User for service \"" + serviceName + "\" is " + user + ", permissions setup for skeletons volume \"" + volumeName + "\" required");
            this.changeOwnerForVolume(dockerRuntime, data, user, volumeName);
        } else {
            LOG.debug("User for service \"" + serviceName + "\" is default (root)");
        }
        String string = volumeName;
        if (string == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(9);
        }
        return string;
    }

    private void changeOwnerForVolume(@NotNull RemoteDockerRuntime dockerComposeClient, @NotNull PyDockerComposeProcessConnectionData data, @NotNull String user, @NotNull String volumeName) throws RemoteSdkException {
        if (dockerComposeClient == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(10);
        }
        if (data == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(11);
        }
        if (user == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(12);
        }
        if (volumeName == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(13);
        }
        try {
            String serviceName = data.getComposeServiceName();
            VolumesBuilder volumesBinds = VolumesBuilder.builder();
            volumesBinds.addBoundVolume(this.getRemoteSkeletonsPath(), volumeName);
            DockerComposeServiceClient serviceClient = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerComposeClient);
            ComposeServiceRunCmd runServiceCmd = (ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)serviceClient.runServiceCmd().withConfigurationPath(data.getComposeFilePaths())).withEnvs(data.getEnvs())).withUser("root")).withRemove(true).withServiceName(serviceName)).withCommand(new String[]{"chown", "-R", user, this.getRemoteSkeletonsPath()})).withVolumes(volumesBinds.build())).withRestartPolicy((RestartPolicy)RestartPolicy.noRestart());
            ProcessOutput serviceOutput = new CapturingProcessRunner((BaseProcessHandler)runServiceCmd.execute()).runProcess();
            if (!serviceOutput.checkSuccess(LOG)) {
                throw new RemoteSdkException("Failed to change permissions for skeletons volume");
            }
        }
        catch (ExecutionException | IOException e) {
            throw new RemoteSdkException("Failed to change owner of skeletons volume", e);
        }
    }

    @NotNull
    private static String getServiceUser(@NotNull RemoteDockerRuntime dockerRuntime, @NotNull PyDockerComposeProcessConnectionData data, @NotNull String serviceName) throws ExecutionException {
        String string;
        block8: {
            block7: {
                String string2;
                if (dockerRuntime == null) {
                    PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(14);
                }
                if (data == null) {
                    PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(15);
                }
                if (serviceName == null) {
                    PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(16);
                }
                try {
                    DockerComposeServiceClient serviceClient = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime);
                    ComposeServiceRunCmd runServiceCmd = (ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)serviceClient.runServiceCmd().withConfigurationPath(data.getComposeFilePaths())).withEnvs(data.getEnvs())).withRemove(true).withServiceName(serviceName)).withCommand(new String[]{"id", "--user"});
                    ProcessOutput processOutput = new CapturingProcessRunner((BaseProcessHandler)runServiceCmd.execute()).runProcess();
                    if (!processOutput.checkSuccess(LOG)) break block7;
                    string2 = processOutput.getStdout().trim();
                }
                catch (IOException e) {
                    throw new RemoteSdkException("Failed to get effective user for docker-compose service", (Throwable)e);
                }
                if (string2 == null) {
                    PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(17);
                }
                return string2;
            }
            LOG.debug("Failed to get effective user for docker-compose service");
            string = ROOT_USER_ID;
            if (ROOT_USER_ID != null) break block8;
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private PyDockerComposeProcessConnectionData getProcessConnectionData() {
        PyRemoteSdkAdditionalData sdkAdditionalData = this.getRemoteSdkAdditionalData();
        PyDockerComposeProcessConnectionData pyDockerComposeProcessConnectionData = PyDockerProcessUtil.getPyDockerComposeProcessConnectionData((PyRemoteSdkAdditionalDataBase)sdkAdditionalData);
        if (pyDockerComposeProcessConnectionData == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(19);
        }
        return pyDockerComposeProcessConnectionData;
    }

    @Override
    @NotNull
    protected RemoteDockerRuntime createDockerRuntime() throws ServerRuntimeException, RemoteSdkException {
        RemoteDockerRuntime remoteDockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)this.getProcessConnectionData().getAccount(), (Project)this.getProject());
        if (remoteDockerRuntime == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(20);
        }
        return remoteDockerRuntime;
    }

    @Override
    protected void doDownloadSources(@NotNull String srcRemotePath, @NotNull File targetLocalDir, @NotNull VolumesBuilder volumesBinds, @Nullable Map<String, String> map) throws IOException, RemoteSdkException, ServerRuntimeException {
        RemoteDockerApplicationRuntime serviceApplicationRuntime;
        if (srcRemotePath == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(21);
        }
        if (targetLocalDir == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(22);
        }
        if (volumesBinds == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(23);
        }
        PyDockerComposeProcessConnectionData data = this.getProcessConnectionData();
        RemoteDockerRuntime dockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)data.getAccount(), (Project)this.getProject());
        DockerComposeServiceClient serviceClient = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime);
        ComposeServiceRunCmd runServiceCmd = (ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)serviceClient.runServiceCmd().withConfigurationPath(data.getComposeFilePaths())).withEnvs(data.getEnvs())).withServiceName(data.getComposeServiceName())).withCommand(new String[]{"/bin/true"})).withVolumes(volumesBinds.build())).withRestartPolicy((RestartPolicy)RestartPolicy.noRestart());
        try {
            String containerName = runServiceCmd.execDetached();
            serviceApplicationRuntime = DockerComposeProcessUtil.getDockerComposeContainer((RemoteDockerRuntime)dockerRuntime, (String)containerName);
        }
        catch (RemoteSdkException e) {
            throw e;
        }
        catch (ExecutionException e) {
            throw new RemoteSdkException("Download failed");
        }
        serviceApplicationRuntime.downloadDirectoryAndRemove(srcRemotePath, targetLocalDir, map, data.getAccount().getMachine());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skeletonsPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/docker/PyDockerComposeSkeletonGenerator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extendedCommandLine";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdin";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modname";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerComposeClient";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "volumeName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerRuntime";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcRemotePath";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetLocalDir";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "volumesBinds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/docker/PyDockerComposeSkeletonGenerator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessOutput";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDockerComposeRunCmd";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "setupSkeletonsVolume";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceUser";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessConnectionData";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createDockerRuntime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildDockerComposeRunCmd";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "printToContainer";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "changeOwnerForVolume";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getServiceUser";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doDownloadSources";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

