/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCancelledException;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.ext.CaseCollector;
import com.intellij.util.ExceptionUtil;
import com.jetbrains.plugins.remotesdk.RemoteSdkFactoryImpl;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.ui.CreateRemoteSdkForm;
import com.jetbrains.plugins.remotesdk.ui.RemoteSdkEditorContainer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateRemoteSdkDialog<T extends RemoteSdkAdditionalData>
extends DialogWrapper
implements RemoteSdkEditorContainer {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.plugins.remotesdk.ui.CreateRemoteSdkDialog");
    @Nullable
    protected final Project myProject;
    private CreateRemoteSdkForm<T> myInterpreterForm;
    private Sdk mySdk;
    protected final RemoteSdkFactoryImpl<T> mySdkFactory;
    @Nullable
    private T myOriginalData;
    protected final Collection<Sdk> myExistingSdks;

    public CreateRemoteSdkDialog(@Nullable Project project, Collection<Sdk> existingSdks) {
        super(project, true);
        this.myProject = project == null || !project.isDefault() ? project : null;
        this.myExistingSdks = existingSdks;
        this.mySdkFactory = this.createRemoteSdkFactory();
    }

    public CreateRemoteSdkDialog(Component parentComponent, Collection<Sdk> existingSdks) {
        super(parentComponent, true);
        this.myProject = null;
        this.myExistingSdks = existingSdks;
        this.mySdkFactory = this.createRemoteSdkFactory();
    }

    @NotNull
    protected abstract RemoteSdkFactoryImpl<T> createRemoteSdkFactory();

    protected RemoteSdkFactoryImpl<T> getSdkFactory() {
        return this.mySdkFactory;
    }

    @NotNull
    private CreateRemoteSdkForm<T> getInterpreterForm() {
        if (this.myInterpreterForm == null) {
            this.myInterpreterForm = this.createRemoteSdkForm();
        }
        CreateRemoteSdkForm<T> createRemoteSdkForm = this.myInterpreterForm;
        if (createRemoteSdkForm == null) {
            CreateRemoteSdkDialog.$$$reportNull$$$0(0);
        }
        return createRemoteSdkForm;
    }

    @NotNull
    protected abstract CreateRemoteSdkForm<T> createRemoteSdkForm();

    public final void onValidationPress() {
        this.initValidation();
    }

    public void updateSize() {
        this.pack();
    }

    protected JComponent createCenterPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.add(this.getInterpreterForm(), "Center");
        return result;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.getInterpreterForm().getPreferredFocusedComponent();
    }

    @NotNull
    public final Sdk getSdk() {
        assert (this.mySdk != null);
        assert (this.mySdk.getSdkAdditionalData() instanceof RemoteSdkAdditionalData);
        Sdk sdk = this.mySdk;
        if (sdk == null) {
            CreateRemoteSdkDialog.$$$reportNull$$$0(1);
        }
        return sdk;
    }

    protected void initSdk(@NotNull Sdk sdk) throws RemoteSdkException {
        if (sdk == null) {
            CreateRemoteSdkDialog.$$$reportNull$$$0(2);
        }
        this.getSdkFactory().initSdk(sdk, this.myProject, this.getContentPane());
    }

    protected abstract boolean isModified(@NotNull T var1, @NotNull T var2);

    @NotNull
    private Sdk createSdk(T remoteSdkData) throws RemoteSdkException {
        Sdk sdk = this.createRemoteSdk(remoteSdkData);
        if (sdk == null) {
            CreateRemoteSdkDialog.$$$reportNull$$$0(3);
        }
        return sdk;
    }

    private Sdk createRemoteSdk(T data) throws RemoteSdkException {
        return this.mySdkFactory.createRemoteSdk(this.myProject, data, this.getInterpreterForm().getSdkName(), this.myExistingSdks);
    }

    @Nullable
    private Sdk saveUnfinished() {
        try {
            T data = this.getInterpreterForm().createSdkData();
            return this.mySdkFactory.createUnfinished(data, this.myExistingSdks);
        }
        catch (RemoteSdkException e) {
            LOG.debug((Throwable)e);
            return null;
        }
    }

    protected void doOKAction() {
        T remoteSdkData;
        String validation = this.validateInterpreterForm();
        if (validation != null) {
            this.onCreateFail(validation);
            return;
        }
        try {
            remoteSdkData = this.getInterpreterForm().createSdkData();
        }
        catch (RemoteSdkException e) {
            LOG.debug("Failed to create SDK data", (Throwable)e);
            this.onCreateFail(e.getMessage());
            return;
        }
        if (!this.validateRemoteSdkData(remoteSdkData)) {
            return;
        }
        try {
            this.mySdk = this.createSdk(remoteSdkData);
            SdkAdditionalData newData = this.mySdk.getSdkAdditionalData();
            assert (newData instanceof RemoteSdkAdditionalData);
            if (((RemoteSdkAdditionalData)newData).isValid() && (this.myOriginalData == null || !this.myOriginalData.isValid() || this.myOriginalData.getClass().isInstance(newData) && this.isModified(this.myOriginalData, (RemoteSdkAdditionalData)newData))) {
                this.initSdk(this.mySdk);
            }
        }
        catch (RemoteSdkException e) {
            this.mySdk = null;
            if (!ExceptionUtil.causedBy((Throwable)e, InterruptedException.class)) {
                LOG.debug("Failed to create remote SDK", (Throwable)e);
                this.onCreateFail(e.getMessage());
            }
            return;
        }
        super.doOKAction();
    }

    protected boolean validateRemoteSdkData(T data) {
        for (Sdk sdk : this.myExistingSdks) {
            if (!StringUtil.equals((CharSequence)sdk.getHomePath(), (CharSequence)this.mySdkFactory.generateSdkHomePath(data))) continue;
            this.validationFailed("There is already the same interpreter:\n" + sdk.getName(), false);
            return false;
        }
        return true;
    }

    private void onCreateFail(String validation) {
        boolean saveAnyway = this.validationFailed(validation, this.mySdkFactory.canSaveUnfinished());
        if (saveAnyway) {
            this.mySdk = this.saveUnfinished();
            if (this.mySdk != null) {
                super.doOKAction();
            }
        }
    }

    public void setSdkName(String name) {
        if (name != null && !name.startsWith(this.mySdkFactory.getDefaultUnfinishedName())) {
            this.getInterpreterForm().setSdkName(name);
        }
    }

    protected boolean validationFailed(String validation, boolean askSaveUnfinished) {
        if (StringUtil.isEmpty((String)validation)) {
            validation = "Communication error";
        }
        if (askSaveUnfinished) {
            if (Messages.showOkCancelDialog((String)validation, (String)("Can't create " + this.mySdkFactory.sdkName() + " SDK"), (String)"Save anyway", (String)"Continue editing", (Icon)Messages.getWarningIcon()) == 0) {
                return true;
            }
        } else {
            Messages.showErrorDialog((String)validation, (String)("Can't create " + this.mySdkFactory.sdkName() + " SDK"));
        }
        return false;
    }

    @Nullable
    private String validateInterpreterForm() {
        if (CaseCollector.useRemoteCredentials(this.getInterpreterForm().createSdkDataInner())) {
            return CreateRemoteSdkDialog.validateUsingRemoteSdkCredentials(this.myProject, this.getInterpreterForm());
        }
        this.updateHelpersPath();
        return null;
    }

    public static String validateUsingRemoteSdkCredentials(@Nullable Project project, final @NotNull CreateRemoteSdkForm interpreterForm) {
        if (interpreterForm == null) {
            CreateRemoteSdkDialog.$$$reportNull$$$0(4);
        }
        try {
            RemoteSdkCredentials data = interpreterForm.computeSdkCredentials();
            if (!RemoteSdkUtil.testConnectionAndCreateHelpersPath(project, data, "Connecting to remote host", new RemoteSdkUtil.RemoteSdkUpdatedCallback(){

                @Override
                public void updated(RemoteSdkCredentials data) {
                    interpreterForm.updateModifiedValues(data);
                }
            })) {
                return "Can't connect to remote host";
            }
        }
        catch (FileSystemException e) {
            LOG.info((Throwable)e);
            return e.getMessage();
        }
        catch (RemoteCancelledException e) {
            return "Connection cancelled";
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            return e.getMessage();
        }
        return null;
    }

    @Nullable
    private String updateHelpersPath() {
        this.getInterpreterForm().updateHelpersPath(this.getDefaultHelpersPath());
        return null;
    }

    @NotNull
    protected String getDefaultHelpersPath() {
        if ("/opt/.pycharm_helpers" == null) {
            CreateRemoteSdkDialog.$$$reportNull$$$0(5);
        }
        return "/opt/.pycharm_helpers";
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.getInterpreterForm().validateRemoteInterpreter();
    }

    public void setEditing(@NotNull T originalData) {
        if (originalData == null) {
            CreateRemoteSdkDialog.$$$reportNull$$$0(6);
        }
        this.getInterpreterForm().init(originalData);
        this.myOriginalData = originalData;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkDialog";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterForm";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterForm";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdk";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createSdk";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultHelpersPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initSdk";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validateUsingRemoteSdkCredentials";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setEditing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

