/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.console;

import com.google.common.collect.Lists;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteConnectionType;
import com.intellij.remote.RemoteConnector;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.SshConnectionProvider;
import com.jetbrains.plugins.remotesdk.console.RemoteConnectionUtil;
import com.jetbrains.plugins.remotesdk.console.WebServerConnector;
import com.jetbrains.plugins.remotesdk.ui.DeploymentProjectLevelSetupForm;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteConnectionSettingsForm {
    public static final RemoteConnector NONE_CONNECTOR = new RemoteConnector(){

        public String getId() {
            return null;
        }

        @NotNull
        public String getName() {
            if ("Select server on every run" == null) {
                1.$$$reportNull$$$0(0);
            }
            return "Select server on every run";
        }

        @NotNull
        public RemoteConnectionType getType() {
            RemoteConnectionType remoteConnectionType = RemoteConnectionType.NONE;
            if (remoteConnectionType == null) {
                1.$$$reportNull$$$0(1);
            }
            return remoteConnectionType;
        }

        public void produceRemoteCredentials(Consumer<RemoteCredentials> remoteCredentialsConsumer) {
            remoteCredentialsConsumer.consume(null);
        }

        @NotNull
        public Object getConnectorKey() {
            if ("" == null) {
                1.$$$reportNull$$$0(2);
            }
            return "";
        }

        public String toString() {
            return this.getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/plugins/remotesdk/console/RemoteConnectionSettingsForm$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConnectorKey";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };
    private Map<RemoteConnectionType, JRadioButton> myAdditionalConnectors;
    private ComboBox<RemoteConnector> myConnectionsCombo;
    private JRadioButton myServer;
    private JPanel myMainPanel;
    private LinkLabel myDeploymentServersLink;
    private JPanel myAdditionalConnectorsPlaceholder;
    private DeploymentProjectLevelSetupForm myDeploymentSetupForm;
    @Nullable
    private final Project myProject;
    private boolean myShowServerSettingsLink = false;
    private final boolean mySuggestServersFromOpenProjects;
    private final Disposable myParentDisposable;

    public RemoteConnectionSettingsForm(@Nullable Project project, Disposable parentDisposable) {
        this(project, parentDisposable, false);
    }

    public RemoteConnectionSettingsForm(Disposable parentDisposable, boolean suggestServersFromOpenProjects) {
        this(null, parentDisposable, suggestServersFromOpenProjects);
    }

    @Contract(value="!null,_,true->fail")
    private RemoteConnectionSettingsForm(@Nullable Project project, Disposable parentDisposable, boolean suggestServersFromOpenProjects) {
        this.myProject = project;
        this.myParentDisposable = parentDisposable;
        this.mySuggestServersFromOpenProjects = suggestServersFromOpenProjects;
        this.$$$setupUI$$$();
        assert (project == null || !suggestServersFromOpenProjects);
    }

    public JComponent createPanel() {
        MutableCollectionComboBoxModel model = new MutableCollectionComboBoxModel(RemoteConnectionSettingsForm.collectConnectionVariants(this.myProject, this.mySuggestServersFromOpenProjects));
        ApplicationManager.getApplication().getMessageBus().connect(this.myParentDisposable).subscribe(WebDeploymentTopics.DEPLOYMENT_CONFIG, (Object)new DeploymentConfigChangeListener(){

            public void deploymentConfigChanged() {
                RemoteConnectionSettingsForm.this.updateComboBox(null);
            }
        });
        this.myConnectionsCombo.setModel((ComboBoxModel)model);
        this.myConnectionsCombo.setSelectedItem(model.getSize() > 0 ? model.getElementAt(0) : null);
        this.myConnectionsCombo.setRenderer((ListCellRenderer)new ListCellRendererWrapper<RemoteConnector>(){

            public void customize(JList list, RemoteConnector value, int index, boolean selected, boolean hasFocus) {
                this.setText(value != null ? value.getName() : "(none)");
            }
        });
        this.myDeploymentSetupForm.getMainPanel().setVisible(false);
        if (this.myProject == null && this.mySuggestServersFromOpenProjects) {
            this.myServer.addItemListener(e -> this.updateServerSetupForm());
            this.myConnectionsCombo.addItemListener(e -> this.updateServerSetupForm());
        }
        if (this.myShowServerSettingsLink) {
            this.myDeploymentServersLink.setIcon(null);
            this.myDeploymentServersLink.setListener((source, data) -> {
                Settings settings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)this.myMainPanel));
                if (settings != null) {
                    settings.select(settings.find("web.server"));
                }
            }, null);
        } else {
            this.myDeploymentServersLink.setVisible(false);
        }
        ButtonGroup group = new ButtonGroup();
        group.add(this.myServer);
        for (JRadioButton button : this.myAdditionalConnectors.values()) {
            group.add(button);
        }
        return this.myMainPanel;
    }

    private void updateComboBox(@Nullable WebServerConfig serverToSelect) {
        List<RemoteConnector> items = RemoteConnectionSettingsForm.collectConnectionVariants(this.myProject, this.mySuggestServersFromOpenProjects);
        ((MutableCollectionComboBoxModel)this.myConnectionsCombo.getModel()).update(items);
        if (serverToSelect != null) {
            for (RemoteConnector item : items) {
                if (item.getType() != RemoteConnectionType.DEPLOYMENT_SERVER || !StringUtil.equals((CharSequence)serverToSelect.getId(), (CharSequence)item.getId())) continue;
                this.myConnectionsCombo.setSelectedItem((Object)item);
                return;
            }
        }
    }

    private void updateServerSetupForm() {
        Object item;
        boolean visible = false;
        if (this.myServer.isSelected() && (item = this.myConnectionsCombo.getSelectedItem()) instanceof RemoteConnector && ((RemoteConnector)item).getType() == RemoteConnectionType.DEPLOYMENT_SERVER) {
            String id = ((RemoteConnector)item).getId();
            WebServersConfigManager instance = WebServersConfigManager.getInstance(null);
            WebServerConfig server = instance.findServer(id);
            if (server == null) {
                visible = true;
                this.myDeploymentSetupForm.setProject(null);
                this.myDeploymentSetupForm.setWebServerConfigId(id);
                for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                    WebServersConfigManager configManager = WebServersConfigManager.getInstance((Project)project);
                    server = configManager.findServer(id);
                    if (server == null) continue;
                    this.myDeploymentSetupForm.setProject(project);
                    break;
                }
            }
        }
        this.myDeploymentSetupForm.getMainPanel().setVisible(visible);
    }

    @Nullable
    public ValidationInfo doValidate() {
        if (this.myDeploymentSetupForm.getMainPanel().isVisible()) {
            return new ValidationInfo("Selected server is project-level. Please copy or move it to IDE level", this.myConnectionsCombo);
        }
        return null;
    }

    public void setConnectionTypeAndId(@Nullable RemoteConnectionType type, String id) {
        if (type == null || type == RemoteConnectionType.NONE) {
            this.myServer.setSelected(true);
            this.setConnectorSelectionById(type, NONE_CONNECTOR.getId());
            return;
        }
        JRadioButton radioButton = this.myAdditionalConnectors.get(type);
        if (radioButton != null) {
            radioButton.setSelected(true);
            return;
        }
        this.myServer.setSelected(true);
        this.setConnectorSelectionById(type, id);
    }

    private void setConnectorSelectionById(@Nullable RemoteConnectionType type, String id) {
        List<RemoteConnector> connectors = RemoteConnectionSettingsForm.collectConnectionVariants(this.myProject, this.mySuggestServersFromOpenProjects);
        for (int i = 0; i < connectors.size(); ++i) {
            RemoteConnector c = connectors.get(i);
            if (type != c.getType() || (id != null || c.getId() != null) && (id == null || !id.equals(c.getId()))) continue;
            this.myConnectionsCombo.setSelectedIndex(i);
            break;
        }
    }

    @Nullable
    private RemoteConnector getSelected() {
        Object o = this.myConnectionsCombo.getSelectedItem();
        if (o instanceof RemoteConnector) {
            return (RemoteConnector)o;
        }
        return null;
    }

    @NotNull
    public RemoteConnectionType getConnectionType() {
        RemoteConnector connector;
        if (this.myServer.isSelected() && (connector = this.getSelected()) != null) {
            RemoteConnectionType remoteConnectionType = connector.getType();
            if (remoteConnectionType == null) {
                RemoteConnectionSettingsForm.$$$reportNull$$$0(0);
            }
            return remoteConnectionType;
        }
        for (Map.Entry<RemoteConnectionType, JRadioButton> entry : this.myAdditionalConnectors.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            RemoteConnectionType remoteConnectionType = entry.getKey();
            if (remoteConnectionType == null) {
                RemoteConnectionSettingsForm.$$$reportNull$$$0(1);
            }
            return remoteConnectionType;
        }
        RemoteConnectionType remoteConnectionType = RemoteConnectionType.NONE;
        if (remoteConnectionType == null) {
            RemoteConnectionSettingsForm.$$$reportNull$$$0(2);
        }
        return remoteConnectionType;
    }

    public String getConnectionId() {
        RemoteConnector connector;
        if (this.myServer.isSelected() && (connector = this.getSelected()) != null) {
            return connector.getId();
        }
        return "";
    }

    private static List<RemoteConnector> collectConnectionVariants(@Nullable Project project, boolean suggestServersFromOpenProjects) {
        ArrayList result = Lists.newArrayList();
        result.add(NONE_CONNECTOR);
        result.addAll(RemoteConnectionUtil.getAllRemoteConnectors(project));
        if (project == null && suggestServersFromOpenProjects) {
            for (Project otherProject : ProjectManager.getInstance().getOpenProjects()) {
                for (WebServerConfig config : RemoteSdkUtil.getSftpServerList(otherProject)) {
                    if (!config.isProjectLevel()) continue;
                    result.add(new WebServerConnector(Deployable.create((WebServerConfig)config)));
                }
            }
        }
        return result;
    }

    public void setShowServerSettingsLink(boolean showServerSettingsLink) {
        this.myShowServerSettingsLink = showServerSettingsLink;
    }

    private void createUIComponents() {
        this.myAdditionalConnectorsPlaceholder = new JPanel();
        SshConnectionProvider[] extensions = (SshConnectionProvider[])SshConnectionProvider.EP_NAME.getExtensions();
        int number = extensions.length;
        this.myAdditionalConnectors = new HashMap<RemoteConnectionType, JRadioButton>();
        if (number > 0) {
            this.myAdditionalConnectorsPlaceholder.setLayout(new BoxLayout(this.myAdditionalConnectorsPlaceholder, 1));
            boolean row = false;
            for (SshConnectionProvider provider : extensions) {
                JRadioButton button = new JRadioButton(provider.getRadioButtonDescription());
                this.myAdditionalConnectors.put(provider.getTypeForConfigurable(), button);
                this.myAdditionalConnectorsPlaceholder.add(button);
            }
        } else {
            this.myAdditionalConnectorsPlaceholder.setVisible(false);
        }
        this.myDeploymentSetupForm = new DeploymentProjectLevelSetupForm(null, null, new DeploymentProjectLevelSetupForm.Listener(){

            @Override
            public void onConfigCopied(@NotNull WebServerConfig global) {
                if (global == null) {
                    4.$$$reportNull$$$0(0);
                }
                RemoteConnectionSettingsForm.this.updateComboBox(global);
            }

            @Override
            public void onConfigMoved(@NotNull WebServerConfig movedServer) {
                if (movedServer == null) {
                    4.$$$reportNull$$$0(1);
                }
                RemoteConnectionSettingsForm.this.updateComboBox(movedServer);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "global";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "movedServer";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/console/RemoteConnectionSettingsForm$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onConfigCopied";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onConfigMoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/console/RemoteConnectionSettingsForm", "getConnectionType"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        LinkLabel linkLabel;
        JRadioButton jRadioButton;
        ComboBox comboBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 1, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Connection settings", (int)0, (int)0, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.myConnectionsCombo = comboBox = new ComboBox();
        jPanel3.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 7, 0, new Dimension(40, -1), null, null));
        this.myServer = jRadioButton = new JRadioButton();
        jRadioButton.setActionCommand("Deployment server");
        jRadioButton.setLabel("Deployment server");
        jRadioButton.setText("Deployment server");
        jRadioButton.putClientProperty("hideActionText", Boolean.TRUE);
        jPanel3.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        DeploymentProjectLevelSetupForm deploymentProjectLevelSetupForm = this.myDeploymentSetupForm;
        JComponent jComponent = deploymentProjectLevelSetupForm.$$$getRootComponent$$$();
        jPanel3.add((Component)jComponent, new GridConstraints(1, 0, 1, 2, 0, 0, 3, 3, null, null, null));
        this.myDeploymentServersLink = linkLabel = new LinkLabel();
        linkLabel.setText("Configure Servers");
        jPanel2.add((Component)linkLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = this.myAdditionalConnectorsPlaceholder;
        jPanel2.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

