/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor;

import com.google.common.collect.Lists;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLoadingPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.MatteBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ipnb.editor.IpnbEditorState;
import org.jetbrains.plugins.ipnb.editor.IpnbEditorUtil;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbAddCellAboveAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbAddCellBelowAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbCodeCellAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbHeading1CellAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbHeading2CellAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbHeading3CellAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbHeading4CellAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbHeading5CellAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbHeading6CellAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbInterruptKernelAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbMarkdownCellAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbMoveCellDownAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbMoveCellUpAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbReloadKernelAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbRunCellAction;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbEditablePanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbFilePanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbHeadingPanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbMarkdownPanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbPanel;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbCodePanel;
import org.jetbrains.plugins.ipnb.format.IpnbParser;
import org.jetbrains.plugins.ipnb.format.cells.IpnbCell;
import org.jetbrains.plugins.ipnb.format.cells.IpnbCodeCell;
import org.jetbrains.plugins.ipnb.format.cells.IpnbHeadingCell;
import org.jetbrains.plugins.ipnb.format.cells.IpnbMarkdownCell;

public class IpnbFileEditor
extends UserDataHolderBase
implements FileEditor {
    private final VirtualFile myFile;
    private final String myName;
    private final JBLoadingPanel myEditorPanel;
    private final IpnbFilePanel myIpnbFilePanel;
    private final Document myDocument;
    private ComboBox myCellTypeCombo;
    private static final String codeCellType = "Code";
    private static final String markdownCellType = "Markdown";
    private static final String headingCellType = "Heading ";
    private static final String rawNBCellType = "Raw NBConvert";
    private static final String[] ourCellTypes = new String[]{"Code", "Markdown", "Heading 1", "Heading 2", "Heading 3", "Heading 4", "Heading 5", "Heading 6"};
    private final JScrollPane myScrollPane;
    public static final DataKey<IpnbFileEditor> DATA_KEY = DataKey.create((String)IpnbFileEditor.class.getName());
    private JComponent myToolbar;

    public IpnbFileEditor(Project project, VirtualFile vFile) {
        this.myDocument = FileDocumentManager.getInstance().getDocument(vFile);
        project.getMessageBus().connect((Disposable)this).subscribe(FileEditorManagerListener.Before.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener.Before.Adapter(){

            public void beforeFileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!new File(file.getPath()).exists()) {
                    return;
                }
                if (IpnbFileEditor.this.myDocument == null) {
                    return;
                }
                FileDocumentManager.getInstance().saveDocument(IpnbFileEditor.this.myDocument);
                IpnbParser.saveIpnbFile(IpnbFileEditor.this.myIpnbFilePanel);
                file.refresh(false, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/ipnb/editor/IpnbFileEditor$1";
                objectArray[2] = "beforeFileClosed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myFile = vFile;
        this.myName = vFile.getName();
        this.myEditorPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this);
        this.myEditorPanel.startLoading();
        this.myEditorPanel.setBackground(IpnbEditorUtil.getBackground());
        this.myIpnbFilePanel = this.createIpnbEditorPanel(project, vFile);
        JPanel controlPanel = this.createControlPanel();
        this.myEditorPanel.add((Component)controlPanel, (Object)"North");
        this.myScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myIpnbFilePanel);
        this.myScrollPane.setHorizontalScrollBarPolicy(31);
        this.myEditorPanel.add((Component)this.myScrollPane, (Object)"Center");
        this.registerHeadingActions();
        this.registerActions();
    }

    public void loaded() {
        this.myEditorPanel.stopLoading();
    }

    public Document getDocument() {
        return this.myDocument;
    }

    private void registerActions() {
        new IpnbAddCellAboveAction(this).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke("ctrl shift EQUALS")), this.myIpnbFilePanel);
        new IpnbMarkdownCellAction(this).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke("ctrl shift M")), this.myIpnbFilePanel);
        new IpnbCodeCellAction(this).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke("ctrl shift Y")), this.myIpnbFilePanel);
        new IpnbMoveCellDownAction(this);
        new IpnbMoveCellUpAction(this);
    }

    private void registerHeadingActions() {
        new IpnbHeading1CellAction().registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke("ctrl shift 1")), this.myIpnbFilePanel);
        new IpnbHeading2CellAction().registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke("ctrl shift 2")), this.myIpnbFilePanel);
        new IpnbHeading3CellAction().registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke("ctrl shift 3")), this.myIpnbFilePanel);
        new IpnbHeading4CellAction().registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke("ctrl shift 4")), this.myIpnbFilePanel);
        new IpnbHeading5CellAction().registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke("ctrl shift 5")), this.myIpnbFilePanel);
        new IpnbHeading6CellAction().registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke("ctrl shift 6")), this.myIpnbFilePanel);
    }

    private JPanel createControlPanel() {
        JPanel controlPanel = new JPanel();
        controlPanel.setBackground(IpnbEditorUtil.getBackground());
        this.myCellTypeCombo = new ComboBox((Object[])ourCellTypes);
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.addAll(new AnAction[]{new IpnbRunCellAction(this), new IpnbInterruptKernelAction(this), new IpnbReloadKernelAction(this)});
        toolbarGroup.add((AnAction)new Separator());
        toolbarGroup.addAll(new AnAction[]{new IpnbMoveCellUpAction(this), new IpnbMoveCellDownAction(this)});
        toolbarGroup.add((AnAction)new IpnbAddCellBelowAction(this));
        this.myToolbar = IpnbFileEditor.createToolbar(toolbarGroup);
        controlPanel.add(this.myToolbar);
        this.myCellTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedItem = IpnbFileEditor.this.myCellTypeCombo.getSelectedItem();
                IpnbEditablePanel selectedCellPanel = IpnbFileEditor.this.myIpnbFilePanel.getSelectedCellPanel();
                if (selectedCellPanel != null && selectedItem instanceof String) {
                    IpnbFileEditor.this.updateCellType((String)selectedItem, selectedCellPanel);
                }
            }
        });
        controlPanel.add((Component)this.myCellTypeCombo);
        IpnbEditablePanel selectedCellPanel = this.myIpnbFilePanel.getSelectedCellPanel();
        if (selectedCellPanel != null) {
            this.updateCellTypeCombo(selectedCellPanel);
        }
        MatteBorder border = BorderFactory.createMatteBorder(0, 0, 1, 0, (Color)JBColor.GRAY);
        controlPanel.setBorder(border);
        return controlPanel;
    }

    @NotNull
    private static JComponent createToolbar(@NotNull DefaultActionGroup group) {
        if (group == null) {
            IpnbFileEditor.$$$reportNull$$$0(0);
        }
        JComponent component = ActionManager.getInstance().createActionToolbar("IpnbEditor", (ActionGroup)group, true).getComponent();
        component.setBackground(IpnbEditorUtil.getBackground());
        JComponent jComponent = component;
        if (jComponent == null) {
            IpnbFileEditor.$$$reportNull$$$0(1);
        }
        return jComponent;
    }

    public RelativePoint getRunButtonPlace() {
        return RelativePoint.getNorthWestOf((JComponent)this.myToolbar);
    }

    private void updateCellType(@NotNull String selectedItem, @NotNull IpnbEditablePanel selectedCell) {
        if (selectedItem == null) {
            IpnbFileEditor.$$$reportNull$$$0(2);
        }
        if (selectedCell == null) {
            IpnbFileEditor.$$$reportNull$$$0(3);
        }
        selectedCell.updateCellSource();
        if (selectedCell instanceof IpnbHeadingPanel) {
            IpnbHeadingCell cell = (IpnbHeadingCell)((IpnbHeadingPanel)selectedCell).getCell();
            if (selectedItem.startsWith(headingCellType)) {
                char c = selectedItem.charAt(selectedItem.length() - 1);
                int level = Character.getNumericValue(c);
                if (level != cell.getLevel()) {
                    cell.setLevel(level);
                    selectedCell.updateCellView();
                }
            } else if (selectedItem.equals(markdownCellType)) {
                List<IpnbCell> cells = this.myIpnbFilePanel.getIpnbFile().getCells();
                int index = cells.indexOf(((IpnbHeadingPanel)selectedCell).getCell());
                IpnbMarkdownCell markdownCell = new IpnbMarkdownCell(cell.getSource(), cell.getMetadata());
                if (index >= 0) {
                    cells.set(index, markdownCell);
                }
                this.myIpnbFilePanel.replaceComponent(selectedCell, markdownCell);
            } else if (selectedItem.equals(codeCellType)) {
                List<IpnbCell> cells = this.myIpnbFilePanel.getIpnbFile().getCells();
                int index = cells.indexOf(((IpnbHeadingPanel)selectedCell).getCell());
                IpnbCodeCell codeCell = new IpnbCodeCell("python", cell.getSource(), null, Lists.newArrayList(), cell.getMetadata());
                if (index >= 0) {
                    cells.set(index, codeCell);
                }
                this.myIpnbFilePanel.replaceComponent(selectedCell, codeCell);
            }
        } else if (selectedCell instanceof IpnbMarkdownPanel) {
            IpnbMarkdownCell cell = (IpnbMarkdownCell)((IpnbMarkdownPanel)selectedCell).getCell();
            if (selectedItem.startsWith(headingCellType)) {
                char c = selectedItem.charAt(selectedItem.length() - 1);
                int level = Character.getNumericValue(c);
                List<IpnbCell> cells = this.myIpnbFilePanel.getIpnbFile().getCells();
                int index = cells.indexOf(((IpnbMarkdownPanel)selectedCell).getCell());
                IpnbHeadingCell headingCell = new IpnbHeadingCell(cell.getSource(), level, cell.getMetadata());
                if (index >= 0) {
                    cells.set(index, headingCell);
                }
                this.myIpnbFilePanel.replaceComponent(selectedCell, headingCell);
            } else if (selectedItem.equals(codeCellType)) {
                List<IpnbCell> cells = this.myIpnbFilePanel.getIpnbFile().getCells();
                int index = cells.indexOf(((IpnbMarkdownPanel)selectedCell).getCell());
                IpnbCodeCell codeCell = new IpnbCodeCell("python", cell.getSource(), null, Lists.newArrayList(), cell.getMetadata());
                if (index >= 0) {
                    cells.set(index, codeCell);
                }
                this.myIpnbFilePanel.replaceComponent(selectedCell, codeCell);
            }
        } else if (selectedCell instanceof IpnbCodePanel) {
            IpnbCodeCell cell = (IpnbCodeCell)((IpnbCodePanel)selectedCell).getCell();
            if (selectedItem.startsWith(headingCellType)) {
                char c = selectedItem.charAt(selectedItem.length() - 1);
                int level = Character.getNumericValue(c);
                List<IpnbCell> cells = this.myIpnbFilePanel.getIpnbFile().getCells();
                int index = cells.indexOf(((IpnbCodePanel)selectedCell).getCell());
                IpnbHeadingCell headingCell = new IpnbHeadingCell(cell.getSource(), level, cell.getMetadata());
                if (index >= 0) {
                    cells.set(index, headingCell);
                }
                this.myIpnbFilePanel.replaceComponent(selectedCell, headingCell);
            } else if (selectedItem.equals(markdownCellType)) {
                List<IpnbCell> cells = this.myIpnbFilePanel.getIpnbFile().getCells();
                int index = cells.indexOf(((IpnbCodePanel)selectedCell).getCell());
                IpnbMarkdownCell markdownCell = new IpnbMarkdownCell(cell.getSource(), cell.getMetadata());
                if (index >= 0) {
                    cells.set(index, markdownCell);
                }
                this.myIpnbFilePanel.replaceComponent(selectedCell, markdownCell);
            }
        }
    }

    @NotNull
    private IpnbFilePanel createIpnbEditorPanel(Project project, VirtualFile vFile) {
        IpnbFilePanel ipnbFilePanel = new IpnbFilePanel(project, this, vFile, new CellSelectionListener(){

            @Override
            public void selectionChanged(@NotNull IpnbPanel ipnbPanel, boolean byMouse) {
                if (ipnbPanel == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (IpnbFileEditor.this.myCellTypeCombo == null) {
                    return;
                }
                IpnbFileEditor.this.updateCellTypeCombo(ipnbPanel);
                if (byMouse) {
                    return;
                }
                IpnbFileEditor.this.updateScrollPosition(ipnbPanel);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ipnbPanel", "org/jetbrains/plugins/ipnb/editor/IpnbFileEditor$3", "selectionChanged"));
            }
        });
        if (ipnbFilePanel == null) {
            IpnbFileEditor.$$$reportNull$$$0(4);
        }
        return ipnbFilePanel;
    }

    public void updateScrollPosition(@NotNull IpnbPanel ipnbPanel) {
        if (ipnbPanel == null) {
            IpnbFileEditor.$$$reportNull$$$0(5);
        }
        Rectangle rect = this.myIpnbFilePanel.getVisibleRect();
        Rectangle cellBounds = ipnbPanel.getBounds();
        int shift = 2;
        if (cellBounds.getY() <= rect.getY() || cellBounds.getY() >= rect.getY() + (double)rect.height) {
            this.myScrollPane.getVerticalScrollBar().setValue(cellBounds.y - 2);
        }
        if (cellBounds.getY() + cellBounds.getHeight() > rect.getY() + rect.getHeight() && cellBounds.height < rect.height) {
            this.myScrollPane.getVerticalScrollBar().setValue(cellBounds.y - rect.height + cellBounds.height + 2);
        }
    }

    private void updateCellTypeCombo(@NotNull IpnbPanel ipnbPanel) {
        if (ipnbPanel == null) {
            IpnbFileEditor.$$$reportNull$$$0(6);
        }
        if (ipnbPanel instanceof IpnbHeadingPanel) {
            IpnbHeadingCell cell = (IpnbHeadingCell)((IpnbHeadingPanel)ipnbPanel).getCell();
            int level = cell.getLevel();
            this.myCellTypeCombo.setSelectedItem((Object)(headingCellType + level));
        } else if (ipnbPanel instanceof IpnbMarkdownPanel) {
            this.myCellTypeCombo.setSelectedItem((Object)markdownCellType);
        } else if (ipnbPanel instanceof IpnbCodePanel) {
            this.myCellTypeCombo.setSelectedItem((Object)codeCellType);
        }
    }

    public IpnbFilePanel getIpnbFilePanel() {
        return this.myIpnbFilePanel;
    }

    @NotNull
    public JComponent getComponent() {
        JBLoadingPanel jBLoadingPanel = this.myEditorPanel;
        if (jBLoadingPanel == null) {
            IpnbFileEditor.$$$reportNull$$$0(7);
        }
        return jBLoadingPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEditorPanel;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            IpnbFileEditor.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            IpnbFileEditor.$$$reportNull$$$0(9);
        }
        int index = this.getIpnbFilePanel().getSelectedIndex();
        Document document = FileDocumentManager.getInstance().getCachedDocument(this.myFile);
        long modificationStamp = document != null ? document.getModificationStamp() : this.myFile.getModificationStamp();
        IpnbEditorState ipnbEditorState = new IpnbEditorState(modificationStamp, index);
        if (ipnbEditorState == null) {
            IpnbFileEditor.$$$reportNull$$$0(10);
        }
        return ipnbEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            IpnbFileEditor.$$$reportNull$$$0(11);
        }
        int index = ((IpnbEditorState)state).getSelectedIndex();
        this.myIpnbFilePanel.setInitialPosition(index);
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            IpnbFileEditor.$$$reportNull$$$0(12);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            IpnbFileEditor.$$$reportNull$$$0(13);
        }
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myIpnbFilePanel);
    }

    public VirtualFile getVirtualFile() {
        return this.myFile;
    }

    public JScrollPane getScrollPane() {
        return this.myScrollPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ipnb/editor/IpnbFileEditor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedItem";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedCell";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ipnbPanel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ipnb/editor/IpnbFileEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createIpnbEditorPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createToolbar";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateCellType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateScrollPosition";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateCellTypeCombo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class CellSelectionListener {
        public abstract void selectionChanged(@NotNull IpnbPanel var1, boolean var2);
    }
}

