/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.jobs;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.jobs.BrowsePreviewDialog;
import org.jetbrains.idea.perforce.perforce.jobs.JobViewSearchSpecificator;
import org.jetbrains.idea.perforce.perforce.jobs.JobsWorker;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJob;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJobSpecification;

public class BrowsePreviewAction
extends AnAction {
    private static Icon ourIcon;
    private final Project myProject;
    private final String myJobView;
    private final PerforceJobSpecification mySpecification;
    private final P4Connection myConnection;
    private final ConnectionKey myKey;

    public BrowsePreviewAction(String jobView, PerforceJobSpecification specification, P4Connection connection, ConnectionKey key, Project project) {
        this.myJobView = jobView;
        this.mySpecification = specification;
        this.myConnection = connection;
        this.myKey = key;
        this.myProject = project;
    }

    private static Icon lazyIcon() {
        if (ourIcon == null) {
            ourIcon = AllIcons.Actions.ShowChangesOnly;
        }
        return ourIcon;
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setText("Job View");
        presentation.setDescription("Job View");
        presentation.setIcon(BrowsePreviewAction.lazyIcon());
    }

    public void actionPerformed(AnActionEvent e) {
        ArrayList<PerforceJob> perforceJobs = new ArrayList<PerforceJob>();
        JobViewSearchSpecificator searchSpecificator = new JobViewSearchSpecificator(this.myJobView, null);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                JobsWorker jw = new JobsWorker(this.myProject);
                perforceJobs.addAll(jw.getJobs(this.mySpecification, searchSpecificator, this.myConnection, this.myKey));
            }
            catch (VcsException e1) {
                Messages.showErrorDialog((Project)this.myProject, (String)e1.getMessage(), (String)"Error When Searching For Jobs");
            }
        }, PerforceBundle.message((String)"perforce.jobs.searching.by.jobview.progress.text", (Object[])new Object[0]), false, this.myProject);
        if (perforceJobs.isEmpty()) {
            Messages.showInfoMessage((Project)this.myProject, (String)"No jobs found using Job View.", (String)"No Jobs Found.");
            return;
        }
        BrowsePreviewDialog dialog = new BrowsePreviewDialog(this.myProject, this.myJobView, perforceJobs, searchSpecificator.getMaxCount());
        dialog.show();
    }
}

