/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.openapi.util.text.LineTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class FormParser {
    private static final String COMMENT_PREFIX = "#";
    private final List<String> myAvailableFields;
    private final List<String> myLines;
    private final Map<String, List<String>> myResult = new LinkedHashMap<String, List<String>>();
    private String myCurrentField;
    @Nullable
    private final Set<String> myFieldsTakeEvenEmpty;

    private FormParser(List<String> availableFields, List<String> lines, @Nullable Set<String> fieldsTakeEvenEmpty) {
        this.myAvailableFields = availableFields;
        this.myLines = lines;
        this.myFieldsTakeEvenEmpty = fieldsTakeEvenEmpty;
    }

    public static Map<String, List<String>> execute(String source, @NonNls String[] fields) {
        return FormParser.execute(source, fields, null);
    }

    public static Map<String, List<String>> execute(String source, @NonNls String[] fields, String doNotIgnoreEmpty) {
        FormParser formParser = new FormParser(new ArrayList<String>(Arrays.asList(fields)), FormParser.splitIntoStringsExceptComments(source), doNotIgnoreEmpty == null ? null : Collections.singleton(doNotIgnoreEmpty));
        formParser.executeInt();
        return formParser.myResult;
    }

    private void executeInt() {
        for (String line : this.myLines) {
            String field = this.isBeginOfNewField(line);
            String value = line;
            if (field != null) {
                this.myAvailableFields.remove(field);
                value = line.substring(field.length());
                value = value.trim();
                this.myCurrentField = field;
            }
            if (this.myCurrentField == null || (this.myFieldsTakeEvenEmpty == null || !this.myFieldsTakeEvenEmpty.contains(this.myCurrentField)) && value.length() <= 0) continue;
            if (!this.myResult.containsKey(this.myCurrentField)) {
                this.myResult.put(this.myCurrentField, new ArrayList());
            }
            this.myResult.get(this.myCurrentField).add(value);
        }
    }

    private String isBeginOfNewField(String line) {
        for (String field : this.myAvailableFields) {
            if (!line.startsWith(field)) continue;
            return field;
        }
        return null;
    }

    private static List<String> splitIntoStringsExceptComments(String source) {
        ArrayList<String> result = new ArrayList<String>();
        if (source != null) {
            String[] lines = LineTokenizer.tokenize((CharSequence)source, (boolean)false);
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if ((line = line.trim()).length() <= 0 || line.startsWith(COMMENT_PREFIX)) continue;
                result.add(line);
            }
        }
        return result;
    }
}

