/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.idea.perforce.application.ParticularConnectionPerforceIntegratePanel;
import org.jetbrains.idea.perforce.application.PerforcePanel;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class PerforceIntegratePanel
implements PerforcePanel {
    private JPanel myParticularConnectionsPanel;
    private JPanel myPanel;
    private JCheckBox myRunResolve;
    private JCheckBox myRevertUnchanged;
    private final List<ParticularConnectionPerforceIntegratePanel> myConnectionPanels;

    public PerforceIntegratePanel(Project project, List<P4Connection> connections) {
        this.$$$setupUI$$$();
        this.myConnectionPanels = new ArrayList<ParticularConnectionPerforceIntegratePanel>();
        this.myParticularConnectionsPanel.setLayout(new GridLayout(0, 1));
        for (P4Connection p4Connection : connections) {
            ParticularConnectionPerforceIntegratePanel panel = new ParticularConnectionPerforceIntegratePanel(project, p4Connection);
            this.myConnectionPanels.add(panel);
            this.myParticularConnectionsPanel.add(panel.getPanel());
        }
    }

    @Override
    public void updateFrom(PerforceSettings settings) {
        this.myRevertUnchanged.setSelected(settings.INTEGRATE_REVERT_UNCHANGED);
        this.myRunResolve.setSelected(settings.INTEGRATE_RUN_RESOLVE);
        for (ParticularConnectionPerforceIntegratePanel panel : this.myConnectionPanels) {
            panel.updateFrom(settings);
        }
    }

    @Override
    public void applyTo(PerforceSettings settings) throws ConfigurationException {
        settings.INTEGRATE_REVERT_UNCHANGED = this.myRevertUnchanged.isSelected();
        settings.INTEGRATE_RUN_RESOLVE = this.myRunResolve.isSelected();
        for (ParticularConnectionPerforceIntegratePanel panel : this.myConnectionPanels) {
            panel.applyTo(settings);
        }
    }

    @Override
    public boolean isModified(PerforceSettings settings) {
        for (ParticularConnectionPerforceIntegratePanel panel : this.myConnectionPanels) {
            if (!panel.isModified(settings)) continue;
            return true;
        }
        return settings.INTEGRATE_REVERT_UNCHANGED != this.myRevertUnchanged.isSelected() || settings.INTEGRATE_RUN_RESOLVE != this.myRunResolve.isSelected();
    }

    @Override
    public JPanel getPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myRunResolve = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("org/jetbrains/idea/perforce/PerforceBundle").getString("checkbox.run.resolve.after.sync"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myRevertUnchanged = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("org/jetbrains/idea/perforce/PerforceBundle").getString("checkbox.update.options.revert.unchanged.files.before.sync"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myParticularConnectionsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

