/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.application.PerforceNumberNameSynchronizer;
import org.jetbrains.idea.perforce.perforce.PerforceChange;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

class PerforceChangeListCalculator {
    private final ChangeListManagerGate myAddGate;
    private final PerforceNumberNameSynchronizer mySynchronizer;
    private final ConnectionKey myConnectionKey;

    PerforceChangeListCalculator(Project project, P4Connection connection, ChangeListManagerGate addGate) {
        this.myConnectionKey = connection.getConnectionKey();
        this.myAddGate = addGate;
        this.mySynchronizer = PerforceNumberNameSynchronizer.getInstance(project);
    }

    ChangeList convert(PerforceChange perforceChange) {
        LocalChangeList list = this.myAddGate.findChangeList(this.mySynchronizer.getName(this.myConnectionKey, perforceChange.getChangeList()));
        return list != null ? list : this.myAddGate.findChangeList(LocalChangeList.DEFAULT_NAME);
    }
}

