/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run;

import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HttpResponsePresentation {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ws.http.request.run.HttpResponsePresentation");

    public abstract void print(@NotNull Project var1, @NotNull ConsoleView var2, @NotNull FileType var3, @NotNull Ref<FileType> var4);

    @NotNull
    public static HttpResponsePresentation createErrorResponse(@NotNull String text) {
        if (text == null) {
            HttpResponsePresentation.$$$reportNull$$$0(0);
        }
        HttpErrorResponsePresentation httpErrorResponsePresentation = new HttpErrorResponsePresentation(text);
        if (httpErrorResponsePresentation == null) {
            HttpResponsePresentation.$$$reportNull$$$0(1);
        }
        return httpErrorResponsePresentation;
    }

    @NotNull
    public static HttpResponsePresentation createResponse(@Nullable String header, @NotNull String response, @NotNull String status) {
        if (response == null) {
            HttpResponsePresentation.$$$reportNull$$$0(2);
        }
        if (status == null) {
            HttpResponsePresentation.$$$reportNull$$$0(3);
        }
        HttpSucceedResponsePresentation httpSucceedResponsePresentation = new HttpSucceedResponsePresentation(header, response, status);
        if (httpSucceedResponsePresentation == null) {
            HttpResponsePresentation.$$$reportNull$$$0(4);
        }
        return httpSucceedResponsePresentation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/run/HttpResponsePresentation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/run/HttpResponsePresentation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorResponse";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createResponse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createErrorResponse";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createResponse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HttpErrorResponsePresentation
    extends HttpResponsePresentation {
        private final String myText;

        public HttpErrorResponsePresentation(@NotNull String text) {
            if (text == null) {
                HttpErrorResponsePresentation.$$$reportNull$$$0(0);
            }
            this.myText = text;
        }

        @Override
        public void print(@NotNull Project project, @NotNull ConsoleView console, @NotNull FileType fileType, @NotNull Ref<FileType> activeType) {
            if (project == null) {
                HttpErrorResponsePresentation.$$$reportNull$$$0(1);
            }
            if (console == null) {
                HttpErrorResponsePresentation.$$$reportNull$$$0(2);
            }
            if (fileType == null) {
                HttpErrorResponsePresentation.$$$reportNull$$$0(3);
            }
            if (activeType == null) {
                HttpErrorResponsePresentation.$$$reportNull$$$0(4);
            }
            console.print(this.myText, ConsoleViewContentType.ERROR_OUTPUT);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileType";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "activeType";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ws/http/request/run/HttpResponsePresentation$HttpErrorResponsePresentation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "print";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class HttpSucceedResponsePresentation
    extends HttpResponsePresentation {
        private final String myHeader;
        private final String myResponse;
        private final String myStatus;

        public HttpSucceedResponsePresentation(String header, String response, String status) {
            this.myHeader = header;
            this.myResponse = response;
            this.myStatus = status;
        }

        @Override
        public void print(@NotNull Project project, @NotNull ConsoleView console, @NotNull FileType fileType, @NotNull Ref<FileType> activeType) {
            if (project == null) {
                HttpSucceedResponsePresentation.$$$reportNull$$$0(0);
            }
            if (console == null) {
                HttpSucceedResponsePresentation.$$$reportNull$$$0(1);
            }
            if (fileType == null) {
                HttpSucceedResponsePresentation.$$$reportNull$$$0(2);
            }
            if (activeType == null) {
                HttpSucceedResponsePresentation.$$$reportNull$$$0(3);
            }
            if (StringUtil.isNotEmpty((String)this.myHeader)) {
                console.print(this.myHeader, ConsoleViewContentType.SYSTEM_OUTPUT);
                console.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            }
            if (fileType != PlainTextFileType.INSTANCE && StringUtil.isNotEmpty((String)this.myResponse)) {
                String fileName = "DUMMY__." + fileType.getDefaultExtension();
                PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText(fileName, fileType, (CharSequence)this.myResponse, System.currentTimeMillis(), true);
                ReformatCodeProcessor processor = new ReformatCodeProcessor(file, false);
                processor.setPostRunnable(() -> {
                    if (activeType == null) {
                        HttpSucceedResponsePresentation.$$$reportNull$$$0(4);
                    }
                    if (fileType == null) {
                        HttpSucceedResponsePresentation.$$$reportNull$$$0(5);
                    }
                    if (console == null) {
                        HttpSucceedResponsePresentation.$$$reportNull$$$0(6);
                    }
                    if (activeType.get() == fileType) {
                        ConsoleViewUtil.printAsFileType((ConsoleView)console, (String)file.getText(), (FileType)fileType);
                        console.print("\n\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                        console.print(this.myStatus, ConsoleViewContentType.SYSTEM_OUTPUT);
                    } else {
                        LOG.info("File formatted as " + fileType.getName() + " but active is " + ((FileType)activeType.get()).getName());
                    }
                });
                processor.run();
            } else {
                console.print(this.myResponse, ConsoleViewContentType.NORMAL_OUTPUT);
                console.print("\n\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                console.print(this.myStatus, ConsoleViewContentType.SYSTEM_OUTPUT);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileType";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "activeType";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ws/http/request/run/HttpResponsePresentation$HttpSucceedResponsePresentation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "print";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$print$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

