/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.console.ConsoleViewWrapperBase;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.ide.actions.NextOccurenceToolbarAction;
import com.intellij.ide.actions.PreviousOccurenceToolbarAction;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.json.JsonFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.content.Content;
import com.intellij.ws.http.request.run.HttpClientResponseHandler;
import com.intellij.ws.http.request.run.HttpResponseHandlerScriptWriter;
import com.intellij.ws.http.request.run.HttpResponseHandlerTestWriter;
import com.intellij.ws.http.request.run.HttpResponseHandlerWriter;
import com.intellij.ws.http.request.run.HttpResponsePresentation;
import com.intellij.ws.rest.client.RestClientBundle;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpResponseConsolePrinter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ws.http.request.run.HttpClientResponseHandler");
    private final Project myProject;
    private final ConsoleView myConsole;
    private Ref<FileType> mySelectedFileType;
    private ConsoleView myResponseHandlerConsole;
    private HttpResponseHandlerWriter myResponseHandlerWriter;
    private final ProcessHandler myTestsProcessHandler;
    private BaseTestsOutputConsoleView myResponseHandlerTestConsole;
    private HttpResponseHandlerWriter myResponseHandlerTestWriter;
    private final String myTargetRequestLine;
    private HttpResponsePresentation myResponse;

    public HttpResponseConsolePrinter(@NotNull Project project, @NotNull String target, @NotNull SMTRunnerConsoleProperties properties, @Nullable HttpClientResponseHandler responseHandler) {
        if (project == null) {
            HttpResponseConsolePrinter.$$$reportNull$$$0(0);
        }
        if (target == null) {
            HttpResponseConsolePrinter.$$$reportNull$$$0(1);
        }
        if (properties == null) {
            HttpResponseConsolePrinter.$$$reportNull$$$0(2);
        }
        this.mySelectedFileType = new Ref((Object)PlainTextFileType.INSTANCE);
        this.myResponseHandlerConsole = null;
        this.myResponseHandlerWriter = null;
        this.myResponseHandlerTestConsole = null;
        this.myResponseHandlerTestWriter = null;
        this.myResponse = null;
        this.myProject = project;
        this.myConsole = new HttpResponseConsoleView(project);
        this.myConsole.print(target, ConsoleViewContentType.SYSTEM_OUTPUT);
        ProcessHandler processHandler = this.myTestsProcessHandler = responseHandler != null ? responseHandler.getProcessHandler() : null;
        if (this.myTestsProcessHandler != null) {
            try {
                this.myResponseHandlerConsole = new ConsoleViewImpl(project, true);
                this.myResponseHandlerConsole.print(RestClientBundle.message("rest.client.request.response.handler.console", new Object[0]), ConsoleViewContentType.SYSTEM_OUTPUT);
                HttpResponseHandlerScriptWriter stdout = new HttpResponseHandlerScriptWriter(this.myResponseHandlerConsole, false);
                HttpResponseHandlerScriptWriter stderr = new HttpResponseHandlerScriptWriter(this.myResponseHandlerConsole, true);
                this.myResponseHandlerWriter = new HttpResponseHandlerWriter(stdout, stderr);
                Disposer.register((Disposable)this.myConsole, (Disposable)this.myResponseHandlerConsole);
                this.myResponseHandlerTestConsole = SMTestRunnerConnectionUtil.createAndAttachConsole((String)properties.getTestFrameworkName(), (ProcessHandler)this.myTestsProcessHandler, (TestConsoleProperties)properties);
                HttpResponseHandlerTestWriter testStdout = new HttpResponseHandlerTestWriter(this.myTestsProcessHandler, false);
                HttpResponseHandlerTestWriter testStderr = new HttpResponseHandlerTestWriter(this.myTestsProcessHandler, true);
                this.myResponseHandlerTestWriter = new HttpResponseHandlerWriter(testStdout, testStderr);
                Disposer.register((Disposable)this.myConsole, (Disposable)this.myResponseHandlerTestConsole);
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
        }
        this.myTargetRequestLine = target;
    }

    public void setResponse(@NotNull HttpResponsePresentation response, @NotNull FileType fileType) {
        if (response == null) {
            HttpResponseConsolePrinter.$$$reportNull$$$0(3);
        }
        if (fileType == null) {
            HttpResponseConsolePrinter.$$$reportNull$$$0(4);
        }
        this.myResponse = response;
        this.mySelectedFileType = new Ref((Object)fileType);
        this.myResponse.print(this.myProject, this.myConsole, fileType, this.mySelectedFileType);
    }

    public void setErrorResponse(@NotNull HttpResponsePresentation response) {
        if (response == null) {
            HttpResponseConsolePrinter.$$$reportNull$$$0(5);
        }
        this.setResponse(response, (FileType)PlainTextFileType.INSTANCE);
        if (this.myTestsProcessHandler != null) {
            this.myTestsProcessHandler.destroyProcess();
        }
    }

    public void attachToProcess(@NotNull ProcessHandler handler) {
        if (handler == null) {
            HttpResponseConsolePrinter.$$$reportNull$$$0(6);
        }
        this.myConsole.attachToProcess(handler);
    }

    @NotNull
    public ConsoleView getConsole() {
        ConsoleView consoleView = this.myConsole;
        if (consoleView == null) {
            HttpResponseConsolePrinter.$$$reportNull$$$0(7);
        }
        return consoleView;
    }

    @Nullable
    public HttpResponseHandlerWriter getResponseHandlerWriter() {
        return this.myResponseHandlerWriter;
    }

    @Nullable
    public HttpResponseHandlerWriter getResponseHandlerTestWriter() {
        return this.myResponseHandlerTestWriter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/run/HttpResponseConsolePrinter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/run/HttpResponseConsolePrinter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setResponse";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setErrorResponse";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class HttpResponseConsoleView
    extends ConsoleViewWrapperBase {
        private static final String RESPONSE_HANDLER_ID = "HTTP_RESPONSE_HANDLER_SCRIPT";
        private static final String RESPONSE_HANDLER_NAME = "Response Handler";
        private static final String RESPONSE_TESTS_ID = "HTTP_RESPONSE_HANDLER_TESTS";
        private static final String RESPONSE_TESTS_NAME = "Tests";

        public HttpResponseConsoleView(Project project) {
            if (project == null) {
                HttpResponseConsoleView.$$$reportNull$$$0(0);
            }
            super((ConsoleView)new ConsoleViewImpl(project, false));
        }

        public void buildUi(RunnerLayoutUi ui) {
            super.buildUi(ui);
            if (HttpResponseConsolePrinter.this.myResponseHandlerConsole != null) {
                this.addTab(ui, RESPONSE_HANDLER_ID, HttpResponseConsolePrinter.this.myResponseHandlerConsole.getComponent(), RESPONSE_HANDLER_NAME);
            }
            if (HttpResponseConsolePrinter.this.myResponseHandlerTestConsole != null) {
                this.addTab(ui, RESPONSE_TESTS_ID, HttpResponseConsolePrinter.this.myResponseHandlerTestConsole.getComponent(), RESPONSE_TESTS_NAME);
            }
        }

        private void addTab(@NotNull RunnerLayoutUi ui, @NotNull String contentId, @NotNull JComponent component, @NotNull String name) {
            if (ui == null) {
                HttpResponseConsoleView.$$$reportNull$$$0(1);
            }
            if (contentId == null) {
                HttpResponseConsoleView.$$$reportNull$$$0(2);
            }
            if (component == null) {
                HttpResponseConsoleView.$$$reportNull$$$0(3);
            }
            if (name == null) {
                HttpResponseConsoleView.$$$reportNull$$$0(4);
            }
            Content content = ui.createContent(contentId, component, name, null, null);
            content.setCloseable(false);
            ui.addContent(content, 0, PlaceInGrid.bottom, false);
        }

        @NotNull
        public AnAction[] createConsoleActions() {
            AnAction[] oldActions = super.createConsoleActions();
            ArrayList<Object> newActions = new ArrayList<Object>(oldActions.length);
            DefaultActionGroup group = new DefaultActionGroup();
            group.add((AnAction)new HttpResponseReformatAction(HttpResponseConsolePrinter.this, "View as text", "Show response body as a raw file", (FileType)PlainTextFileType.INSTANCE));
            group.add((AnAction)new HttpResponseReformatAction(HttpResponseConsolePrinter.this, (FileType)JsonFileType.INSTANCE));
            group.add((AnAction)new HttpResponseReformatAction(HttpResponseConsolePrinter.this, (FileType)XmlFileType.INSTANCE));
            group.add((AnAction)new HttpResponseReformatAction(HttpResponseConsolePrinter.this, (FileType)HtmlFileType.INSTANCE));
            group.addSeparator();
            newActions.add(group);
            for (AnAction action : oldActions) {
                if (action instanceof PreviousOccurenceToolbarAction || action instanceof NextOccurenceToolbarAction) continue;
                newActions.add(action);
            }
            AnAction[] anActionArray = newActions.toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                HttpResponseConsoleView.$$$reportNull$$$0(5);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ui";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/http/request/run/HttpResponseConsolePrinter$HttpResponseConsoleView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/http/request/run/HttpResponseConsolePrinter$HttpResponseConsoleView";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createConsoleActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addTab";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private abstract class HttpResponseReformatBaseAction
    extends ToggleAction {
        public HttpResponseReformatBaseAction(@Nullable String text, @Nullable String description, Icon icon) {
            super(text, description, icon);
        }

        @Nullable
        public abstract FileType getFileType();

        public boolean isSelected(AnActionEvent e) {
            return HttpResponseConsolePrinter.this.mySelectedFileType.get() == this.getFileType();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            FileType type;
            if (state && HttpResponseConsolePrinter.this.myResponse != null && (type = this.getFileType()) != null && HttpResponseConsolePrinter.this.mySelectedFileType.get() != type) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Reformat response body as " + type.getName());
                }
                HttpResponseConsolePrinter.this.mySelectedFileType.set((Object)type);
                HttpResponseConsolePrinter.this.myConsole.clear();
                HttpResponseConsolePrinter.this.myConsole.print(HttpResponseConsolePrinter.this.myTargetRequestLine, ConsoleViewContentType.SYSTEM_OUTPUT);
                HttpResponseConsolePrinter.this.myResponse.print(HttpResponseConsolePrinter.this.myProject, HttpResponseConsolePrinter.this.myConsole, type, (Ref<FileType>)HttpResponseConsolePrinter.this.mySelectedFileType);
            }
        }
    }

    private class HttpResponseReformatAction
    extends HttpResponseReformatBaseAction {
        private final FileType myFileType;
        final /* synthetic */ HttpResponseConsolePrinter this$0;

        public HttpResponseReformatAction(@NotNull HttpResponseConsolePrinter httpResponseConsolePrinter, FileType fileType) {
            if (fileType == null) {
                HttpResponseReformatAction.$$$reportNull$$$0(0);
            }
            this(httpResponseConsolePrinter, "View as " + fileType.getName(), "Reformat and highlight file as " + fileType.getName(), fileType);
        }

        public HttpResponseReformatAction(@NotNull HttpResponseConsolePrinter httpResponseConsolePrinter, @NotNull String text, @NotNull String description, FileType fileType) {
            if (text == null) {
                HttpResponseReformatAction.$$$reportNull$$$0(1);
            }
            if (description == null) {
                HttpResponseReformatAction.$$$reportNull$$$0(2);
            }
            if (fileType == null) {
                HttpResponseReformatAction.$$$reportNull$$$0(3);
            }
            this.this$0 = httpResponseConsolePrinter;
            super(text, description, fileType.getIcon());
            this.myFileType = fileType;
        }

        @Override
        @Nullable
        public FileType getFileType() {
            return this.myFileType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "description";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ws/http/request/run/HttpResponseConsolePrinter$HttpResponseReformatAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

