/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.ws.http.request.psi.HttpRequestElementType;
import com.intellij.ws.http.request.psi.HttpRequestTokenType;
import com.intellij.ws.http.request.psi.impl.HttpDifferenceFileImpl;
import com.intellij.ws.http.request.psi.impl.HttpFilePathImpl;
import com.intellij.ws.http.request.psi.impl.HttpFragmentImpl;
import com.intellij.ws.http.request.psi.impl.HttpHeaderFieldImpl;
import com.intellij.ws.http.request.psi.impl.HttpHeaderFieldNameImpl;
import com.intellij.ws.http.request.psi.impl.HttpHeaderFieldValueImpl;
import com.intellij.ws.http.request.psi.impl.HttpHostImpl;
import com.intellij.ws.http.request.psi.impl.HttpInputFileImpl;
import com.intellij.ws.http.request.psi.impl.HttpMessageBodyImpl;
import com.intellij.ws.http.request.psi.impl.HttpMethodImpl;
import com.intellij.ws.http.request.psi.impl.HttpMultipartFieldImpl;
import com.intellij.ws.http.request.psi.impl.HttpMultipartMessageImpl;
import com.intellij.ws.http.request.psi.impl.HttpPathAbsoluteImpl;
import com.intellij.ws.http.request.psi.impl.HttpPortImpl;
import com.intellij.ws.http.request.psi.impl.HttpQueryImpl;
import com.intellij.ws.http.request.psi.impl.HttpQueryParameterImpl;
import com.intellij.ws.http.request.psi.impl.HttpQueryParameterKeyImpl;
import com.intellij.ws.http.request.psi.impl.HttpQueryParameterValueImpl;
import com.intellij.ws.http.request.psi.impl.HttpRequestImpl;
import com.intellij.ws.http.request.psi.impl.HttpRequestMessagesGroupImpl;
import com.intellij.ws.http.request.psi.impl.HttpRequestTargetImpl;
import com.intellij.ws.http.request.psi.impl.HttpResponseHandlerImpl;
import com.intellij.ws.http.request.psi.impl.HttpResponseScriptImpl;
import com.intellij.ws.http.request.psi.impl.HttpSchemeImpl;
import com.intellij.ws.http.request.psi.impl.HttpScriptBodyImpl;
import com.intellij.ws.http.request.psi.impl.HttpVariableImpl;

public interface HttpRequestElementTypes {
    public static final IElementType DIFFERENCE_FILE = new HttpRequestElementType("DIFFERENCE_FILE");
    public static final IElementType FILE_PATH = new HttpRequestElementType("FILE_PATH");
    public static final IElementType FRAGMENT = new HttpRequestElementType("FRAGMENT");
    public static final IElementType HEADER_FIELD = new HttpRequestElementType("HEADER_FIELD");
    public static final IElementType HEADER_FIELD_NAME = new HttpRequestElementType("HEADER_FIELD_NAME");
    public static final IElementType HEADER_FIELD_VALUE = new HttpRequestElementType("HEADER_FIELD_VALUE");
    public static final IElementType HOST = new HttpRequestElementType("HOST");
    public static final IElementType INPUT_FILE = new HttpRequestElementType("INPUT_FILE");
    public static final IElementType MESSAGE_BODY = new HttpRequestElementType("MESSAGE_BODY");
    public static final IElementType METHOD = new HttpRequestElementType("METHOD");
    public static final IElementType MULTIPART_FIELD = new HttpRequestElementType("MULTIPART_FIELD");
    public static final IElementType MULTIPART_MESSAGE = new HttpRequestElementType("MULTIPART_MESSAGE");
    public static final IElementType PATH_ABSOLUTE = new HttpRequestElementType("PATH_ABSOLUTE");
    public static final IElementType PORT = new HttpRequestElementType("PORT");
    public static final IElementType QUERY = new HttpRequestElementType("QUERY");
    public static final IElementType QUERY_PARAMETER = new HttpRequestElementType("QUERY_PARAMETER");
    public static final IElementType QUERY_PARAMETER_KEY = new HttpRequestElementType("QUERY_PARAMETER_KEY");
    public static final IElementType QUERY_PARAMETER_VALUE = new HttpRequestElementType("QUERY_PARAMETER_VALUE");
    public static final IElementType REQUEST = new HttpRequestElementType("REQUEST");
    public static final IElementType REQUEST_BODY = new HttpRequestElementType("REQUEST_BODY");
    public static final IElementType REQUEST_MESSAGE = new HttpRequestElementType("REQUEST_MESSAGE");
    public static final IElementType REQUEST_MESSAGES_GROUP = new HttpRequestElementType("REQUEST_MESSAGES_GROUP");
    public static final IElementType REQUEST_TARGET = new HttpRequestElementType("REQUEST_TARGET");
    public static final IElementType RESPONSE_HANDLER = new HttpRequestElementType("RESPONSE_HANDLER");
    public static final IElementType RESPONSE_SCRIPT = new HttpRequestElementType("RESPONSE_SCRIPT");
    public static final IElementType SCHEME = new HttpRequestElementType("SCHEME");
    public static final IElementType SCRIPT_BODY = new HttpRequestElementType("SCRIPT_BODY");
    public static final IElementType VARIABLE = new HttpRequestElementType("VARIABLE");
    public static final IElementType AND = new HttpRequestTokenType("&");
    public static final IElementType COLON = new HttpRequestTokenType(":");
    public static final IElementType CONNECT = new HttpRequestTokenType("CONNECT");
    public static final IElementType DELETE = new HttpRequestTokenType("DELETE");
    public static final IElementType DIFFERENCE_FILE_PATH = new HttpRequestTokenType("DIFFERENCE_FILE_PATH");
    public static final IElementType DIFFERENCE_SIGN = new HttpRequestTokenType("DIFFERENCE_SIGN");
    public static final IElementType END_SCRIPT_BRACE = new HttpRequestTokenType("END_SCRIPT_BRACE");
    public static final IElementType EQUALS = new HttpRequestTokenType("=");
    public static final IElementType FIELD_NAME = new HttpRequestTokenType("FIELD_NAME");
    public static final IElementType FIELD_VALUE = new HttpRequestTokenType("FIELD_VALUE");
    public static final IElementType GET = new HttpRequestTokenType("GET");
    public static final IElementType HANDLER_FILE_PATH = new HttpRequestTokenType("HANDLER_FILE_PATH");
    public static final IElementType HASH = new HttpRequestTokenType("#");
    public static final IElementType HEAD = new HttpRequestTokenType("HEAD");
    public static final IElementType HOST_VALUE = new HttpRequestTokenType("HOST_VALUE");
    public static final IElementType HTTP = new HttpRequestTokenType("http");
    public static final IElementType HTTPS = new HttpRequestTokenType("https");
    public static final IElementType IDENTIFIER = new HttpRequestTokenType("IDENTIFIER");
    public static final IElementType INPUT_FILE_PATH = new HttpRequestTokenType("INPUT_FILE_PATH");
    public static final IElementType INPUT_SIGN = new HttpRequestTokenType("INPUT_SIGN");
    public static final IElementType INTERMEDIATE_WHITESPACE = new HttpRequestTokenType("INTERMEDIATE_WHITESPACE");
    public static final IElementType LBRACES = new HttpRequestTokenType("{{");
    public static final IElementType MESSAGE_BOUNDARY = new HttpRequestTokenType("MESSAGE_BOUNDARY");
    public static final IElementType MESSAGE_TEXT = new HttpRequestTokenType("MESSAGE_TEXT");
    public static final IElementType OPTIONS = new HttpRequestTokenType("OPTIONS");
    public static final IElementType OUTPUT_SIGN = new HttpRequestTokenType("OUTPUT_SIGN");
    public static final IElementType PATCH = new HttpRequestTokenType("PATCH");
    public static final IElementType PORT_SEGMENT = new HttpRequestTokenType("PORT_SEGMENT");
    public static final IElementType POST = new HttpRequestTokenType("POST");
    public static final IElementType PROTOCOL = new HttpRequestTokenType("HTTP");
    public static final IElementType PUT = new HttpRequestTokenType("PUT");
    public static final IElementType QUERY_NAME = new HttpRequestTokenType("QUERY_NAME");
    public static final IElementType QUERY_VALUE = new HttpRequestTokenType("QUERY_VALUE");
    public static final IElementType QUESTION = new HttpRequestTokenType("?");
    public static final IElementType RBRACES = new HttpRequestTokenType("}}");
    public static final IElementType REQUEST_SEPARATOR = new HttpRequestTokenType("REQUEST_SEPARATOR");
    public static final IElementType SCHEME_SEPARATOR = new HttpRequestTokenType("://");
    public static final IElementType SEGMENT = new HttpRequestTokenType("SEGMENT");
    public static final IElementType SEMICOLON = new HttpRequestTokenType(";");
    public static final IElementType SEPARATOR = new HttpRequestTokenType("/");
    public static final IElementType START_SCRIPT_BRACE = new HttpRequestTokenType("START_SCRIPT_BRACE");
    public static final IElementType TRACE = new HttpRequestTokenType("TRACE");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == DIFFERENCE_FILE) {
                return new HttpDifferenceFileImpl(node);
            }
            if (type == FILE_PATH) {
                return new HttpFilePathImpl(node);
            }
            if (type == FRAGMENT) {
                return new HttpFragmentImpl(node);
            }
            if (type == HEADER_FIELD) {
                return new HttpHeaderFieldImpl(node);
            }
            if (type == HEADER_FIELD_NAME) {
                return new HttpHeaderFieldNameImpl(node);
            }
            if (type == HEADER_FIELD_VALUE) {
                return new HttpHeaderFieldValueImpl(node);
            }
            if (type == HOST) {
                return new HttpHostImpl(node);
            }
            if (type == INPUT_FILE) {
                return new HttpInputFileImpl(node);
            }
            if (type == MESSAGE_BODY) {
                return new HttpMessageBodyImpl(node);
            }
            if (type == METHOD) {
                return new HttpMethodImpl(node);
            }
            if (type == MULTIPART_FIELD) {
                return new HttpMultipartFieldImpl(node);
            }
            if (type == MULTIPART_MESSAGE) {
                return new HttpMultipartMessageImpl(node);
            }
            if (type == PATH_ABSOLUTE) {
                return new HttpPathAbsoluteImpl(node);
            }
            if (type == PORT) {
                return new HttpPortImpl(node);
            }
            if (type == QUERY) {
                return new HttpQueryImpl(node);
            }
            if (type == QUERY_PARAMETER) {
                return new HttpQueryParameterImpl(node);
            }
            if (type == QUERY_PARAMETER_KEY) {
                return new HttpQueryParameterKeyImpl(node);
            }
            if (type == QUERY_PARAMETER_VALUE) {
                return new HttpQueryParameterValueImpl(node);
            }
            if (type == REQUEST) {
                return new HttpRequestImpl(node);
            }
            if (type == REQUEST_MESSAGES_GROUP) {
                return new HttpRequestMessagesGroupImpl(node);
            }
            if (type == REQUEST_TARGET) {
                return new HttpRequestTargetImpl(node);
            }
            if (type == RESPONSE_HANDLER) {
                return new HttpResponseHandlerImpl(node);
            }
            if (type == RESPONSE_SCRIPT) {
                return new HttpResponseScriptImpl(node);
            }
            if (type == SCHEME) {
                return new HttpSchemeImpl(node);
            }
            if (type == SCRIPT_BODY) {
                return new HttpScriptBodyImpl(node);
            }
            if (type == VARIABLE) {
                return new HttpVariableImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + type));
        }
    }
}

