/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions;

import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.UIBundle;
import com.intellij.util.PathUtil;
import com.intellij.util.Producer;
import com.intellij.ws.http.request.HttpRequestFileType;
import com.intellij.ws.http.request.HttpRequestLanguage;
import com.intellij.ws.http.request.HttpRequestPsiConverter;
import com.intellij.ws.http.request.HttpRequestPsiFile;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.rest.client.RestClientBundle;
import com.intellij.ws.rest.client.RestClientRequest;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class OpenInScratchFileAction
extends AnAction {
    private final Producer<RestClientRequest> myRequestProducer;

    public OpenInScratchFileAction(@NotNull Producer<RestClientRequest> requestProducer) {
        if (requestProducer == null) {
            OpenInScratchFileAction.$$$reportNull$$$0(0);
        }
        this.myRequestProducer = requestProducer;
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        RestClientRequest request = (RestClientRequest)this.myRequestProducer.produce();
        OpenInScratchFileAction.createAndOpenScratchFile(project, request);
    }

    public static void createAndOpenScratchFile(final @NotNull Project project, final @NotNull RestClientRequest request) {
        if (project == null) {
            OpenInScratchFileAction.$$$reportNull$$$0(1);
        }
        if (request == null) {
            OpenInScratchFileAction.$$$reportNull$$$0(2);
        }
        final String fileName = PathUtil.makeFileName((String)"rest-api", (String)HttpRequestFileType.INSTANCE.getDefaultExtension());
        RunResult result = new WriteCommandAction<NavigatablePsiElement>(project, RestClientBundle.message("http.request.create.scratch.file.with.request.action.title", new Object[0]), new PsiFile[0]){

            protected boolean isGlobalUndoAction() {
                return true;
            }

            protected boolean shouldRecordActionForActiveDocument() {
                return false;
            }

            protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
            }

            protected void run(@NotNull Result<NavigatablePsiElement> result) throws Throwable {
                VirtualFile file;
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                ScratchFileService fileService = ScratchFileService.getInstance();
                try {
                    file = fileService.findFile((RootType)ScratchRootType.getInstance(), fileName, ScratchFileService.Option.create_new_always);
                }
                catch (IOException e) {
                    throw new Exception(UIBundle.message((String)"create.new.file.could.not.create.file.error.message", (Object[])new Object[]{fileName}), e);
                }
                fileService.getScratchesMapping().setMapping(file, (Object)HttpRequestLanguage.INSTANCE);
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                if (!(psiFile instanceof HttpRequestPsiFile)) {
                    throw new Exception(RestClientBundle.message("http.request.create.scratch.file.with.request.failed", new Object[0]));
                }
                PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
                Document document = manager.getDocument(psiFile);
                if (document == null) {
                    throw new Exception(RestClientBundle.message("http.request.create.scratch.file.with.request.file.is.invalid", new Object[0]));
                }
                document.insertString(document.getTextLength(), (CharSequence)HttpRequestPsiConverter.toPsiHttpRequest(request));
                manager.commitDocument(document);
                HttpRequest[] updatedRequests = (HttpRequest[])PsiTreeUtil.getChildrenOfType((PsiElement)psiFile, HttpRequest.class);
                if (updatedRequests != null && updatedRequests.length > 0) {
                    result.setResult((Object)updatedRequests[updatedRequests.length - 1]);
                } else {
                    result.setResult((Object)psiFile);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ws/actions/OpenInScratchFileAction$1", "run"));
            }
        }.execute();
        if (result.hasException()) {
            Messages.showErrorDialog((Project)project, (String)result.getThrowable().getMessage(), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]));
            return;
        }
        NavigatablePsiElement psiElement = (NavigatablePsiElement)result.getResultObject();
        if (psiElement != null) {
            psiElement.navigate(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestProducer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/actions/OpenInScratchFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createAndOpenScratchFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

