/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcherEx;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.CharSequenceHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTypeAssocTable<T> {
    private final Map<CharSequence, T> myExtensionMappings;
    private final Map<CharSequence, T> myExactFileNameMappings;
    private final Map<CharSequence, T> myExactFileNameAnyCaseMappings;
    private final List<Pair<FileNameMatcher, T>> myMatchingMappings;

    private FileTypeAssocTable(@NotNull Map<CharSequence, T> extensionMappings, @NotNull Map<CharSequence, T> exactFileNameMappings, @NotNull Map<CharSequence, T> exactFileNameAnyCaseMappings, @NotNull List<Pair<FileNameMatcher, T>> matchingMappings) {
        if (extensionMappings == null) {
            FileTypeAssocTable.$$$reportNull$$$0(0);
        }
        if (exactFileNameMappings == null) {
            FileTypeAssocTable.$$$reportNull$$$0(1);
        }
        if (exactFileNameAnyCaseMappings == null) {
            FileTypeAssocTable.$$$reportNull$$$0(2);
        }
        if (matchingMappings == null) {
            FileTypeAssocTable.$$$reportNull$$$0(3);
        }
        this.myExtensionMappings = new THashMap(Math.max(10, extensionMappings.size()), 0.5f, (TObjectHashingStrategy)CharSequenceHashingStrategy.CASE_INSENSITIVE);
        this.myExtensionMappings.putAll(extensionMappings);
        this.myExactFileNameMappings = new THashMap(Math.max(10, exactFileNameMappings.size()), 0.5f, (TObjectHashingStrategy)CharSequenceHashingStrategy.CASE_SENSITIVE);
        this.myExactFileNameMappings.putAll(exactFileNameMappings);
        this.myExactFileNameAnyCaseMappings = new THashMap(Math.max(10, exactFileNameAnyCaseMappings.size()), 0.5f, (TObjectHashingStrategy)CharSequenceHashingStrategy.CASE_INSENSITIVE);
        this.myExactFileNameAnyCaseMappings.putAll(exactFileNameAnyCaseMappings);
        this.myMatchingMappings = new ArrayList<Pair<FileNameMatcher, T>>(matchingMappings);
    }

    public FileTypeAssocTable() {
        this(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList());
    }

    boolean isAssociatedWith(@NotNull T type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            FileTypeAssocTable.$$$reportNull$$$0(4);
        }
        if (matcher == null) {
            FileTypeAssocTable.$$$reportNull$$$0(5);
        }
        if (matcher instanceof ExtensionFileNameMatcher || matcher instanceof ExactFileNameMatcher) {
            return this.findAssociatedFileType(matcher) == type;
        }
        for (Pair<FileNameMatcher, T> mapping : this.myMatchingMappings) {
            if (!matcher.equals(mapping.getFirst()) || type != mapping.getSecond()) continue;
            return true;
        }
        return false;
    }

    public void addAssociation(@NotNull FileNameMatcher matcher, @NotNull T type) {
        if (matcher == null) {
            FileTypeAssocTable.$$$reportNull$$$0(6);
        }
        if (type == null) {
            FileTypeAssocTable.$$$reportNull$$$0(7);
        }
        if (matcher instanceof ExtensionFileNameMatcher) {
            this.myExtensionMappings.put(((ExtensionFileNameMatcher)matcher).getExtension(), type);
        } else if (matcher instanceof ExactFileNameMatcher) {
            ExactFileNameMatcher exactFileNameMatcher = (ExactFileNameMatcher)matcher;
            Map<CharSequence, T> mapToUse = exactFileNameMatcher.isIgnoreCase() ? this.myExactFileNameAnyCaseMappings : this.myExactFileNameMappings;
            mapToUse.put(exactFileNameMatcher.getFileName(), type);
        } else {
            this.myMatchingMappings.add(Pair.create((Object)matcher, type));
        }
    }

    boolean removeAssociation(@NotNull FileNameMatcher matcher, @NotNull T type) {
        if (matcher == null) {
            FileTypeAssocTable.$$$reportNull$$$0(8);
        }
        if (type == null) {
            FileTypeAssocTable.$$$reportNull$$$0(9);
        }
        if (matcher instanceof ExtensionFileNameMatcher) {
            String extension = ((ExtensionFileNameMatcher)matcher).getExtension();
            if (this.myExtensionMappings.get(extension) == type) {
                this.myExtensionMappings.remove(extension);
                return true;
            }
            return false;
        }
        if (matcher instanceof ExactFileNameMatcher) {
            Map<CharSequence, T> map;
            ExactFileNameMatcher exactFileNameMatcher = (ExactFileNameMatcher)matcher;
            String fileName = exactFileNameMatcher.getFileName();
            Map<CharSequence, T> map2 = map = exactFileNameMatcher.isIgnoreCase() ? this.myExactFileNameAnyCaseMappings : this.myExactFileNameMappings;
            if (map.get(fileName) == type) {
                map.remove(fileName);
                return true;
            }
            return false;
        }
        ArrayList<Pair<FileNameMatcher, T>> copy = new ArrayList<Pair<FileNameMatcher, T>>(this.myMatchingMappings);
        for (Pair pair : copy) {
            if (!matcher.equals(pair.getFirst())) continue;
            this.myMatchingMappings.remove(pair);
            return true;
        }
        return false;
    }

    boolean removeAllAssociations(@NotNull T type) {
        if (type == null) {
            FileTypeAssocTable.$$$reportNull$$$0(10);
        }
        boolean changed = this.removeAssociationsFromMap(this.myExtensionMappings, type, false);
        changed = this.removeAssociationsFromMap(this.myExactFileNameAnyCaseMappings, type, changed);
        changed = this.removeAssociationsFromMap(this.myExactFileNameMappings, type, changed);
        ArrayList<Pair<FileNameMatcher, T>> copy = new ArrayList<Pair<FileNameMatcher, T>>(this.myMatchingMappings);
        for (Pair pair : copy) {
            if (pair.getSecond() != type) continue;
            this.myMatchingMappings.remove(pair);
            changed = true;
        }
        return changed;
    }

    private boolean removeAssociationsFromMap(@NotNull Map<CharSequence, T> extensionMappings, @NotNull T type, boolean changed) {
        CharSequence[] extsStrings;
        if (extensionMappings == null) {
            FileTypeAssocTable.$$$reportNull$$$0(11);
        }
        if (type == null) {
            FileTypeAssocTable.$$$reportNull$$$0(12);
        }
        Set<CharSequence> exts = extensionMappings.keySet();
        for (CharSequence s : extsStrings = exts.toArray(new CharSequence[0])) {
            if (extensionMappings.get(s) != type) continue;
            extensionMappings.remove(s);
            changed = true;
        }
        return changed;
    }

    @Nullable
    public T findAssociatedFileType(@NotNull @NonNls CharSequence fileName) {
        T t;
        if (fileName == null) {
            FileTypeAssocTable.$$$reportNull$$$0(13);
        }
        if (!this.myExactFileNameMappings.isEmpty() && (t = this.myExactFileNameMappings.get(fileName)) != null) {
            return t;
        }
        if (!this.myExactFileNameAnyCaseMappings.isEmpty() && (t = this.myExactFileNameAnyCaseMappings.get(fileName)) != null) {
            return t;
        }
        for (int i = 0; i < this.myMatchingMappings.size(); ++i) {
            Pair<FileNameMatcher, T> mapping = this.myMatchingMappings.get(i);
            if (!FileNameMatcherEx.acceptsCharSequence((FileNameMatcher)((FileNameMatcher)mapping.getFirst()), (CharSequence)fileName)) continue;
            return (T)mapping.getSecond();
        }
        return this.myExtensionMappings.get(FileUtilRt.getExtension((CharSequence)fileName));
    }

    @Nullable
    T findAssociatedFileType(@NotNull FileNameMatcher matcher) {
        if (matcher == null) {
            FileTypeAssocTable.$$$reportNull$$$0(14);
        }
        if (matcher instanceof ExtensionFileNameMatcher) {
            return this.myExtensionMappings.get(((ExtensionFileNameMatcher)matcher).getExtension());
        }
        if (matcher instanceof ExactFileNameMatcher) {
            ExactFileNameMatcher exactFileNameMatcher = (ExactFileNameMatcher)matcher;
            Map<CharSequence, T> mapToUse = exactFileNameMatcher.isIgnoreCase() ? this.myExactFileNameAnyCaseMappings : this.myExactFileNameMappings;
            return mapToUse.get(exactFileNameMatcher.getFileName());
        }
        for (Pair<FileNameMatcher, T> mapping : this.myMatchingMappings) {
            if (!matcher.equals(mapping.getFirst())) continue;
            return (T)mapping.getSecond();
        }
        return null;
    }

    @Deprecated
    @NotNull
    public String[] getAssociatedExtensions(@NotNull T type) {
        if (type == null) {
            FileTypeAssocTable.$$$reportNull$$$0(15);
        }
        ArrayList<String> exts = new ArrayList<String>();
        for (Map.Entry<CharSequence, T> entry : this.myExtensionMappings.entrySet()) {
            if (entry.getValue() != type) continue;
            exts.add(entry.getKey().toString());
        }
        String[] stringArray = ArrayUtil.toStringArray(exts);
        if (stringArray == null) {
            FileTypeAssocTable.$$$reportNull$$$0(16);
        }
        return stringArray;
    }

    @NotNull
    public FileTypeAssocTable<T> copy() {
        FileTypeAssocTable<T> fileTypeAssocTable = new FileTypeAssocTable<T>(this.myExtensionMappings, this.myExactFileNameMappings, this.myExactFileNameAnyCaseMappings, this.myMatchingMappings);
        if (fileTypeAssocTable == null) {
            FileTypeAssocTable.$$$reportNull$$$0(17);
        }
        return fileTypeAssocTable;
    }

    @NotNull
    public List<FileNameMatcher> getAssociations(@NotNull T type) {
        if (type == null) {
            FileTypeAssocTable.$$$reportNull$$$0(18);
        }
        ArrayList<FileNameMatcher> result = new ArrayList<FileNameMatcher>();
        for (Pair<FileNameMatcher, T> pair : this.myMatchingMappings) {
            if (pair.getSecond() != type) continue;
            result.add((FileNameMatcher)pair.getFirst());
        }
        for (Map.Entry entry : this.myExactFileNameMappings.entrySet()) {
            if (entry.getValue() != type) continue;
            result.add((FileNameMatcher)new ExactFileNameMatcher(((CharSequence)entry.getKey()).toString()));
        }
        for (Map.Entry entry : this.myExactFileNameAnyCaseMappings.entrySet()) {
            if (entry.getValue() != type) continue;
            result.add((FileNameMatcher)new ExactFileNameMatcher(((CharSequence)entry.getKey()).toString(), true));
        }
        for (Map.Entry entry : this.myExtensionMappings.entrySet()) {
            if (entry.getValue() != type) continue;
            result.add((FileNameMatcher)new ExtensionFileNameMatcher(((CharSequence)entry.getKey()).toString()));
        }
        ArrayList<FileNameMatcher> arrayList = result;
        if (arrayList == null) {
            FileTypeAssocTable.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    boolean hasAssociationsFor(@NotNull T fileType) {
        if (fileType == null) {
            FileTypeAssocTable.$$$reportNull$$$0(20);
        }
        if (this.myExtensionMappings.values().contains(fileType) || this.myExactFileNameMappings.values().contains(fileType) || this.myExactFileNameAnyCaseMappings.values().contains(fileType)) {
            return true;
        }
        for (Pair<FileNameMatcher, T> mapping : this.myMatchingMappings) {
            if (mapping.getSecond() != fileType) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileTypeAssocTable that = (FileTypeAssocTable)o;
        return this.myExtensionMappings.equals(that.myExtensionMappings) && this.myMatchingMappings.equals(that.myMatchingMappings) && this.myExactFileNameMappings.equals(that.myExactFileNameMappings) && this.myExactFileNameAnyCaseMappings.equals(that.myExactFileNameAnyCaseMappings);
    }

    public int hashCode() {
        int result = this.myExtensionMappings.hashCode();
        result = 31 * result + this.myMatchingMappings.hashCode();
        result = 31 * result + this.myExactFileNameMappings.hashCode();
        result = 31 * result + this.myExactFileNameAnyCaseMappings.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 17: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionMappings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exactFileNameMappings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exactFileNameAnyCaseMappings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchingMappings";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociatedExtensions";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAssociatedWith";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addAssociation";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeAssociation";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeAllAssociations";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeAssociationsFromMap";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findAssociatedFileType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedExtensions";
                break;
            }
            case 16: 
            case 17: 
            case 19: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAssociations";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "hasAssociationsFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

