/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote.sdk.add.wizard.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.ui.CreateRemoteSdkForm;
import com.jetbrains.plugins.remotesdk.ui.DeploymentProjectLevelSetupForm;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.WebDeploymentCredentialHelper;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.WebServerCombo;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.remote.sdk.add.wizard.ui.ValidationAwareForm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshServerConfigurationForm
extends ValidationAwareForm {
    private JPanel myMainPanel;
    private JBRadioButton myNewServerConfigurationRadioButton;
    private JPanel myNewServerConfigurationPanel;
    private JBTextField myHostTextField;
    private JBTextField myPortTextField;
    private JBTextField myUsernameTextField;
    private JBRadioButton myExistingServerConfigurationRadioButton;
    private JBLabel myDeploymentConfigurationLabel;
    private WebServerCombo myDeploymentConfigurationComboBox;
    private JBLabel myHostURLLabel;
    private JBLabel myHostURLValueLabel;
    private JPanel myDeploymentProjectLevelServerSetupPanel;
    @NotNull
    private final DeploymentProjectLevelSetupForm myDeploymentProjectLevelSetupForm;
    private static final Condition<WebServerConfig> SFTP_SERVERS_FILTER = config -> config.getFileTransferConfig().getAccessType() == AccessType.SFTP;
    private static final CreateRemoteSdkForm.BundleAccessor BUNDLE_ACCESSOR = new CreateRemoteSdkForm.BundleAccessor(){

        @NotNull
        public String message(@NotNull String key, Object ... params) {
            if (key == null) {
                1.$$$reportNull$$$0(0);
            }
            String string = PyBundle.message((String)key, (Object[])params);
            if (string == null) {
                1.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public String messageOrNull(@NotNull String key, Object ... params) {
            if (key == null) {
                1.$$$reportNull$$$0(2);
            }
            return PyBundle.messageOfNull((String)key, (Object[])params);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/remote/sdk/add/wizard/ui/SshServerConfigurationForm$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/remote/sdk/add/wizard/ui/SshServerConfigurationForm$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "message";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "message";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "messageOrNull";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    private void createUIComponents() {
        this.myDeploymentConfigurationComboBox = new WebServerCombo(true, -1, false);
    }

    public SshServerConfigurationForm(@Nullable Project project, @NotNull Disposable parent) {
        if (parent == null) {
            SshServerConfigurationForm.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.myDeploymentConfigurationComboBox.setProject(project);
        this.myDeploymentConfigurationComboBox.setWebServerFilter(SFTP_SERVERS_FILTER);
        this.myDeploymentConfigurationComboBox.reset(null);
        Disposer.register((Disposable)parent, (Disposable)this.myDeploymentConfigurationComboBox);
        this.myNewServerConfigurationRadioButton.addActionListener(e -> this.onNewConfigurationSelected());
        this.myExistingServerConfigurationRadioButton.addActionListener(e -> this.onExistingConfigurationSelected());
        DocumentListener listener = this.createUpdateIsValidDocumentListener();
        this.myHostTextField.getDocument().addDocumentListener(listener);
        this.myPortTextField.getDocument().addDocumentListener(listener);
        this.myUsernameTextField.getDocument().addDocumentListener(listener);
        this.myDeploymentConfigurationComboBox.addChangeListener(e -> this.onDeploymentConfigurationChanged());
        this.myDeploymentProjectLevelSetupForm = new DeploymentProjectLevelSetupForm(project, BUNDLE_ACCESSOR, new DeploymentProjectLevelSetupForm.Listener(){

            public void onConfigCopied(@NotNull WebServerConfig global) {
                if (global == null) {
                    2.$$$reportNull$$$0(0);
                }
                SshServerConfigurationForm.this.setupDeploymentCombo(global);
            }

            public void onConfigMoved(@NotNull WebServerConfig movedServer) {
                if (movedServer == null) {
                    2.$$$reportNull$$$0(1);
                }
                SshServerConfigurationForm.this.setupDeploymentCombo(movedServer);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "global";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "movedServer";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/python/remote/sdk/add/wizard/ui/SshServerConfigurationForm$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onConfigCopied";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onConfigMoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myDeploymentProjectLevelServerSetupPanel.setVisible(false);
        this.myDeploymentProjectLevelServerSetupPanel.setLayout(new BorderLayout());
        this.myDeploymentProjectLevelServerSetupPanel.add((Component)this.myDeploymentProjectLevelSetupForm.getMainPanel(), "Center");
        this.myNewServerConfigurationRadioButton.setSelected(true);
        this.onNewConfigurationSelected();
        this.hideDeploymentConfigurationURL();
    }

    private void setupDeploymentCombo(@Nullable WebServerConfig configToSelect) {
        if (configToSelect == null) {
            this.myDeploymentConfigurationComboBox.reset(null);
        } else {
            this.myDeploymentConfigurationComboBox.reset(Pair.create((Object)configToSelect.getId(), (Object)configToSelect.getName()));
            this.myDeploymentProjectLevelServerSetupPanel.setVisible(StringUtil.isNotEmpty((String)this.validateDeployment(configToSelect)));
        }
        this.onDeploymentConfigurationChanged();
    }

    @Nullable
    public String validateDeployment(@NotNull WebServerConfig server) {
        if (server == null) {
            SshServerConfigurationForm.$$$reportNull$$$0(1);
        }
        if (server.isProjectLevel()) {
            return "Project level deployment servers are not currently supported. Please create one using any of the two links above.";
        }
        return null;
    }

    private void onNewConfigurationSelected() {
        this.updateConfigurationOptionsEnabled(true);
        this.updateDeploymentProjectLevelServerSetupPanel();
        this.updateIsValid();
    }

    private void onExistingConfigurationSelected() {
        this.updateConfigurationOptionsEnabled(false);
        this.updateDeploymentProjectLevelServerSetupPanel();
        this.updateIsValid();
    }

    private void onDeploymentConfigurationChanged() {
        WebServerConfig config = this.myDeploymentConfigurationComboBox.getSelectedServer();
        if (config == null) {
            this.hideDeploymentConfigurationURL();
        } else {
            RemoteCredentials credentials = WebDeploymentCredentialHelper.getRemoteCredentials((WebServerConfig)config);
            String url = RemoteCredentialsHolder.getCredentialsString((RemoteCredentials)credentials);
            this.showDeploymentConfigurationURL(url);
        }
        this.updateDeploymentProjectLevelServerSetupPanel();
        this.updateIsValid();
    }

    private void hideDeploymentConfigurationURL() {
        this.myHostURLLabel.setVisible(false);
        this.myHostURLValueLabel.setVisible(false);
    }

    private void showDeploymentConfigurationURL(@NotNull String url) {
        if (url == null) {
            SshServerConfigurationForm.$$$reportNull$$$0(2);
        }
        this.myHostURLLabel.setVisible(true);
        this.myHostURLValueLabel.setVisible(true);
        this.myHostURLValueLabel.setText(url);
    }

    @Override
    protected boolean computeIsValid() {
        if (this.myNewServerConfigurationRadioButton.isSelected()) {
            return this.getHost() != null && this.getPort() != null && this.getUsername() != null;
        }
        if (this.myExistingServerConfigurationRadioButton.isSelected()) {
            WebServerConfig server = this.myDeploymentConfigurationComboBox.getSelectedServer();
            return server != null && !server.isProjectLevel();
        }
        return false;
    }

    private void updateDeploymentProjectLevelServerSetupPanel() {
        WebServerConfig selectedServer = this.myDeploymentConfigurationComboBox.getSelectedServer();
        if (this.myNewServerConfigurationRadioButton.isSelected() || selectedServer == null || !selectedServer.isProjectLevel()) {
            this.myDeploymentProjectLevelSetupForm.setWebServerConfigId(null);
            this.myDeploymentProjectLevelServerSetupPanel.setVisible(false);
        } else {
            this.myDeploymentProjectLevelSetupForm.setWebServerConfigId(selectedServer.getId());
            this.myDeploymentProjectLevelServerSetupPanel.setVisible(true);
        }
    }

    private void updateConfigurationOptionsEnabled(boolean newServerOptionEnabled) {
        UIUtil.setEnabled((Component)this.myNewServerConfigurationPanel, (boolean)newServerOptionEnabled, (boolean)true);
        this.myDeploymentConfigurationLabel.setEnabled(!newServerOptionEnabled);
        this.myDeploymentConfigurationComboBox.setEnabled(!newServerOptionEnabled);
        this.myHostURLLabel.setEnabled(!newServerOptionEnabled);
        this.myHostURLValueLabel.setEnabled(!newServerOptionEnabled);
    }

    @NotNull
    public JPanel getMainPanel() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            SshServerConfigurationForm.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @Nullable
    public String getUsername() {
        return StringUtil.nullize((String)this.myUsernameTextField.getText().trim());
    }

    @Nullable
    public String getHost() {
        return StringUtil.nullize((String)this.myHostTextField.getText().trim());
    }

    @Nullable
    public Integer getPort() {
        try {
            return Integer.parseInt(this.myPortTextField.getText().trim());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @NotNull
    public <T> T accept(@NotNull OptionVisitor<T> visitor) {
        if (visitor == null) {
            SshServerConfigurationForm.$$$reportNull$$$0(4);
        }
        if (this.myNewServerConfigurationRadioButton.isSelected()) {
            T t = visitor.onNewServerConfiguration(this.getHost(), this.getPort(), this.getUsername());
            if (t == null) {
                SshServerConfigurationForm.$$$reportNull$$$0(5);
            }
            return t;
        }
        T t = visitor.onExistingServerConfiguration(this.myDeploymentConfigurationComboBox.getSelectedServer());
        if (t == null) {
            SshServerConfigurationForm.$$$reportNull$$$0(6);
        }
        return t;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/sdk/add/wizard/ui/SshServerConfigurationForm";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/sdk/add/wizard/ui/SshServerConfigurationForm";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainPanel";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "accept";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "validateDeployment";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showDeploymentConfigurationURL";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JBTextField jBTextField;
        JBTextField jBTextField2;
        JBTextField jBTextField3;
        JPanel jPanel2;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myNewServerConfigurationRadioButton = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setText("New server configuration");
        jPanel3.add((Component)jBRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myExistingServerConfigurationRadioButton = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("Existing server configuration");
        jPanel3.add((Component)jBRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNewServerConfigurationPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 3));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Host:");
        jPanel2.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("Port:");
        jPanel2.add((Component)jBLabel5, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPortTextField = jBTextField3 = new JBTextField();
        jBTextField3.setText("22");
        jPanel2.add((Component)jBTextField3, new GridConstraints(0, 3, 1, 1, 8, 1, 0, 0, null, new Dimension(60, -1), null));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setText("Username:");
        jPanel2.add((Component)jBLabel6, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUsernameTextField = jBTextField2 = new JBTextField();
        jBTextField2.setText("");
        jPanel2.add((Component)jBTextField2, new GridConstraints(1, 1, 1, 1, 8, 0, 7, 3, null, new Dimension(200, -1), null));
        this.myHostTextField = jBTextField = new JBTextField();
        jBTextField.setText("");
        jPanel2.add((Component)jBTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 3, null, new Dimension(120, -1), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null, 3));
        this.myDeploymentConfigurationLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Deployment configuration:");
        jPanel4.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        WebServerCombo webServerCombo = this.myDeploymentConfigurationComboBox;
        jPanel4.add((Component)webServerCombo, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myHostURLLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Host URL:");
        jPanel4.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHostURLValueLabel = jBLabel = new JBLabel();
        jPanel4.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDeploymentProjectLevelServerSetupPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel5.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    public static interface OptionVisitor<T> {
        @NotNull
        public T onNewServerConfiguration(@NotNull String var1, int var2, @NotNull String var3);

        @NotNull
        public T onExistingServerConfiguration(@NotNull WebServerConfig var1);
    }
}

