/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote.sdk.add.wizard.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.ui.RemoteBrowseActionListener;
import com.jetbrains.plugins.remotesdk.ui.RemoteMappingsUIUtil;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.python.remote.sdk.add.wizard.ui.SyncFoldersDialog;
import com.jetbrains.python.remote.sdk.add.wizard.ui.ValidationAwareForm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshAdditionalConfigurationForm
extends ValidationAwareForm {
    private JPanel myMainPanel;
    private JBLabel myConnectedLabel;
    private TextFieldWithBrowseButton myInterpreterPathTextField;
    private JPanel myDeploymentPanel;
    private TextFieldWithBrowseButton myPathMappingsTextField;
    private JBCheckBox myUploadCheckBox;
    private JPanel myContextHelpPanel;
    private JLabel myErrorLabel;
    @NotNull
    private List<DeploymentPathMapping> myDeploymentPathMappings;

    public SshAdditionalConfigurationForm(@Nullable Project project, @NotNull RemoteCredentials remoteCredentials, @NotNull String user, @NotNull String host, int port) {
        boolean showDeploymentSettings;
        if (remoteCredentials == null) {
            SshAdditionalConfigurationForm.$$$reportNull$$$0(0);
        }
        if (user == null) {
            SshAdditionalConfigurationForm.$$$reportNull$$$0(1);
        }
        if (host == null) {
            SshAdditionalConfigurationForm.$$$reportNull$$$0(2);
        }
        this.$$$setupUI$$$();
        this.myDeploymentPathMappings = ContainerUtil.emptyList();
        this.myConnectedLabel.setText(String.format("Connected to %s@%s:%d", user, host, port));
        RemoteBrowseActionListener.addShowBrowseRemoteDialogAction((TextFieldWithBrowseButton)this.myInterpreterPathTextField, (String)"Select Python Interpreter", consumer -> {
            if (remoteCredentials == null) {
                SshAdditionalConfigurationForm.$$$reportNull$$$0(13);
            }
            consumer.consume((Object)remoteCredentials);
        });
        this.myInterpreterPathTextField.getTextField().getDocument().addDocumentListener(this.createUpdateIsValidDocumentListener());
        this.myPathMappingsTextField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                SshAdditionalConfigurationForm.this.validate();
            }
        });
        boolean bl = showDeploymentSettings = project != null && !project.isDefault();
        if (showDeploymentSettings) {
            this.myDeploymentPathMappings = SshAdditionalConfigurationForm.createDefaultDeploymentPathMappings(project);
            this.myPathMappingsTextField.getButton().addActionListener(e -> {
                if (remoteCredentials == null) {
                    SshAdditionalConfigurationForm.$$$reportNull$$$0(12);
                }
                SyncFoldersDialog dialog = new SyncFoldersDialog(project, remoteCredentials, this.myDeploymentPathMappings);
                dialog.pack();
                if (dialog.showAndGet()) {
                    this.myDeploymentPathMappings = dialog.getDeploymentPathMappings();
                    this.updatePathMappingsTextField(project);
                    this.updateIsValid();
                }
            });
            this.updatePathMappingsTextField(project);
        } else {
            this.myDeploymentPanel.setVisible(false);
        }
        this.myContextHelpPanel.add((Component)ContextHelpLabel.create((String)"Files will be initially uploaded to the server after configuring the interpreter. After any local change, the file will be uploaded to the server, overwriting any remote files."), "West");
        this.updateIsValid();
    }

    private void validate() {
        if (this.myDeploymentPathMappings.isEmpty()) {
            this.showError("<html><b>No path mappings configured</b><br/>PyCharm needs path mappings in order to correctly run and debug your code on the server<html>");
        } else {
            this.showError(null);
        }
    }

    private void showError(@Nullable String message) {
        this.myErrorLabel.setVisible(message != null);
        if (message != null) {
            this.myErrorLabel.setIcon(AllIcons.General.Error);
            this.myErrorLabel.setText(message);
        }
    }

    @NotNull
    private static List<DeploymentPathMapping> createDefaultDeploymentPathMappings(@NotNull Project project) {
        if (project == null) {
            SshAdditionalConfigurationForm.$$$reportNull$$$0(3);
        }
        ArrayList<DeploymentPathMapping> result = new ArrayList<DeploymentPathMapping>();
        String projectPath = project.getBasePath();
        if (projectPath != null) {
            DeploymentPathMapping defaultMapping = new DeploymentPathMapping();
            defaultMapping.setLocalPath(projectPath);
            defaultMapping.setDeployPath(SshAdditionalConfigurationForm.getDefaultProjectDeployPath());
            result.add(defaultMapping);
        }
        ArrayList<DeploymentPathMapping> arrayList = result;
        if (arrayList == null) {
            SshAdditionalConfigurationForm.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private static String getDefaultProjectDeployPath() {
        String string = "/tmp/pycharm_project_" + Math.round(Math.random() * 1000.0);
        if (string == null) {
            SshAdditionalConfigurationForm.$$$reportNull$$$0(5);
        }
        return string;
    }

    private void updatePathMappingsTextField(@NotNull Project project) {
        if (project == null) {
            SshAdditionalConfigurationForm.$$$reportNull$$$0(6);
        }
        List pathMappings = this.myDeploymentPathMappings.stream().map(SshAdditionalConfigurationForm::toDeploymentPathMapping).collect(Collectors.toList());
        String presentation = RemoteMappingsUIUtil.getPresentation((Project)project, pathMappings);
        this.myPathMappingsTextField.setText(StringUtil.defaultIfEmpty((String)presentation, (String)"(Empty)"));
    }

    @NotNull
    private static PathMappingSettings.PathMapping toDeploymentPathMapping(@NotNull DeploymentPathMapping mapping) {
        if (mapping == null) {
            SshAdditionalConfigurationForm.$$$reportNull$$$0(7);
        }
        PathMappingSettings.PathMapping pathMapping = new PathMappingSettings.PathMapping(mapping.getLocalPath(), mapping.getDeployPath());
        if (pathMapping == null) {
            SshAdditionalConfigurationForm.$$$reportNull$$$0(8);
        }
        return pathMapping;
    }

    @NotNull
    public JPanel getMainPanel() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            SshAdditionalConfigurationForm.$$$reportNull$$$0(9);
        }
        return jPanel;
    }

    @Override
    protected boolean computeIsValid() {
        return !StringUtil.isEmptyOrSpaces((String)this.myInterpreterPathTextField.getText()) && (!this.areDeploymentSettingsVisible() || !this.myDeploymentPathMappings.isEmpty());
    }

    @NotNull
    public String getInterpreterPath() {
        String string = this.myInterpreterPathTextField.getText();
        if (string == null) {
            SshAdditionalConfigurationForm.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public List<DeploymentPathMapping> getDeploymentPathMappings() {
        List<DeploymentPathMapping> list = Collections.unmodifiableList(this.myDeploymentPathMappings);
        if (list == null) {
            SshAdditionalConfigurationForm.$$$reportNull$$$0(11);
        }
        return list;
    }

    public boolean isUploadChanges() {
        return this.areDeploymentSettingsVisible() && this.myUploadCheckBox.isSelected();
    }

    private boolean areDeploymentSettingsVisible() {
        return this.myDeploymentPanel.isVisible();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteCredentials";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/sdk/add/wizard/ui/SshAdditionalConfigurationForm";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/sdk/add/wizard/ui/SshAdditionalConfigurationForm";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultDeploymentPathMappings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProjectDeployPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toDeploymentPathMapping";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainPanel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentPathMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultDeploymentPathMappings";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updatePathMappingsTextField";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toDeploymentPathMapping";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$1";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel2;
        JBLabel jBLabel;
        JPanel jPanel3;
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myConnectedLabel = jBLabel = new JBLabel();
        jBLabel.setText("Connected to username@host:port");
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(6, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myDeploymentPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel2, new GridConstraints(2, 0, 4, 2, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Running code on the remote server", (int)0, (int)0, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Sync folders:");
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPathMappingsTextField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton2.setEditable(false);
        jPanel2.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 3, 0, 1, 3, 3, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setComponentStyle(UIUtil.ComponentStyle.REGULAR);
        jBLabel3.setEnabled(false);
        jBLabel3.setFontColor(UIUtil.FontColor.NORMAL);
        jBLabel3.setText(" Mappings between local project paths and remote paths on the server");
        jPanel2.add((Component)jBLabel3, new GridConstraints(1, 1, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myContextHelpPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUploadCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setSelected(true);
        jBCheckBox.setText("Automatically upload project files to the server");
        jPanel2.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 10, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Interpreter:");
        jPanel4.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInterpreterPathTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setText("/usr/bin/python");
        jPanel4.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(7, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myErrorLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

