/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote.sdk.add.wizard;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ssh.SshSession;
import com.intellij.util.ExceptionUtil;
import com.jetbrains.plugins.webDeployment.config.WebDeploymentCredentialHelper;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.python.remote.sdk.add.RemoteSdkCreationUtilKt;
import com.jetbrains.python.remote.sdk.add.wizard.AbstractFinishState;
import com.jetbrains.python.remote.sdk.add.wizard.CreateSshInterpreterWizardState;
import com.jetbrains.python.remote.sdk.add.wizard.InternalStateListener;
import com.jetbrains.python.remote.sdk.add.wizard.ui.SshAdditionalConfigurationForm;
import com.jetbrains.python.remote.sdk.add.wizard.ui.ValidationStatusListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fBU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u001d\u001a\u00020\u000fH\u0016J\b\u0010\u001e\u001a\u00020\u0013H\u0016R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006 "}, d2={"Lcom/jetbrains/python/remote/sdk/add/wizard/FinishExistingServerConfigurationState;", "Lcom/jetbrains/python/remote/sdk/add/wizard/AbstractFinishState;", "username", "", "host", "port", "", "listener", "Lcom/jetbrains/python/remote/sdk/add/wizard/InternalStateListener;", "sshSession", "Lcom/intellij/ssh/SshSession;", "project", "Lcom/intellij/openapi/project/Project;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "existingWebServerConfig", "Lcom/jetbrains/plugins/webDeployment/config/WebServerConfig;", "previousState", "Lcom/jetbrains/python/remote/sdk/add/wizard/CreateSshInterpreterWizardState;", "(Ljava/lang/String;Ljava/lang/String;ILcom/jetbrains/python/remote/sdk/add/wizard/InternalStateListener;Lcom/intellij/ssh/SshSession;Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/jetbrains/plugins/webDeployment/config/WebServerConfig;Lcom/jetbrains/python/remote/sdk/add/wizard/CreateSshInterpreterWizardState;)V", "form", "Lcom/jetbrains/python/remote/sdk/add/wizard/ui/SshAdditionalConfigurationForm;", "getForm", "()Lcom/jetbrains/python/remote/sdk/add/wizard/ui/SshAdditionalConfigurationForm;", "getListener", "()Lcom/jetbrains/python/remote/sdk/add/wizard/InternalStateListener;", "getProject", "()Lcom/intellij/openapi/project/Project;", "finish", "previous", "Companion", "intellij.python.remoteInterpreter"})
public final class FinishExistingServerConfigurationState
extends AbstractFinishState {
    @NotNull
    private final SshAdditionalConfigurationForm form;
    @NotNull
    private final InternalStateListener listener;
    @Nullable
    private final Project project;
    private final List<Sdk> existingSdks;
    private final WebServerConfig existingWebServerConfig;
    private final CreateSshInterpreterWizardState previousState;
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    @NotNull
    public CreateSshInterpreterWizardState previous() {
        return this.previousState;
    }

    @Override
    @NotNull
    protected SshAdditionalConfigurationForm getForm() {
        return this.form;
    }

    @Override
    @NotNull
    public Sdk finish() {
        try {
            Project project = this.getProject();
            String string = this.getForm().getInterpreterPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"form.interpreterPath");
            Sdk sdk = RemoteSdkCreationUtilKt.createSdkFromExistingServerConfiguration(project, this.existingWebServerConfig, this.existingSdks, string);
            this.savePathMappingSettingsOnFinish(this.existingWebServerConfig);
            return sdk;
        }
        catch (RemoteSdkException e) {
            if (!ExceptionUtil.causedBy((Throwable)e, InterruptedException.class)) {
                FinishExistingServerConfigurationState.Companion.getLOG().debug((Throwable)e);
            }
            throw (Throwable)e;
        }
    }

    @Override
    @NotNull
    public InternalStateListener getListener() {
        return this.listener;
    }

    @Override
    @Nullable
    protected Project getProject() {
        return this.project;
    }

    public FinishExistingServerConfigurationState(@NotNull String username, @NotNull String host, int port, @NotNull InternalStateListener listener, @NotNull SshSession sshSession, @Nullable Project project, @NotNull List<? extends Sdk> existingSdks, @NotNull WebServerConfig existingWebServerConfig, @NotNull CreateSshInterpreterWizardState previousState) {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)sshSession, (String)"sshSession");
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        Intrinsics.checkParameterIsNotNull((Object)existingWebServerConfig, (String)"existingWebServerConfig");
        Intrinsics.checkParameterIsNotNull((Object)previousState, (String)"previousState");
        this.listener = listener;
        this.project = project;
        this.existingSdks = existingSdks;
        this.existingWebServerConfig = existingWebServerConfig;
        this.previousState = previousState;
        this.form = new SshAdditionalConfigurationForm(this.getProject(), WebDeploymentCredentialHelper.getRemoteCredentials((WebServerConfig)this.existingWebServerConfig), username, host, port);
        this.getForm().setListener(new ValidationStatusListener(){

            @Override
            public void onValidationStatusChanged() {
                this.getListener().onControlsChanged();
            }
        });
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(FinishExistingServerConfigurationState.class);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/remote/sdk/add/wizard/FinishExistingServerConfigurationState$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.python.remoteInterpreter"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

