/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote.sdk.add.wizard;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.ExceptionUtil;
import com.jetbrains.python.remote.sdk.add.wizard.AbstractConnectingState;
import com.jetbrains.python.remote.sdk.add.wizard.CreateSshInterpreterWizardState;
import com.jetbrains.python.remote.sdk.add.wizard.FinishNewServerConfigurationState;
import com.jetbrains.python.remote.sdk.add.wizard.InternalStateListener;
import com.jetbrains.python.remote.sdk.add.wizard.NewDeploymentServerData;
import com.jetbrains.python.remote.sdk.add.wizard.SshAuthenticationSetupState;
import com.jetbrains.python.remote.sdk.add.wizard.SshConnectionFailureState;
import com.jetbrains.python.remote.sdk.add.wizard.ui.ConnectingToSshServerForm;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fBE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0017X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/python/remote/sdk/add/wizard/ConnectingToSshServerState;", "Lcom/jetbrains/python/remote/sdk/add/wizard/AbstractConnectingState;", "listener", "Lcom/jetbrains/python/remote/sdk/add/wizard/InternalStateListener;", "project", "Lcom/intellij/openapi/project/Project;", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "previousState", "Lcom/jetbrains/python/remote/sdk/add/wizard/CreateSshInterpreterWizardState;", "newDeploymentServerData", "Lcom/jetbrains/python/remote/sdk/add/wizard/NewDeploymentServerData;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "isInitialConnectionAttempt", "", "(Lcom/jetbrains/python/remote/sdk/add/wizard/InternalStateListener;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/application/ModalityState;Lcom/jetbrains/python/remote/sdk/add/wizard/CreateSshInterpreterWizardState;Lcom/jetbrains/python/remote/sdk/add/wizard/NewDeploymentServerData;Ljava/util/List;Z)V", "connectionThread", "Ljava/lang/Thread;", "getConnectionThread", "()Ljava/lang/Thread;", "form", "Lcom/jetbrains/python/remote/sdk/add/wizard/ui/ConnectingToSshServerForm;", "getForm", "()Lcom/jetbrains/python/remote/sdk/add/wizard/ui/ConnectingToSshServerForm;", "host", "", "port", "", "username", "Companion", "intellij.python.remoteInterpreter"})
public final class ConnectingToSshServerState
extends AbstractConnectingState {
    private final String username;
    private final String host;
    private final int port;
    @NotNull
    private final ConnectingToSshServerForm form;
    @NotNull
    private final Thread connectionThread;
    private final Project project;
    private final NewDeploymentServerData newDeploymentServerData;
    private final List<Sdk> existingSdks;
    private final boolean isInitialConnectionAttempt;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    protected ConnectingToSshServerForm getForm() {
        return this.form;
    }

    @Override
    @NotNull
    protected Thread getConnectionThread() {
        return this.connectionThread;
    }

    public ConnectingToSshServerState(final @NotNull InternalStateListener listener, @Nullable Project project, final @NotNull ModalityState modalityState, final @NotNull CreateSshInterpreterWizardState previousState, @NotNull NewDeploymentServerData newDeploymentServerData2, @NotNull List<? extends Sdk> existingSdks, boolean isInitialConnectionAttempt) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)modalityState, (String)"modalityState");
        Intrinsics.checkParameterIsNotNull((Object)previousState, (String)"previousState");
        Intrinsics.checkParameterIsNotNull((Object)newDeploymentServerData2, (String)"newDeploymentServerData");
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        super(listener, previousState);
        this.project = project;
        this.newDeploymentServerData = newDeploymentServerData2;
        this.existingSdks = existingSdks;
        this.isInitialConnectionAttempt = isInitialConnectionAttempt;
        this.username = this.newDeploymentServerData.getUsername();
        this.host = this.newDeploymentServerData.getHost();
        this.port = this.newDeploymentServerData.getPort();
        this.form = new ConnectingToSshServerForm(this.username, this.host, this.port);
        this.connectionThread = new Thread(new Runnable(){

            @Override
            public final void run() {
                try {
                    newDeploymentServerData.checkConnection(project);
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public final void run() {
                            if (!this.getPreviousHit()) {
                                listener.onStateChanged(new FinishNewServerConfigurationState(listener, project, existingSdks, newDeploymentServerData, previousState));
                            }
                        }
                    }, modalityState);
                }
                catch (Exception e) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public final void run() {
                            if (!this.getPreviousHit()) {
                                CreateSshInterpreterWizardState nextState;
                                if (!Companion.isConnectionException(e)) {
                                    String failureMessage = !isInitialConnectionAttempt ? Companion.getAuthenticationFailureErrorMessage(e) : null;
                                    nextState = new SshAuthenticationSetupState(listener, username, host, port, previousState, project, existingSdks, failureMessage);
                                } else {
                                    String string = username;
                                    String string2 = host;
                                    int n = port;
                                    InternalStateListener internalStateListener2 = listener;
                                    CreateSshInterpreterWizardState createSshInterpreterWizardState = previousState;
                                    Throwable throwable = e.getCause();
                                    if (throwable == null) {
                                        throwable = e;
                                    }
                                    String string3 = throwable.getLocalizedMessage();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(e.cause ?: e).localizedMessage");
                                    nextState = new SshConnectionFailureState(string, string2, n, internalStateListener2, createSshInterpreterWizardState, string3);
                                }
                                listener.onStateChanged(nextState);
                            }
                        }
                    }, modalityState);
                }
            }
        });
        this.getConnectionThread().start();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/python/remote/sdk/add/wizard/ConnectingToSshServerState$Companion;", "", "()V", "getAuthenticationFailureErrorMessage", "", "th", "", "isConnectionException", "", "intellij.python.remoteInterpreter"})
    public static final class Companion {
        private final String getAuthenticationFailureErrorMessage(Throwable th) {
            String errorMessage = th.getLocalizedMessage();
            return errorMessage == null || StringsKt.contains$default((CharSequence)errorMessage, (CharSequence)"Auth cancel", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)errorMessage, (CharSequence)"Auth fail", (boolean)false, (int)2, null) ? "Authentication failure" : errorMessage;
        }

        private final boolean isConnectionException(Throwable th) {
            return ExceptionUtil.causedBy((Throwable)th, UnknownHostException.class) || ExceptionUtil.causedBy((Throwable)th, IOException.class);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

