/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote.sdk.add.wizard;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.SshSession;
import com.jetbrains.plugins.remotesdk.RemoteSdkCredentialsProducerImpl;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.python.remote.sdk.add.wizard.AbstractConnectingState;
import com.jetbrains.python.remote.sdk.add.wizard.CreateSshInterpreterWizardState;
import com.jetbrains.python.remote.sdk.add.wizard.FinishExistingServerConfigurationState;
import com.jetbrains.python.remote.sdk.add.wizard.InternalStateListener;
import com.jetbrains.python.remote.sdk.add.wizard.SshConnectionFailureState;
import com.jetbrains.python.remote.sdk.add.wizard.ui.ConnectingToSshServerForm;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0017X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/python/remote/sdk/add/wizard/ConnectingToDeploymentServerState;", "Lcom/jetbrains/python/remote/sdk/add/wizard/AbstractConnectingState;", "webServerConfig", "Lcom/jetbrains/plugins/webDeployment/config/WebServerConfig;", "listener", "Lcom/jetbrains/python/remote/sdk/add/wizard/InternalStateListener;", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "previousState", "Lcom/jetbrains/python/remote/sdk/add/wizard/CreateSshInterpreterWizardState;", "project", "Lcom/intellij/openapi/project/Project;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "(Lcom/jetbrains/plugins/webDeployment/config/WebServerConfig;Lcom/jetbrains/python/remote/sdk/add/wizard/InternalStateListener;Lcom/intellij/openapi/application/ModalityState;Lcom/jetbrains/python/remote/sdk/add/wizard/CreateSshInterpreterWizardState;Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "connectionThread", "Ljava/lang/Thread;", "getConnectionThread", "()Ljava/lang/Thread;", "credentials", "Lcom/intellij/remote/RemoteCredentials;", "form", "Lcom/jetbrains/python/remote/sdk/add/wizard/ui/ConnectingToSshServerForm;", "getForm", "()Lcom/jetbrains/python/remote/sdk/add/wizard/ui/ConnectingToSshServerForm;", "host", "", "getHost", "()Ljava/lang/String;", "port", "", "getPort", "()I", "username", "getUsername", "intellij.python.remoteInterpreter"})
public final class ConnectingToDeploymentServerState
extends AbstractConnectingState {
    private final RemoteCredentials credentials;
    @NotNull
    private final ConnectingToSshServerForm form;
    @NotNull
    private final Thread connectionThread;
    private final WebServerConfig webServerConfig;
    private final Project project;
    private final List<Sdk> existingSdks;

    private final String getUsername() {
        String string = this.credentials.getUserName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"credentials.userName");
        return string;
    }

    private final String getHost() {
        String string = this.credentials.getHost();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"credentials.host");
        return string;
    }

    private final int getPort() {
        return this.credentials.getPort();
    }

    @Override
    @NotNull
    protected ConnectingToSshServerForm getForm() {
        return this.form;
    }

    @Override
    @NotNull
    protected Thread getConnectionThread() {
        return this.connectionThread;
    }

    public ConnectingToDeploymentServerState(@NotNull WebServerConfig webServerConfig, final @NotNull InternalStateListener listener, final @NotNull ModalityState modalityState, final @NotNull CreateSshInterpreterWizardState previousState, @Nullable Project project, @NotNull List<? extends Sdk> existingSdks) {
        Intrinsics.checkParameterIsNotNull((Object)webServerConfig, (String)"webServerConfig");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)modalityState, (String)"modalityState");
        Intrinsics.checkParameterIsNotNull((Object)previousState, (String)"previousState");
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        super(listener, previousState);
        this.webServerConfig = webServerConfig;
        this.project = project;
        this.existingSdks = existingSdks;
        RemoteCredentials remoteCredentials = RemoteSdkCredentialsProducerImpl.getCredentialsBySftpServerId(null, (String)this.webServerConfig.getId());
        if (remoteCredentials == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.credentials = remoteCredentials;
        this.form = new ConnectingToSshServerForm(this.credentials.getUserName(), this.credentials.getHost(), this.credentials.getPort());
        this.connectionThread = new Thread(new Runnable(){

            @Override
            public final void run() {
                try {
                    ConnectionBuilder builder = RemoteCredentialsUtil.connectionBuilder$default((RemoteCredentials)credentials, null, null, (int)3, null);
                    final SshSession sshSession = builder.connect();
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public final void run() {
                            if (!this.getPreviousHit()) {
                                WebServerConfig webServerConfig = webServerConfig;
                                CreateSshInterpreterWizardState createSshInterpreterWizardState = previousState;
                                listener.onStateChanged(new FinishExistingServerConfigurationState(this.getUsername(), this.getHost(), this.getPort(), listener, sshSession, project, existingSdks, webServerConfig, createSshInterpreterWizardState));
                            }
                        }
                    }, modalityState);
                }
                catch (Exception e) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public final void run() {
                            if (!this.getPreviousHit()) {
                                InternalStateListener internalStateListener2 = listener;
                                String string = this.getUsername();
                                String string2 = this.getHost();
                                int n = this.getPort();
                                InternalStateListener internalStateListener3 = listener;
                                CreateSshInterpreterWizardState createSshInterpreterWizardState = previousState;
                                Throwable throwable = e.getCause();
                                if (throwable == null) {
                                    throwable = e;
                                }
                                String string3 = throwable.getLocalizedMessage();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(e.cause ?: e).localizedMessage");
                                internalStateListener2.onStateChanged(new SshConnectionFailureState(string, string2, n, internalStateListener3, createSshInterpreterWizardState, string3));
                            }
                        }
                    }, modalityState);
                }
            }
        });
        this.getConnectionThread().start();
    }
}

