/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote.console;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.Tunnelable;
import com.jetbrains.python.console.PydevConsoleRunnerImpl;
import com.jetbrains.python.console.PydevRemoteConsoleCommunication;
import com.jetbrains.python.console.PythonConsoleRemoteProcessCreator;
import com.jetbrains.python.console.RemoteConsoleProcessData;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteProcessHandler;
import com.jetbrains.python.remote.PyRemoteProcessHandlerBase;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PySshRemoteProcessStarterManager;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.run.PyRemoteProcessStarterManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005JM\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/python/remote/console/PythonConsoleSshProcessCreatorBase;", "T", "Lcom/jetbrains/python/console/PythonConsoleRemoteProcessCreator;", "credentialsType", "Lcom/intellij/remote/CredentialsType;", "(Lcom/intellij/remote/CredentialsType;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getCredentialsType", "()Lcom/intellij/remote/CredentialsType;", "createRemoteConsoleProcess", "Lcom/jetbrains/python/console/RemoteConsoleProcessData;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "pathMapper", "Lcom/jetbrains/python/remote/PyRemotePathMapper;", "project", "Lcom/intellij/openapi/project/Project;", "data", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;", "runnerFileFromHelpers", "", "credentials", "scriptPort", "", "idePort", "(Lcom/intellij/execution/configurations/GeneralCommandLine;Lcom/jetbrains/python/remote/PyRemotePathMapper;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;Ljava/lang/String;Ljava/lang/Object;II)Lcom/jetbrains/python/console/RemoteConsoleProcessData;", "intellij.python.remoteInterpreter"})
public abstract class PythonConsoleSshProcessCreatorBase<T>
implements PythonConsoleRemoteProcessCreator<T> {
    private final Logger LOG;
    @NotNull
    private final CredentialsType<T> credentialsType;

    @NotNull
    public RemoteConsoleProcessData createRemoteConsoleProcess(@NotNull GeneralCommandLine commandLine, @NotNull PyRemotePathMapper pathMapper, @NotNull Project project, @NotNull PyRemoteSdkAdditionalDataBase data, @NotNull String runnerFileFromHelpers, T credentials, int scriptPort, int idePort) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        Intrinsics.checkParameterIsNotNull((Object)pathMapper, (String)"pathMapper");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)runnerFileFromHelpers, (String)"runnerFileFromHelpers");
        PythonRemoteInterpreterManager pythonRemoteInterpreterManager = PythonRemoteInterpreterManager.getInstance();
        if (pythonRemoteInterpreterManager == null) {
            throw (Throwable)new PythonRemoteInterpreterManager.PyRemoteInterpreterExecutionException();
        }
        PythonRemoteInterpreterManager manager = pythonRemoteInterpreterManager;
        ParamsGroup scriptParams = commandLine.getParametersList().getParamsGroup("Script");
        if (scriptParams != null) {
            scriptParams.getParametersList().set(1, "0");
            scriptParams.getParametersList().set(2, "0");
        }
        try {
            PydevRemoteConsoleCommunication remoteConsoleCommunication;
            PyRemoteProcessHandler processHandler;
            PySshRemoteProcessStarterManager pySshRemoteProcessStarterManager = (PySshRemoteProcessStarterManager)PyRemoteProcessStarterManager.EP_NAME.findExtension(PySshRemoteProcessStarterManager.class);
            if (pySshRemoteProcessStarterManager == null) {
                throw (Throwable)new RuntimeException("" + PySshRemoteProcessStarterManager.class + " not found");
            }
            PySshRemoteProcessStarterManager processStarterManager = pySshRemoteProcessStarterManager;
            PyRemoteProcessHandler pyRemoteProcessHandler = processHandler = processStarterManager.startRemoteProcess(project, commandLine, manager, data, pathMapper);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pyRemoteProcessHandler), (String)"processHandler");
            RemoteProcess remoteProcess = (RemoteProcess)pyRemoteProcessHandler.getProcess();
            Couple remotePorts = PydevConsoleRunnerImpl.getRemotePortsFromProcess((Process)((Process)remoteProcess));
            if (remoteProcess instanceof Tunnelable) {
                Tunnelable tunnelable = (Tunnelable)remoteProcess;
                Object object = remotePorts.first;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"remotePorts.first");
                tunnelable.addLocalTunnel(scriptPort, ((Number)object).intValue());
                Tunnelable tunnelable2 = (Tunnelable)remoteProcess;
                Object object2 = remotePorts.second;
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"remotePorts.second");
                tunnelable2.addRemoteTunnel(((Number)object2).intValue(), "localhost", idePort);
                Logger logger = this.LOG;
                Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
                if (logger.isDebugEnabled()) {
                    this.LOG.debug("Using tunneled communication for Python console: port " + idePort + " (=> " + (Integer)remotePorts.second + ") on IDE side," + " port " + scriptPort + " (=> " + (Integer)remotePorts.first + ") on pydevconsole.py side");
                }
                remoteConsoleCommunication = new PydevRemoteConsoleCommunication(project, scriptPort, (Process)remoteProcess, idePort);
            } else {
                Logger logger = this.LOG;
                Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
                if (logger.isDebugEnabled()) {
                    this.LOG.debug("Using direct communication for Python console: port " + (Integer)remotePorts.second + " on IDE side," + " port " + (Integer)remotePorts.first + " on pydevconsole.py side");
                }
                Object object = remotePorts.first;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"remotePorts.first");
                int n = ((Number)object).intValue();
                Process process = (Process)remoteProcess;
                Object object3 = remotePorts.second;
                Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"remotePorts.second");
                remoteConsoleCommunication = new PydevRemoteConsoleCommunication(project, n, process, ((Number)object3).intValue());
            }
            return new RemoteConsoleProcessData((PyRemoteProcessHandlerBase)processHandler, remoteConsoleCommunication);
        }
        catch (Exception e) {
            throw (Throwable)new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    @NotNull
    public CredentialsType<T> getCredentialsType() {
        return this.credentialsType;
    }

    public PythonConsoleSshProcessCreatorBase(@NotNull CredentialsType<T> credentialsType) {
        Intrinsics.checkParameterIsNotNull(credentialsType, (String)"credentialsType");
        this.credentialsType = credentialsType;
        this.LOG = Logger.getInstance(this.getClass());
    }
}

