/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote.console;

import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteConnectionType;
import com.intellij.remote.RemoteConnector;
import com.intellij.remote.RemoteCredentials;
import com.intellij.util.Consumer;
import com.jetbrains.plugins.remotesdk.SshConnectionProvider;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.remote.console.PyRemoteSdkConnector;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRemoteSdkConnectionProvider
implements SshConnectionProvider {
    @NotNull
    public Collection<? extends RemoteConnector> collectRemoteConnectors() {
        List<RemoteConnector> list = PyRemoteSdkConnectionProvider.collectRemoteInterpreters();
        if (list == null) {
            PyRemoteSdkConnectionProvider.$$$reportNull$$$0(0);
        }
        return list;
    }

    private static List<RemoteConnector> collectRemoteInterpreters() {
        ArrayList result = Lists.newArrayList();
        for (Sdk sdk : PythonSdkType.getAllSdks()) {
            if (!PySdkUtil.isRemote((Sdk)sdk)) continue;
            result.add(new RemoteInterpreterConnector(sdk));
        }
        return result;
    }

    @Nullable
    public RemoteConnector getRemoteConnector(RemoteConnectionType type, @Nullable String id, Project project, Module module) {
        if (type == RemoteConnectionType.DEFAULT_SDK) {
            SdkAdditionalData data = PyRemoteSdkConnectionProvider.getCurrentSdkAdditionalData(project, module);
            if (data != null) {
                if (data instanceof PyRemoteSdkAdditionalData) {
                    return new PyRemoteSdkConnector((PyRemoteSdkAdditionalData)data);
                }
                Messages.showWarningDialog((Project)project, (String)"Current project interpreter is not remote", (String)"No Host To Connect");
            }
        } else if (type == RemoteConnectionType.REMOTE_SDK) {
            for (Sdk sdk : PythonSdkType.getAllSdks()) {
                if (!PySdkUtil.isRemote((Sdk)sdk) || !StringUtil.equals((CharSequence)id, (CharSequence)PyRemoteSdkConnectionProvider.getId((PyRemoteSdkAdditionalData)sdk.getSdkAdditionalData()))) continue;
                return new RemoteInterpreterConnector(sdk);
            }
        }
        return null;
    }

    @Nullable
    public String getSettingCreationDescription() {
        return "add Python remote interpreter";
    }

    @Nls
    @NotNull
    public String getRadioButtonDescription() {
        if ("Default Remote Interpreter" == null) {
            PyRemoteSdkConnectionProvider.$$$reportNull$$$0(1);
        }
        return "Default Remote Interpreter";
    }

    @NotNull
    public RemoteConnectionType getTypeForConfigurable() {
        RemoteConnectionType remoteConnectionType = RemoteConnectionType.DEFAULT_SDK;
        if (remoteConnectionType == null) {
            PyRemoteSdkConnectionProvider.$$$reportNull$$$0(2);
        }
        return remoteConnectionType;
    }

    private static String getId(PyRemoteSdkAdditionalData data) {
        return data.getSdkId();
    }

    @Nullable
    private static SdkAdditionalData getCurrentSdkAdditionalData(Project project, Module contextModule) {
        Pair<Sdk, Module> sdkAndModule = PyRemoteSdkConnectionProvider.findCurrentSdk(project, contextModule);
        Sdk sdk = (Sdk)sdkAndModule.first;
        if (sdk != null) {
            return sdk.getSdkAdditionalData();
        }
        return null;
    }

    @NotNull
    private static Pair<Sdk, Module> findCurrentSdk(@NotNull Project project, @Nullable Module contextModule) {
        if (project == null) {
            PyRemoteSdkConnectionProvider.$$$reportNull$$$0(3);
        }
        Sdk sdk = null;
        Module module = null;
        if (contextModule != null) {
            module = contextModule;
            sdk = PythonSdkType.findPythonSdk((Module)module);
        }
        if (sdk == null) {
            for (Module m : ModuleManager.getInstance((Project)project).getModules()) {
                if (PythonSdkType.findPythonSdk((Module)m) == null || (sdk = PythonSdkType.findPythonSdk((Module)m)) == null) continue;
                module = m;
                break;
            }
        }
        Pair pair = Pair.create((Object)sdk, (Object)module);
        if (pair == null) {
            PyRemoteSdkConnectionProvider.$$$reportNull$$$0(4);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/console/PyRemoteSdkConnectionProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRemoteConnectors";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRadioButtonDescription";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeForConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/console/PyRemoteSdkConnectionProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findCurrentSdk";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findCurrentSdk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RemoteInterpreterConnector
    implements RemoteConnector {
        private final PyRemoteSdkAdditionalData myRemoteData;
        private final Sdk mySdk;

        public RemoteInterpreterConnector(Sdk sdk) {
            this.mySdk = sdk;
            this.myRemoteData = (PyRemoteSdkAdditionalData)sdk.getSdkAdditionalData();
        }

        public String getId() {
            return PyRemoteSdkConnectionProvider.getId(this.myRemoteData);
        }

        @NotNull
        public String getName() {
            String string = this.mySdk.getName();
            if (string == null) {
                RemoteInterpreterConnector.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public RemoteConnectionType getType() {
            RemoteConnectionType remoteConnectionType = RemoteConnectionType.REMOTE_SDK;
            if (remoteConnectionType == null) {
                RemoteInterpreterConnector.$$$reportNull$$$0(1);
            }
            return remoteConnectionType;
        }

        public void produceRemoteCredentials(Consumer<RemoteCredentials> consumer) {
            this.myRemoteData.produceRemoteSdkCredentials(credentials -> consumer.consume(credentials));
        }

        @NotNull
        public Object getConnectorKey() {
            Object object = this.myRemoteData.getRemoteSdkDataKey();
            if (object == null) {
                RemoteInterpreterConnector.$$$reportNull$$$0(2);
            }
            return object;
        }

        public String toString() {
            return this.getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/python/remote/console/PyRemoteSdkConnectionProvider$RemoteInterpreterConnector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConnectorKey";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

