/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote.console;

import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import com.intellij.execution.KillableProcess;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.Tunnelable;
import com.intellij.util.PathMapper;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.console.PyConsoleProcessHandler;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyPositionConverter;
import com.jetbrains.python.debugger.remote.vfs.PyRemotePositionConverter;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import com.jetbrains.python.remote.RemoteDebuggableProcessHandler;
import java.nio.charset.Charset;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRemoteConsoleProcessHandler
extends PyConsoleProcessHandler
implements RemoteDebuggableProcessHandler,
KillableProcess {
    private static final Logger LOG = Logger.getInstance((String)PyRemoteConsoleProcessHandler.class.getName());
    private final PydevConsoleCommunication myConsoleCommunication;
    @NotNull
    private final PyRemotePathMapper myPathMapper;
    private final List<PathMappingSettings.PathMapping> myFileMappings;
    private final PyRemoteSocketToLocalHostProvider myRemoteSocketProvider;

    public PyRemoteConsoleProcessHandler(@NotNull Process process, PythonConsoleView consoleView, PydevConsoleCommunication pydevConsoleCommunication, @NotNull String commandLine, @Nullable Charset charset, PyRemotePathMapper pathMapper, PyRemoteSocketToLocalHostProvider remoteSocketProvider) {
        if (process == null) {
            PyRemoteConsoleProcessHandler.$$$reportNull$$$0(0);
        }
        if (commandLine == null) {
            PyRemoteConsoleProcessHandler.$$$reportNull$$$0(1);
        }
        super(process, consoleView, pydevConsoleCommunication, commandLine, charset);
        this.myFileMappings = Lists.newArrayList();
        this.myConsoleCommunication = pydevConsoleCommunication;
        this.myPathMapper = pathMapper != null ? pathMapper : new PyRemotePathMapper();
        this.myRemoteSocketProvider = remoteSocketProvider;
    }

    @NotNull
    public PathMapper getMappingSettings() {
        PyRemotePathMapper pyRemotePathMapper = this.myPathMapper;
        if (pyRemotePathMapper == null) {
            PyRemoteConsoleProcessHandler.$$$reportNull$$$0(2);
        }
        return pyRemotePathMapper;
    }

    @Deprecated
    public void addRemoteForwarding(int remotePort, int localPort) {
        try {
            Process process = this.getProcess();
            if (process instanceof Tunnelable) {
                ((Tunnelable)process).addRemoteTunnel(remotePort, "localhost", localPort);
            }
        }
        catch (RemoteSdkException e) {
            throw new RuntimeException(e);
        }
    }

    public Pair<String, Integer> getRemoteSocket(int localPort) throws RemoteSdkException {
        return this.myRemoteSocketProvider.getRemoteSocket(localPort);
    }

    @Nullable
    public HostAndPort getLocalTunnel(int remotePort) {
        Process process = this.getProcess();
        if (process instanceof RemoteProcess) {
            return ((RemoteProcess)process).getLocalTunnel(remotePort);
        }
        return null;
    }

    public boolean canKillProcess() {
        return true;
    }

    public void killProcess() {
        this.myConsoleCommunication.close();
    }

    public List<PathMappingSettings.PathMapping> getFileMappings() {
        return this.myFileMappings;
    }

    public PyPositionConverter createPositionConverter(PyDebugProcess debugProcess) {
        return new PyRemotePositionConverter(debugProcess, this.myPathMapper);
    }

    public PyRemoteSocketToLocalHostProvider getRemoteSocketToLocalHostProvider() {
        return this.myRemoteSocketProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/console/PyRemoteConsoleProcessHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/console/PyRemoteConsoleProcessHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

