/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.VagrantBasedCredentialsHolder;
import com.intellij.remote.VagrantSupport;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.plugins.remotesdk.CredentialsDeployable;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.python.remote.PyRemoteSdkCredentials;
import com.jetbrains.python.remote.PyRemoteSdkCredentialsHolder;
import com.jetbrains.python.remote.PyServerBasedRemoteProjectSynchronizer;
import com.jetbrains.python.remote.PySyncCheckCreateIfPossible;
import com.jetbrains.python.remote.PySyncCheckOnly;
import com.jetbrains.python.remote.PySyncCheckStrategy;
import com.jetbrains.python.remote.PySyncDirection;
import java.io.File;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PyVagrantProjectSynchronizer
extends PyServerBasedRemoteProjectSynchronizer {
    PyVagrantProjectSynchronizer(@NotNull Sdk sdk) {
        if (sdk == null) {
            PyVagrantProjectSynchronizer.$$$reportNull$$$0(0);
        }
        super(sdk);
    }

    @Nullable
    public String checkSynchronizationAvailable(@NotNull PySyncCheckStrategy syncCheckStrategy) {
        VagrantSupport vagrantSupport;
        if (syncCheckStrategy == null) {
            PyVagrantProjectSynchronizer.$$$reportNull$$$0(1);
        }
        if ((vagrantSupport = VagrantSupport.getInstance()) == null) {
            return "No vagrant support enabled";
        }
        File projectFolder = PyVagrantProjectSynchronizer.getProjectFolder(syncCheckStrategy);
        String vagrantFolder = this.getVagrantFolder();
        PathMappingSettings vagrantMappings = vagrantSupport.getMappedFolders(vagrantFolder);
        if (vagrantMappings != null && vagrantMappings.getPathMappings().stream().anyMatch(o -> o.canReplaceLocal(projectFolder.getAbsolutePath()))) {
            return null;
        }
        return String.format("Vagrant can't sync project outside of mapped folders. Vagrant folder is '%s' and your project is '%s'.", vagrantFolder, projectFolder);
    }

    @NotNull
    private String getVagrantFolder() {
        String string = ((VagrantBasedCredentialsHolder)this.myAdditionalData.getRemoteSdkDataKey()).getVagrantFolder();
        if (string == null) {
            PyVagrantProjectSynchronizer.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    protected Deployable createDeployable() throws ExecutionException, InterruptedException {
        PyRemoteSdkCredentialsHolder credentials = new PyRemoteSdkCredentialsHolder();
        PyRemoteSdkCredentials currentCredentialsTyped = this.getCredentials();
        credentials.copyFrom((RemoteCredentials)currentCredentialsTyped);
        CredentialsDeployable deployable = new CredentialsDeployable((RemoteCredentials)credentials);
        deployable.setId("PyVagrantProjectSynchronizer" + deployable.toString());
        deployable.setName(RemoteCredentialsHolder.getCredentialsString((RemoteCredentials)credentials));
        deployable.setIsProjectLevel(true);
        CredentialsDeployable credentialsDeployable = deployable;
        if (credentialsDeployable == null) {
            PyVagrantProjectSynchronizer.$$$reportNull$$$0(3);
        }
        return credentialsDeployable;
    }

    @Override
    @Nullable
    protected List<PathMappingSettings.PathMapping> getPathMappings(@NotNull Project project) {
        VagrantSupport vagrantSupport;
        if (project == null) {
            PyVagrantProjectSynchronizer.$$$reportNull$$$0(4);
        }
        if ((vagrantSupport = VagrantSupport.getInstance()) == null) {
            return null;
        }
        PathMappingSettings mappedFolders = vagrantSupport.getMappedFolders(this.getVagrantFolder());
        if (mappedFolders == null) {
            return null;
        }
        return mappedFolders.getPathMappings();
    }

    @NotNull
    private static File getProjectFolder(@NotNull PySyncCheckStrategy syncCheckStrategy) {
        if (syncCheckStrategy == null) {
            PyVagrantProjectSynchronizer.$$$reportNull$$$0(5);
        }
        if (syncCheckStrategy instanceof PySyncCheckOnly) {
            File file = ((PySyncCheckOnly)syncCheckStrategy).getProjectBaseDir();
            if (file == null) {
                PyVagrantProjectSynchronizer.$$$reportNull$$$0(6);
            }
            return file;
        }
        PySyncCheckCreateIfPossible strategy = (PySyncCheckCreateIfPossible)syncCheckStrategy;
        String canonicalPath = strategy.getModule().getProject().getBaseDir().getCanonicalPath();
        assert (canonicalPath != null) : "Path can't be null";
        File file = new File(canonicalPath);
        if (file == null) {
            PyVagrantProjectSynchronizer.$$$reportNull$$$0(7);
        }
        return file;
    }

    public void syncProject(@NotNull Module module, @NotNull PySyncDirection syncDirection, @Nullable Consumer<Boolean> callback2, String ... fileNames) {
        if (module == null) {
            PyVagrantProjectSynchronizer.$$$reportNull$$$0(8);
        }
        if (syncDirection == null) {
            PyVagrantProjectSynchronizer.$$$reportNull$$$0(9);
        }
        if (fileNames == null) {
            PyVagrantProjectSynchronizer.$$$reportNull$$$0(10);
        }
        if (callback2 != null) {
            callback2.accept(this.checkSynchronizationAvailable((PySyncCheckStrategy)new PySyncCheckCreateIfPossible(module, null)) == null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncCheckStrategy";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/PyVagrantProjectSynchronizer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncDirection";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/PyVagrantProjectSynchronizer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVagrantFolder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDeployable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectFolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkSynchronizationAvailable";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPathMappings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getProjectFolder";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "syncProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

