/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.openapi.util.Pair;
import com.intellij.remote.RemoteFile;
import com.intellij.remote.RemoteSdkException;
import com.intellij.util.PathMapper;
import com.jetbrains.python.debugger.PyDebugRunner;
import com.jetbrains.python.remote.PyCommandLineStateUtil;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkCredentials;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySshCommandLineStateUtil {
    private PySshCommandLineStateUtil() {
    }

    public static void patchDebugParams(@NotNull String helpersPath, @NotNull PyRemoteSocketToLocalHostProvider remoteSocketProvider, @NotNull ParamsGroup debugParams) throws RemoteSdkException {
        if (helpersPath == null) {
            PySshCommandLineStateUtil.$$$reportNull$$$0(0);
        }
        if (remoteSocketProvider == null) {
            PySshCommandLineStateUtil.$$$reportNull$$$0(1);
        }
        if (debugParams == null) {
            PySshCommandLineStateUtil.$$$reportNull$$$0(2);
        }
        debugParams.getParametersList().set(0, new RemoteFile(helpersPath, "pydev/pydevd.py").getPath());
        Pair socket = remoteSocketProvider.getRemoteSocket(Integer.parseInt(debugParams.getParametersList().get(PyDebugRunner.findIndex((List)debugParams.getParameters(), (String)"--port"))));
        int clientParamIndex = PyDebugRunner.findIndex((List)debugParams.getParameters(), (String)"--client");
        if (clientParamIndex != -1) {
            debugParams.getParametersList().set(clientParamIndex, (String)socket.getFirst());
        }
        debugParams.getParametersList().set(PyDebugRunner.findIndex((List)debugParams.getParameters(), (String)"--port"), Integer.toString((Integer)socket.getSecond()));
    }

    public static void patchProfileParams(@NotNull String interpreterPath, @NotNull PyRemoteSocketToLocalHostProvider remoteSocketProvider, @NotNull ParamsGroup profileParams, @Nullable File workDirectory, @NotNull PathMapper pathMapper) throws RemoteSdkException {
        if (interpreterPath == null) {
            PySshCommandLineStateUtil.$$$reportNull$$$0(3);
        }
        if (remoteSocketProvider == null) {
            PySshCommandLineStateUtil.$$$reportNull$$$0(4);
        }
        if (profileParams == null) {
            PySshCommandLineStateUtil.$$$reportNull$$$0(5);
        }
        if (pathMapper == null) {
            PySshCommandLineStateUtil.$$$reportNull$$$0(6);
        }
        PyCommandLineStateUtil.remapParameters(interpreterPath, pathMapper, profileParams, workDirectory);
        Pair socket = remoteSocketProvider.getRemoteSocket(Integer.parseInt(profileParams.getParametersList().get(2)));
        profileParams.getParametersList().set(1, (String)socket.getFirst());
        profileParams.getParametersList().set(2, Integer.toString((Integer)socket.getSecond()));
    }

    public static void patchCoverageParams(@NotNull String interpreterPath, @NotNull ParamsGroup coverageParams, @Nullable File workDirectory, @NotNull PathMapper pathMapper) throws RemoteSdkException {
        if (interpreterPath == null) {
            PySshCommandLineStateUtil.$$$reportNull$$$0(7);
        }
        if (coverageParams == null) {
            PySshCommandLineStateUtil.$$$reportNull$$$0(8);
        }
        if (pathMapper == null) {
            PySshCommandLineStateUtil.$$$reportNull$$$0(9);
        }
        PyCommandLineStateUtil.remapParameters(interpreterPath, pathMapper, coverageParams, workDirectory);
        int i = 0;
        for (String param : coverageParams.getParameters()) {
            String omitPrefix;
            if (param.startsWith(omitPrefix = "--omit=")) {
                String path = param.substring(omitPrefix.length());
                coverageParams.getParametersList().set(i, omitPrefix + RemoteFile.detectSystemByPath((String)interpreterPath).createRemoteFile(pathMapper.convertToRemote(path)).getPath());
            }
            ++i;
        }
    }

    public static void patchCommandLineForSshSession(@NotNull GeneralCommandLine commandLine, @NotNull PyRemoteSdkCredentials data, @NotNull PyRemotePathMapper pathMapper, @NotNull PyRemoteSocketToLocalHostProvider sshRemoteSocketProvider) throws RemoteSdkException {
        ParamsGroup coverageParams;
        ParamsGroup profileParams;
        ParamsGroup debugParams;
        ParamsGroup exeGroup;
        if (commandLine == null) {
            PySshCommandLineStateUtil.$$$reportNull$$$0(10);
        }
        if (data == null) {
            PySshCommandLineStateUtil.$$$reportNull$$$0(11);
        }
        if (pathMapper == null) {
            PySshCommandLineStateUtil.$$$reportNull$$$0(12);
        }
        if (sshRemoteSocketProvider == null) {
            PySshCommandLineStateUtil.$$$reportNull$$$0(13);
        }
        if ((exeGroup = commandLine.getParametersList().getParamsGroup("Exe Options")) != null) {
            PythonRemoteInterpreterManager.addUnbuffered((ParamsGroup)exeGroup);
        }
        if ((debugParams = commandLine.getParametersList().getParamsGroup("Debugger")) != null && debugParams.getParameters().size() > 0) {
            PySshCommandLineStateUtil.patchDebugParams(data.getHelpersPath(), sshRemoteSocketProvider, debugParams);
        }
        if ((profileParams = commandLine.getParametersList().getParamsGroup("Profiler")) != null && profileParams.getParameters().size() > 0) {
            PySshCommandLineStateUtil.patchProfileParams(data.getInterpreterPath(), sshRemoteSocketProvider, profileParams, commandLine.getWorkDirectory(), (PathMapper)pathMapper);
        }
        if ((coverageParams = commandLine.getParametersList().getParamsGroup("Coverage")) != null && coverageParams.getParameters().size() > 0) {
            PySshCommandLineStateUtil.patchCoverageParams(data.getInterpreterPath(), coverageParams, commandLine.getWorkDirectory(), (PathMapper)pathMapper);
        }
        PyCommandLineStateUtil.remap(data, commandLine, (PathMapper)pathMapper);
        if (commandLine.getWorkDirectory() != null) {
            commandLine.setWorkDirectory(pathMapper.convertToRemote(commandLine.getWorkDirectory().getPath()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersPath";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteSocketProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugParams";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileParams";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageParams";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sshRemoteSocketProvider";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/remote/PySshCommandLineStateUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "patchDebugParams";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "patchProfileParams";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "patchCoverageParams";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "patchCommandLineForSshSession";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

