/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteFile;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.process.SshExecProcess;
import com.intellij.ssh.process.SshProcess;
import com.intellij.util.AbstractPathMapper;
import com.intellij.util.PathMapper;
import com.jetbrains.plugins.remotesdk.CapturingRemoteProcessHandler;
import com.jetbrains.plugins.remotesdk.RemoteProcessUtil;
import com.jetbrains.plugins.remotesdk.RemoteSdkSessionUtil;
import com.jetbrains.python.remote.PyHelpersUpload;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.sdk.PythonEnvUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRemoteProcessUtil {
    private PyRemoteProcessUtil() {
    }

    public static void uploadAllHelpers(@NotNull RemoteSdkCredentials data, @Nullable Project project) {
        if (data == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(0);
        }
        PyHelpersUpload.uploadAllHelpers(null, project, null, data, false);
    }

    public static void shutDownHelpersService() {
        PyHelpersUpload.shutDownService();
    }

    @NotNull
    public static ProcessOutput getProcessOutput(@Nullable Project project, @NotNull RemoteSdkCredentials data, @NotNull PyRemotePathMapper pathMapper, @NonNls String[] command, @Nullable String workingDir, boolean askForSudo, boolean checkHelpers) throws RemoteSdkException {
        if (data == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(1);
        }
        if (pathMapper == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(2);
        }
        ConnectionBuilder connectionBuilder = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)data, (Project)project);
        if (checkHelpers) {
            PyRemoteProcessUtil.uploadAllHelpers(data, project);
        }
        ProcessOutput processOutput = PyRemoteProcessUtil.getProcessOutput(connectionBuilder, data, pathMapper, command, workingDir, askForSudo);
        if (processOutput == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(3);
        }
        return processOutput;
    }

    public static ConnectionBuilder checkConnectionAndGetSession(@Nullable Project project, RemoteSdkCredentials data, @NotNull Set<String> helpersRoots) throws RemoteSdkException {
        if (helpersRoots == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(4);
        }
        ConnectionBuilder connectionBuilder = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)data, (Project)project);
        RemoteSdkSessionUtil.checkConnection((ConnectionBuilder)connectionBuilder, (Project)project);
        if (!helpersRoots.isEmpty()) {
            PyHelpersUpload.uploadHelpersSync(null, project, data, helpersRoots);
        }
        return connectionBuilder;
    }

    @NotNull
    public static ProcessOutput getProcessOutput(@Nullable Project project, @NotNull RemoteSdkCredentials data, @NotNull PyRemotePathMapper pathMapper, @NonNls String[] command, @Nullable String workingDir, boolean askForSudo, @NotNull Set<String> checkHelpersPaths) throws RemoteSdkException {
        if (data == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(5);
        }
        if (pathMapper == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(6);
        }
        if (checkHelpersPaths == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(7);
        }
        ConnectionBuilder connectionBuilder = PyRemoteProcessUtil.checkConnectionAndGetSession(project, data, checkHelpersPaths);
        ProcessOutput processOutput = PyRemoteProcessUtil.getProcessOutput(connectionBuilder, data, pathMapper, command, workingDir, askForSudo);
        if (processOutput == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(8);
        }
        return processOutput;
    }

    @NotNull
    public static ProcessOutput getProcessOutput(@NotNull ConnectionBuilder connectionBuilder, @NotNull RemoteSdkCredentials data, @NotNull PyRemotePathMapper pathMapper, @NotNull String[] command) throws RemoteSdkException {
        if (connectionBuilder == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(9);
        }
        if (data == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(10);
        }
        if (pathMapper == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(11);
        }
        if (command == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(12);
        }
        ProcessOutput processOutput = PyRemoteProcessUtil.getProcessOutput(connectionBuilder, data, pathMapper, command, null, false);
        if (processOutput == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(13);
        }
        return processOutput;
    }

    @NotNull
    private static ProcessOutput getProcessOutput(@NotNull ConnectionBuilder connectionBuilder, @NotNull RemoteSdkCredentials data, @NotNull PyRemotePathMapper pathMapper, @NotNull String[] command, @Nullable String workingDir, boolean askForSudo) throws RemoteSdkException {
        if (connectionBuilder == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(14);
        }
        if (data == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(15);
        }
        if (pathMapper == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(16);
        }
        if (command == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(17);
        }
        Pair commandWithWorkingDir = RemoteProcessUtil.buildRemoteCommandLine((AbstractPathMapper)pathMapper, (String[])command, (String)workingDir, (String)data.getInterpreterPath());
        GeneralCommandLine commandLine = new GeneralCommandLine((String[])commandWithWorkingDir.first).withWorkDirectory((String)commandWithWorkingDir.second);
        PythonEnvUtil.setPythonUnbuffered((Map)commandLine.getEnvironment());
        SshExecProcess process = RemoteCredentialsUtil.processBuilder((ConnectionBuilder)connectionBuilder, (GeneralCommandLine)commandLine).withSudo(askForSudo).withAllocatePty(false).start();
        CapturingRemoteProcessHandler processHandler = new CapturingRemoteProcessHandler((SshProcess)process, null, commandLine.getCommandLineString());
        ProcessOutput processOutput = processHandler.runProcess();
        if (processOutput == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(18);
        }
        return processOutput;
    }

    @NotNull
    public static String remapStuffPathsList(@NotNull String pathsValue, @NotNull PathMapper pathMapper, @NotNull String interpreterPath) {
        if (pathsValue == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(19);
        }
        if (pathMapper == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(20);
        }
        if (interpreterPath == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(21);
        }
        boolean isWin = RemoteFile.isWindowsPath((String)interpreterPath);
        ArrayList paths = Lists.newArrayList((Object[])pathsValue.split(Pattern.quote("|")));
        ArrayList mappedPaths = Lists.newArrayList();
        for (String path : paths) {
            mappedPaths.add(new RemoteFile(pathMapper.convertToRemote(path), isWin).getPath());
        }
        String string = Joiner.on((char)'|').join((Iterable)mappedPaths);
        if (string == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 18: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 18: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/PyRemoteProcessUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersRoots";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkHelpersPaths";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionBuilder";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathsValue";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/PyRemoteProcessUtil";
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessOutput";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "remapStuffPathsList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "uploadAllHelpers";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 18: 
            case 22: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkConnectionAndGetSession";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "remapStuffPathsList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 18: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

