/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.JdkFutureAdapters;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.ssh.SshSessionKey;
import com.intellij.ssh.SshTransportException;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.RemoteUpload;
import com.jetbrains.plugins.remotesdk.transport.SshConnectionServiceUtil;
import com.jetbrains.plugins.webDeployment.config.ExcludedPath;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.sdk.PythonSdkType;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyHelpersUpload
extends RemoteUpload {
    private static final Logger LOG = Logger.getInstance(PyHelpersUpload.class);
    @Nullable
    private final Sdk mySdk;
    private static final Object myAsyncTransferLock = new Object();
    private static final ConcurrentMap<SshSessionKey, ListenableFuture<?>> myHelpersTransferSessionMap = Maps.newConcurrentMap();
    private static final ListeningExecutorService ourExecutorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("PyCharm Helpers Upload", NotificationDisplayType.BALLOON, true);

    private PyHelpersUpload(@Nullable Sdk sdk, @Nullable Project project, @Nullable Component component, @NotNull RemoteSdkCredentials remoteSdkCredentials, boolean isModal, @NotNull Collection<String> helpersPaths) {
        if (remoteSdkCredentials == null) {
            PyHelpersUpload.$$$reportNull$$$0(0);
        }
        if (helpersPaths == null) {
            PyHelpersUpload.$$$reportNull$$$0(1);
        }
        super(remoteSdkCredentials, project, component, "Uploading PyCharm helpers...", false, isModal, helpersPaths);
        this.mySdk = sdk;
    }

    public static synchronized ListenableFuture<?> uploadAllHelpers(@Nullable Sdk sdk, @Nullable Project project, @Nullable Component component, @NotNull RemoteSdkCredentials credentials, boolean uploadOnSnapshot) {
        if (credentials == null) {
            PyHelpersUpload.$$$reportNull$$$0(2);
        }
        return PyHelpersUpload.uploadHelpers(sdk, project, component, credentials, uploadOnSnapshot, Collections.singleton(PythonHelpersLocator.getHelpersRoot().getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ListenableFuture<?> uploadHelpers(@Nullable Sdk sdk, @Nullable Project project, @Nullable Component component, @NotNull RemoteSdkCredentials credentials, boolean uploadOnSnapshot, @NotNull Collection<String> helperRoots) {
        if (credentials == null) {
            PyHelpersUpload.$$$reportNull$$$0(3);
        }
        if (helperRoots == null) {
            PyHelpersUpload.$$$reportNull$$$0(4);
        }
        Object object = myAsyncTransferLock;
        synchronized (object) {
            SshSessionKey key = SshConnectionServiceUtil.remoteCredentialsToSessionKey((RemoteCredentials)credentials);
            PyHelpersUpload transfer = (PyHelpersUpload)((Object)UIUtil.invokeAndWaitIfNeeded(() -> {
                if (credentials == null) {
                    PyHelpersUpload.$$$reportNull$$$0(11);
                }
                if (helperRoots == null) {
                    PyHelpersUpload.$$$reportNull$$$0(12);
                }
                return new PyHelpersUpload(sdk, project, component, credentials, false, helperRoots);
            }));
            transfer.setUploadOnSnapshot(uploadOnSnapshot);
            Callable<Object> transferTask2 = () -> {
                ListenableFuture f = JdkFutureAdapters.listenInPoolThread((Future)transfer.upload());
                f.addListener(() -> {
                    ListenableFuture cfr_ignored_0 = (ListenableFuture)myHelpersTransferSessionMap.remove(key);
                }, (Executor)ourExecutorService);
                myHelpersTransferSessionMap.put(key, f);
                if (f.isDone()) {
                    myHelpersTransferSessionMap.remove(key);
                }
                return f.get();
            };
            ListenableFuture future = (ListenableFuture)myHelpersTransferSessionMap.get(key);
            if (future != null) {
                return Futures.transform((ListenableFuture)future, input -> {
                    try {
                        return transferTask2.call();
                    }
                    catch (Exception e) {
                        LOG.error("Error from future", (Throwable)e);
                        return false;
                    }
                });
            }
            return ourExecutorService.submit(transferTask2);
        }
    }

    public static void uploadHelpersSync(@Nullable Sdk sdk, @Nullable Project project, @NotNull RemoteSdkCredentials credentials, Set<String> filesToUpload) {
        if (credentials == null) {
            PyHelpersUpload.$$$reportNull$$$0(5);
        }
        PyHelpersUpload transfer = new PyHelpersUpload(sdk, project, null, credentials, true, filesToUpload){

            @Override
            protected boolean helpersArchiveCopyEnabled() {
                return false;
            }
        };
        ImmutableMap map = Maps.toMap(filesToUpload, path -> FileUtil.getRelativePath((File)PythonHelpersLocator.getHelpersRoot(), (File)new File((String)path)));
        transfer.setRelativePathsMap((Map)map);
        ListenableFuture future = JdkFutureAdapters.listenInPoolThread((Future)transfer.upload());
        try {
            future.get();
        }
        catch (Exception e) {
            LOG.error("Helpers upload failed", (Throwable)e);
        }
    }

    protected boolean helpersArchiveCopyEnabled() {
        return true;
    }

    @NotNull
    protected List<ExcludedPath> getExcludedHelpersPaths(@NotNull Collection<String> helpersPaths) {
        if (helpersPaths == null) {
            PyHelpersUpload.$$$reportNull$$$0(6);
        }
        Set<String> pathsToExclude = PyHelpersUpload.getPathsToExclude(this.mySdk);
        ArrayList result = Lists.newArrayList();
        for (String path : helpersPaths) {
            for (String subpath : pathsToExclude) {
                File helper = new File(path, subpath);
                if (!helper.exists()) continue;
                result.add(new ExcludedPath(helper.getPath(), true));
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            PyHelpersUpload.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    private static Set<String> getPathsToExclude(@Nullable Sdk sdk) {
        HashSet pathsToExclude = Sets.newHashSet((Object[])new String[]{"docutils", "epydoc", "process", "pydev/pydevd_attach_to_process", "pydev/test_pydevd_reload", "pydev/tests", "pydev/tests_mainloop", "pydev/tests_python", "pydev/tests_runfiles", "pydev/third_party", "pydev/third_party", "python-skeletons", "tools", "MathJax", "py2only", "py3only", "python-skeletons", "typeshed"});
        if (sdk != null) {
            pathsToExclude.addAll(Lists.newArrayList((Object[])new String[]{"pip-1.1.tar.gz", "setuptools-1.4.2.tar.gz", "virtualenv-1.11.6.tar.gz"}));
            if (PythonSdkType.getLanguageLevelForSdk((Sdk)sdk).isPy3K()) {
                pathsToExclude.add("profiler/thrift");
            } else {
                pathsToExclude.add("profiler/thriftpy3");
            }
        }
        HashSet hashSet = pathsToExclude;
        if (hashSet == null) {
            PyHelpersUpload.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @NotNull
    protected Predicate<String> createFileFilter() {
        Set<String> pathsToExclude = PyHelpersUpload.getPathsToExclude(this.mySdk);
        Predicate predicate = path -> !pathsToExclude.contains(path) && StreamEx.of((Object[])new String[]{".pyc", ".class"}).noneMatch(ext -> path.endsWith((String)ext));
        if (predicate == null) {
            PyHelpersUpload.$$$reportNull$$$0(9);
        }
        return predicate;
    }

    protected void onUploadError(@NotNull SshTransportException e) {
        if (e == null) {
            PyHelpersUpload.$$$reportNull$$$0(10);
        }
        NOTIFICATION_GROUP.createNotification("Couldn't upload helpers for remote interpreter", e.getLocalizedMessage(), NotificationType.WARNING, null).notify(this.getProject());
    }

    public static synchronized void shutDownService() {
        ourExecutorService.shutdownNow();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteSdkCredentials";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersPaths";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helperRoots";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/PyHelpersUpload";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/PyHelpersUpload";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedHelpersPaths";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsToExclude";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "uploadAllHelpers";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "uploadHelpers";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "uploadHelpersSync";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getExcludedHelpersPaths";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onUploadError";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$uploadHelpers$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

