/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sqlalchemy.uml;

import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.ERDiagramModel;
import com.jetbrains.ERDiagramNode;
import com.jetbrains.ERDummyModelInit;
import com.jetbrains.ERUmlRelationships;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.uml.PyUmlEdge;
import com.jetbrains.sqlalchemy.uml.AlchemyUmlDiagramProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class AlchemyDiagramModel
extends ERDiagramModel {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.sqlalchemy.uml.AlchemyDiagramModel");

    public AlchemyDiagramModel(Project project, PyClass element) {
        super(project, element, AlchemyUmlDiagramProvider.getInstance());
        this.init(project, element);
    }

    @Override
    protected void init(Project project, PyClass element) {
        Object dir;
        VirtualFile modelDir;
        if (project == null) {
            return;
        }
        ArrayList<PyFile> models = new ArrayList<PyFile>();
        ArrayList files = new ArrayList();
        if (element instanceof ERDummyModelInit && ((ERDummyModelInit)element).getElement() != null) {
            Collections.addAll(files, ((ERDummyModelInit)element).getElement().getFiles());
        }
        if ((modelDir = PyUtil.findInRoots((Module)ModuleManager.getInstance((Project)project).getModules()[0], (String)"models")) != null && (dir = PsiManager.getInstance((Project)project).findDirectory(modelDir)) != null) {
            Collections.addAll(files, dir.getFiles());
        }
        Collections.addAll(files, FilenameIndex.getFilesByName((Project)project, (String)"models.py", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project)));
        Collections.addAll(files, FilenameIndex.getFilesByName((Project)project, (String)"model.py", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project)));
        if (files.isEmpty()) {
            LOG.info("Failed to find models.py or models directory in SQL Alchemy Project root " + project.getBasePath());
        }
        for (PsiFile file : files) {
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null || !ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(virtualFile) || ProjectRootManager.getInstance((Project)project).getFileIndex().isInLibraryClasses(virtualFile) || !(file instanceof PyFile)) continue;
            models.add((PyFile)file);
        }
        String modelClassName = null;
        block1: for (PyFile file : models) {
            List statements = file.getStatements();
            for (PyStatement statement : statements) {
                PyExpression leftExpression;
                PyExpression callee;
                PyExpression assignedValue;
                if (!(statement instanceof PyAssignmentStatement) || !((assignedValue = ((PyAssignmentStatement)statement).getAssignedValue()) instanceof PyCallExpression) || (callee = ((PyCallExpression)assignedValue).getCallee()) == null || (leftExpression = ((PyAssignmentStatement)statement).getLeftHandSideExpression()) == null) continue;
                if ("declarative_base".equals(callee.getText())) {
                    modelClassName = leftExpression.getText();
                    continue block1;
                }
                if (!"SQLAlchemy".equals(callee.getText())) continue;
                modelClassName = leftExpression.getText() + ".Model";
                continue block1;
            }
        }
        if (modelClassName != null) {
            for (PyFile file : models) {
                List classes = file.getTopLevelClasses();
                for (PyClass pyClass : classes) {
                    PyExpression[] superClassExpressions;
                    for (PyExpression e : superClassExpressions = pyClass.getSuperClassExpressions()) {
                        if (!e.getText().equals(modelClassName)) continue;
                        this.myNodes.add((Object)new ERDiagramNode(pyClass, (DiagramProvider<PyClass>)this.getProvider()));
                    }
                }
            }
        }
    }

    @Override
    protected void calculateRelations() {
        for (DiagramNode fromNode : this.myNodes) {
            PyClass fromClass = (PyClass)fromNode.getIdentifyingElement();
            Map<PyClass, String> res = this.getRelation(fromClass, "ManyToOne");
            this.addEdges((DiagramNode<PyClass>)fromNode, res, "ManyToOne", (DiagramProvider<PyClass>)this.getProvider());
            res = this.getRelation(fromClass, "OneToOne");
            this.addEdges((DiagramNode<PyClass>)fromNode, res, "OneToOne", (DiagramProvider<PyClass>)this.getProvider());
            res = this.getRelation(fromClass, "ManyToMany");
            this.addEdges((DiagramNode<PyClass>)fromNode, res, "ManyToMany", (DiagramProvider<PyClass>)this.getProvider());
        }
    }

    public Map<PyClass, String> getRelation(@NotNull PyClass pyClass, @NotNull String type) {
        if (pyClass == null) {
            AlchemyDiagramModel.$$$reportNull$$$0(0);
        }
        if (type == null) {
            AlchemyDiagramModel.$$$reportNull$$$0(1);
        }
        HashMap result = new HashMap();
        List classAttributes = pyClass.getClassAttributes();
        for (PyTargetExpression expression : classAttributes) {
            PyClass aClass;
            PyExpression callee;
            QualifiedName calleeQName = expression.getCalleeName();
            if (calleeQName == null || !"relationship".equals(calleeQName.getLastComponent()) && !"relation".equals(calleeQName.getLastComponent())) continue;
            PyCallExpression initCall = (PyCallExpression)expression.findAssignedValue();
            assert (initCall != null);
            PyStringLiteralExpression toClass = (PyStringLiteralExpression)initCall.getArgument(0, "argument", PyStringLiteralExpression.class);
            PyExpression[] arguments = initCall.getArguments();
            boolean uselist = true;
            PyExpression backref = null;
            PyExpression secondary = initCall.getKeywordArgument("secondary");
            String through = secondary == null ? "" : secondary.getText();
            for (PyExpression argument : arguments) {
                String keyword;
                if (!(argument instanceof PyKeywordArgument) || (keyword = ((PyKeywordArgument)argument).getKeyword()) == null) continue;
                PyExpression valueExpression = ((PyKeywordArgument)argument).getValueExpression();
                if (keyword.equals("uselist") && valueExpression != null && "False".equals(valueExpression.getText())) {
                    uselist = false;
                }
                if (!keyword.equals("backref")) continue;
                backref = valueExpression;
            }
            if (uselist && backref != null && backref instanceof PyCallExpression && (callee = ((PyCallExpression)backref).getCallee()) != null && "backref".equals(callee.getText())) {
                PyExpression[] backRefArguments;
                for (PyExpression argument : backRefArguments = ((PyCallExpression)backref).getArguments()) {
                    if (!(argument instanceof PyKeywordArgument)) continue;
                    PyExpression valueExpression = ((PyKeywordArgument)argument).getValueExpression();
                    if (!"uselist".equals(((PyKeywordArgument)argument).getKeyword()) || valueExpression == null || !"False".equals(valueExpression.getText())) continue;
                    uselist = false;
                }
            }
            if (!(type.equals("ManyToOne") && uselist && secondary == null || type.equals("OneToOne") && !uselist && secondary == null) && (!type.equals("ManyToMany") || secondary == null) || toClass == null) continue;
            String fkModelName = toClass.getStringValue();
            QualifiedName name = QualifiedName.fromDottedString((String)fkModelName);
            PsiFile file = null;
            if (name.getComponentCount() == 1) {
                file = pyClass.getContainingFile();
            } else {
                PsiDirectory application;
                fkModelName = name.getLastComponent();
                List components = name.getComponents();
                String applicationName = (String)components.get(0);
                PsiDirectory projectRoot = DjangoUtil.getProjectRoot((PsiElement)pyClass);
                if (projectRoot != null && (application = projectRoot.findSubdirectory(applicationName)) != null) {
                    file = application.findFile("models.py");
                }
            }
            if (!(file instanceof PyFile) || (aClass = ((PyFile)file).findTopLevelClass(fkModelName)) == null) continue;
            result.put(aClass, through);
        }
        return result;
    }

    @Override
    protected void addEdges(@NotNull DiagramNode<PyClass> fromNode, @NotNull Map<PyClass, String> res, @NotNull String relation, DiagramProvider<PyClass> provider) {
        if (fromNode == null) {
            AlchemyDiagramModel.$$$reportNull$$$0(2);
        }
        if (res == null) {
            AlchemyDiagramModel.$$$reportNull$$$0(3);
        }
        if (relation == null) {
            AlchemyDiagramModel.$$$reportNull$$$0(4);
        }
        for (Map.Entry<PyClass, String> pyClass : res.entrySet()) {
            String label;
            PyUmlEdge edge;
            Object toNode = this.findNode(pyClass.getKey());
            if (toNode == null) {
                toNode = new ERDiagramNode(pyClass.getKey(), provider);
                this.myNodes.add(toNode);
            }
            if (this.myEdges.contains((Object)(edge = new PyUmlEdge(fromNode, (DiagramNode<PyClass>)toNode, (DiagramRelationshipInfo)new ERUmlRelationships(relation, label = pyClass.getValue(), DiagramRelationshipInfo.NONE, DiagramRelationshipInfo.NONE))))) continue;
            this.myEdges.add(edge);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relation";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/sqlalchemy/uml/AlchemyDiagramModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getRelation";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addEdges";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

