/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.uml;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.QualifiedName;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.python.codeInsight.stdlib.PyStdlibCanonicalPathProvider;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.uml.PyDummyFileClass;
import com.jetbrains.python.uml.PyDummyPackageClass;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.Nullable;

public class PyUmlElementManager
extends AbstractDiagramElementManager<PyClass> {
    public PyClass findInDataContext(DataContext context) {
        return PyUmlElementManager.findElementInContext(context);
    }

    public static PyClass findElementInContext(DataContext context) {
        PyClass umlElement = null;
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project == null) {
            return null;
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        if (element instanceof PyClass) {
            umlElement = (PyClass)element;
        } else if (element instanceof PyFile) {
            umlElement = new PyDummyFileClass(((PyFile)element).getName(), project, (PyFile)element);
        } else if (element instanceof PsiDirectory && ((PsiDirectory)element).findFile("__init__.py") != null) {
            umlElement = new PyDummyPackageClass(project, (PsiDirectory)element);
        } else {
            PsiFile psiFile;
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
            PsiFile psiFile2 = psiFile = element instanceof PsiFile ? (PsiFile)element : (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
            if (psiFile != null && editor != null) {
                PsiElement psiElement = PsiUtilCore.getElementAtOffset((PsiFile)psiFile, (int)editor.getCaretModel().getOffset());
                PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyClass.class);
                if (parent != null) {
                    umlElement = (PyClass)parent;
                } else {
                    PsiFile file = psiElement.getContainingFile();
                    if (file instanceof PyFile) {
                        umlElement = new PyDummyFileClass(file.getName(), project, (PyFile)file);
                    }
                }
            }
        }
        return umlElement;
    }

    public Object[] getNodeItems(PyClass aClass) {
        ArrayList elements = new ArrayList();
        Collections.addAll(elements, aClass.getMethods());
        Collections.addAll(elements, aClass.getNestedClasses());
        elements.addAll(aClass.getInstanceAttributes());
        elements.addAll(aClass.getClassAttributes());
        return elements.isEmpty() ? PsiElement.EMPTY_ARRAY : elements.toArray();
    }

    public boolean isAcceptableAsNode(Object element) {
        return element instanceof PyClass;
    }

    public String getElementTitle(PyClass element) {
        QualifiedName name;
        String qualifiedName = element.getQualifiedName();
        if (qualifiedName != null && (name = PyStdlibCanonicalPathProvider.restoreStdlibCanonicalPath((QualifiedName)QualifiedName.fromDottedString((String)qualifiedName))) != null) {
            qualifiedName = name.toString();
        }
        return qualifiedName;
    }

    public SimpleColoredText getItemName(Object element, DiagramState presentation) {
        String text = "";
        if (element instanceof PyClass) {
            PyClass parentClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)((PyClass)element), PyClass.class);
            while (parentClass != null) {
                text = text + parentClass.getName() + ".";
                parentClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)parentClass, PyClass.class);
            }
            text = text + ((PyClass)element).getName();
        } else if (element instanceof PyFunction) {
            text = text + ((PyFunction)element).getName() + ((PyFunction)element).getParameterList().getText();
        } else if (element instanceof PyTargetExpression) {
            text = text + ((PyTargetExpression)element).getName();
        }
        return new SimpleColoredText(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    @Nullable
    public String getNodeTooltip(PyClass element) {
        return null;
    }
}

