/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.uml;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.hash.HashSet;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.uml.PyDiagramNode;
import com.jetbrains.python.uml.PyDiagramProvider;
import com.jetbrains.python.uml.PyDummyFileClass;
import com.jetbrains.python.uml.PyDummyPackageClass;
import com.jetbrains.python.uml.PyUmlEdge;
import com.jetbrains.python.uml.PyUmlRelationships;
import com.jetbrains.python.uml.PythonDummyClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDiagramModel
extends DiagramDataModel<PyClass> {
    private final HashSet<DiagramNode<PyClass>> myNodes = new HashSet();
    private final Collection<DiagramEdge<PyClass>> myEdges = new HashSet();
    private PyClass myObjectClass;
    private PyFile myCollectionsFile = null;
    private final Set<String> myNames = new HashSet();

    public PyDiagramModel(Project project, @Nullable PyClass element) {
        super(project, PyDiagramProvider.getInstance());
        if (element != null) {
            List items = ResolveImportUtil.resolveModule((QualifiedName)QualifiedName.fromDottedString((String)"collections"), (PsiFile)element.getContainingFile(), (boolean)false, (int)0);
            for (PsiElement item : items) {
                if (item instanceof PyFile) {
                    this.myCollectionsFile = (PyFile)item;
                    break;
                }
                if (!(item instanceof PsiDirectory)) continue;
                this.myCollectionsFile = (PyFile)((PsiDirectory)item).findFile("__init__.py");
                break;
            }
        }
        this.myNodes.clear();
        this.myEdges.clear();
        this.myNames.clear();
        PyPsiUtils.assertValid((PsiElement)element);
        if (element != null && element.isValid()) {
            if (element instanceof PyDummyFileClass || element instanceof PyDummyPackageClass) {
                for (PyClass cl : element.getNestedClasses()) {
                    this.init(cl);
                }
            } else {
                this.init(element);
            }
        }
    }

    @Nullable
    private static PyClass getMetaClass(@NotNull PyClass cls) {
        PyType type;
        if (cls == null) {
            PyDiagramModel.$$$reportNull$$$0(0);
        }
        if ((type = cls.getMetaClassType(TypeEvalContext.userInitiated((Project)cls.getProject(), null))) instanceof PyClassType) {
            return ((PyClassType)type).getPyClass();
        }
        return null;
    }

    private void init(@NotNull PyClass element) {
        PyExpression[] classExpressions;
        if (element == null) {
            PyDiagramModel.$$$reportNull$$$0(1);
        }
        Project project = element.getProject();
        PyFile file = (PyFile)element.getContainingFile();
        this.myNodes.add((Object)new PyDiagramNode(element));
        this.myNames.add(element.getName());
        this.addInterfaces(element);
        PyClass metaClass = PyDiagramModel.getMetaClass(element);
        if (metaClass != null) {
            this.myNodes.add((Object)new PyDiagramNode(metaClass));
            this.myNames.add(metaClass.getName());
        }
        List superClasses = element.getAncestorClasses(null);
        for (PyClass aClass : superClasses) {
            if (!"types.InstanceType".equals(aClass.getQualifiedName())) {
                this.myNodes.add((Object)new PyDiagramNode(aClass));
                this.myNames.add(aClass.getName());
                this.addInterfaces(aClass);
                metaClass = PyDiagramModel.getMetaClass(aClass);
                if (metaClass != null) {
                    this.myNodes.add((Object)new PyDiagramNode(metaClass));
                    this.myNames.add(metaClass.getName());
                }
            }
            if (!LanguageLevel.forElement((PsiElement)element).isPy3K() || !"object".equals(aClass.getName())) continue;
            this.myObjectClass = aClass;
        }
        for (PyExpression e : classExpressions = element.getSuperClassExpressions()) {
            String name = e.getName();
            if (this.myNames.contains(name) || name == null) continue;
            this.myNodes.add((Object)new PyDiagramNode(new PythonDummyClass(e, project, file)));
            this.myNames.add(name);
        }
    }

    private void addInterfaces(@NotNull PyClass element) {
        if (element == null) {
            PyDiagramModel.$$$reportNull$$$0(2);
        }
        for (String name : PyNames.BUILTIN_INTERFACES) {
            PsiElement aClass;
            if (!PyABCUtil.isSubclass((PyClass)element, (String)name, (boolean)false, null) || name.equals(element.getName()) || this.myCollectionsFile == null || !((aClass = ResolveImportUtil.resolveChild((PsiElement)this.myCollectionsFile, (String)name, (PsiFile)this.myCollectionsFile, (boolean)false, (boolean)false, (boolean)false)) instanceof PyClass)) continue;
            this.myNodes.add((Object)new PyDiagramNode((PyClass)aClass));
        }
    }

    @NotNull
    public Collection<DiagramNode<PyClass>> getNodes() {
        HashSet<DiagramNode<PyClass>> hashSet = this.myNodes;
        if (hashSet == null) {
            PyDiagramModel.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    @NotNull
    public Collection<DiagramEdge<PyClass>> getEdges() {
        Collection<DiagramEdge<PyClass>> collection = this.myEdges;
        if (collection == null) {
            PyDiagramModel.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public String getNodeName(@NotNull DiagramNode<PyClass> node) {
        String name;
        if (node == null) {
            PyDiagramModel.$$$reportNull$$$0(5);
        }
        String string = (name = ((PyClass)node.getIdentifyingElement()).getName()) == null ? "" : name;
        if (string == null) {
            PyDiagramModel.$$$reportNull$$$0(6);
        }
        return string;
    }

    public DiagramNode<PyClass> addElement(@NotNull PyClass element) {
        if (element == null) {
            PyDiagramModel.$$$reportNull$$$0(7);
        }
        if (this.isAlreadyDrawn(element)) {
            return null;
        }
        PyDiagramNode node = new PyDiagramNode(element);
        if (!this.myNodes.contains((Object)node)) {
            this.myNodes.add((Object)node);
        }
        return node;
    }

    private boolean isAlreadyDrawn(PyClass element) {
        if (element != null) {
            String elementFQN = element.getQualifiedName();
            for (DiagramNode node : this.myNodes) {
                PyClass container = (PyClass)node.getIdentifyingElement();
                String nodeFQN = container.getName();
                if (elementFQN == null || nodeFQN == null || !elementFQN.equals(nodeFQN)) continue;
                return true;
            }
        }
        return false;
    }

    public void removeNode(DiagramNode<PyClass> node) {
        this.removeElement((PyClass)node.getIdentifyingElement());
    }

    private void removeElement(PyClass element) {
        DiagramNode node = this.findNode(element);
        if (node != null) {
            ArrayList<DiagramEdge<PyClass>> edges = new ArrayList<DiagramEdge<PyClass>>();
            for (DiagramEdge<PyClass> edge : this.myEdges) {
                if (!edge.getTarget().equals(node) && !edge.getSource().equals(node)) continue;
                edges.add(edge);
            }
            this.myEdges.removeAll(edges);
            this.myNodes.remove((Object)node);
        }
    }

    @Nullable
    private DiagramNode findNode(PyClass element) {
        if (element == null) {
            return null;
        }
        String elementFQN = element.getQualifiedName();
        for (DiagramNode node : this.myNodes) {
            String fqn = ((PyClass)node.getIdentifyingElement()).getQualifiedName();
            if (elementFQN == null || !elementFQN.equals(fqn)) continue;
            return node;
        }
        return null;
    }

    @Nullable
    private DiagramNode findNode(@Nullable String elementFQN) {
        for (DiagramNode node : this.myNodes) {
            String fqn = ((PyClass)node.getIdentifyingElement()).getQualifiedName();
            if (elementFQN == null || !elementFQN.equals(fqn)) continue;
            return node;
        }
        return null;
    }

    public void refreshDataModel() {
        for (DiagramNode node : this.myNodes) {
            PyClass aClass;
            if (this.addSuperclassEdges((DiagramNode<PyClass>)node, aClass = (PyClass)node.getIdentifyingElement())) continue;
            this.addMetaclassEdges((DiagramNode<PyClass>)node, aClass);
            this.addInterfaceEdges((DiagramNode<PyClass>)node, aClass);
        }
    }

    private void addInterfaceEdges(DiagramNode<PyClass> node, PyClass aClass) {
        for (String name : PyNames.BUILTIN_INTERFACES) {
            DiagramNode interfaceNode;
            PsiElement interf;
            if (!PyABCUtil.isSubclass((PyClass)aClass, (String)name, (boolean)false, null) || name.equals(aClass.getName()) || this.myCollectionsFile == null || !((interf = ResolveImportUtil.resolveChild((PsiElement)this.myCollectionsFile, (String)name, (PsiFile)this.myCollectionsFile, (boolean)false, (boolean)false, (boolean)false)) instanceof PyClass) || aClass.isSubclass((PyClass)interf, null) || (interfaceNode = this.findNode((PyClass)interf)) == null || !this.myNodes.contains((Object)interfaceNode)) continue;
            PyUmlEdge edge = new PyUmlEdge(node, (DiagramNode<PyClass>)interfaceNode, PyUmlRelationships.INTERFACE);
            this.myEdges.add((DiagramEdge<PyClass>)edge);
        }
    }

    private void addMetaclassEdges(DiagramNode<PyClass> node, PyClass aClass) {
        PyClass metaClass = PyDiagramModel.getMetaClass(aClass);
        if (metaClass == null) {
            return;
        }
        DiagramNode metaclassNode = this.findNode(metaClass);
        if (metaclassNode != null && this.myNodes.contains((Object)metaclassNode)) {
            PyUmlEdge edge = new PyUmlEdge(node, (DiagramNode<PyClass>)metaclassNode, PyUmlRelationships.INSTANCEOF);
            this.myEdges.add((DiagramEdge<PyClass>)edge);
        }
    }

    private boolean addSuperclassEdges(DiagramNode<PyClass> node, PyClass aClass) {
        if (PyNames.BUILTIN_INTERFACES.contains(aClass.getName())) {
            return true;
        }
        PyClass[] superClasses = aClass.getSuperClasses(null);
        HashSet processed = new HashSet();
        for (PyClass pyClass : superClasses) {
            DiagramNode superclassNode = this.findNode(pyClass);
            if (superclassNode == null || !this.myNodes.contains((Object)superclassNode)) continue;
            PyUmlEdge edge = new PyUmlEdge(node, (DiagramNode<PyClass>)superclassNode, PyUmlRelationships.SUBCLASS);
            this.myEdges.add((DiagramEdge<PyClass>)edge);
            processed.add(pyClass.getName());
        }
        for (PyClass pyClass : aClass.getSuperClassExpressions()) {
            String name = pyClass.getName();
            DiagramNode superclassNode = this.findNode(name);
            if (superclassNode == null || processed.contains(name) || !this.myNodes.contains((Object)superclassNode)) continue;
            PyUmlEdge edge = new PyUmlEdge(node, (DiagramNode<PyClass>)superclassNode, PyUmlRelationships.SUBCLASS);
            this.myEdges.add((DiagramEdge<PyClass>)edge);
            processed.add(name);
        }
        if (superClasses.length == 0 && this.myObjectClass != null && !"object".equals(aClass.getName())) {
            DiagramNode classNode = this.findNode(aClass);
            DiagramNode objectNode = this.findNode(this.myObjectClass);
            if (classNode != null && objectNode != null) {
                PyUmlEdge edge = new PyUmlEdge((DiagramNode<PyClass>)classNode, (DiagramNode<PyClass>)objectNode, PyUmlRelationships.SUBCLASS);
                this.myEdges.add((DiagramEdge<PyClass>)edge);
            }
        }
        return false;
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        PsiModificationTracker psiModificationTracker = PsiManager.getInstance((Project)this.getProject()).getModificationTracker();
        if (psiModificationTracker == null) {
            PyDiagramModel.$$$reportNull$$$0(8);
        }
        return psiModificationTracker;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/uml/PyDiagramModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/uml/PyDiagramModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetaClass";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addInterfaces";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

