/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.uml;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.jetbrains.ERDiagramModel;
import com.jetbrains.ERUmlElementManager;
import com.jetbrains.appengine.facet.AppEngineFacet;
import com.jetbrains.appengine.util.AppEngineUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AppEngineUmlElementManager
extends ERUmlElementManager {
    @Override
    protected Module getModule(DataContext context) {
        Project project;
        Module module = (Module)LangDataKeys.MODULE.getData(context);
        if (module == null && (project = (Project)CommonDataKeys.PROJECT.getData(context)) != null) {
            module = AppEngineUtil.getAppEngineModule((Project)project);
        }
        return module;
    }

    @Override
    protected List<Map.Entry<String, String>> getElements(PyClass aClass) {
        ArrayList<Map.Entry<String, String>> elements = new ArrayList<Map.Entry<String, String>>();
        for (Map.Entry entry : AppEngineUtil.getProperties((PyClass)aClass).entrySet()) {
            elements.add(entry);
        }
        if (ERDiagramModel.ourAdditionalFields.containsKey(aClass)) {
            elements.add(ERDiagramModel.ourAdditionalFields.get(aClass));
        }
        return elements;
    }

    public boolean isAcceptableAsNode(Object element) {
        Module module;
        if (element instanceof PyClass && (module = AppEngineUtil.getAppEngineModule((Project)((PyClass)element).getProject())) != null) {
            Sdk sdk = PythonSdkType.findPythonSdk((Module)module);
            return sdk != null && AppEngineFacet.isPresent((Module)module);
        }
        return false;
    }
}

