/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.uml;

import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.ERDiagramModel;
import com.jetbrains.ERDiagramNode;
import com.jetbrains.ERDummyModelInit;
import com.jetbrains.appengine.AppEngineNames;
import com.jetbrains.appengine.uml.AppEngineUmlDiagramProvider;
import com.jetbrains.appengine.util.AppEngineUtil;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class AppEngineDiagramModel
extends ERDiagramModel {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.appengine.uml.AppEngineDiagramModel");

    public AppEngineDiagramModel(Project project, PyClass element) {
        super(project, element, AppEngineUmlDiagramProvider.getInstance());
        this.init(project, element);
    }

    @Override
    protected void init(Project project, PyClass element) {
        PsiFile[] files;
        Module module = AppEngineUtil.getAppEngineModule((Project)project);
        if (module == null) {
            return;
        }
        ourAdditionalFields.clear();
        ArrayList<PyFile> models = new ArrayList<PyFile>();
        if (element instanceof ERDummyModelInit && ((ERDummyModelInit)element).getElement() != null) {
            PsiFile file = ((ERDummyModelInit)element).getElement().findFile("models.py");
            if (file != null) {
                files = new PsiFile[]{file};
            } else {
                PsiDirectory directory = ((ERDummyModelInit)element).getElement().findSubdirectory("models");
                if (directory == null) {
                    directory = ((ERDummyModelInit)element).getElement().findSubdirectory("model");
                }
                files = directory != null ? directory.getFiles() : FilenameIndex.getFilesByName((Project)project, (String)"models.py", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
            }
        } else {
            files = FilenameIndex.getFilesByName((Project)project, (String)"models.py", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
        }
        if (files.length == 0) {
            LOG.info("Failed to find models.py or models directory in App Engine Project root " + project.getBasePath());
        }
        for (PsiFile file : files) {
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null || !ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(virtualFile) || !(file instanceof PyFile)) continue;
            models.add((PyFile)file);
        }
        for (PyFile file : models) {
            List classes = file.getTopLevelClasses();
            for (PyClass pyClass : classes) {
                if (!AppEngineDiagramModel.isModelDescendant(pyClass)) continue;
                this.myNodes.add((Object)new ERDiagramNode(pyClass, (DiagramProvider<PyClass>)this.getProvider()));
            }
        }
    }

    public static boolean isModelDescendant(@NotNull PyClass clazz) {
        if (clazz == null) {
            AppEngineDiagramModel.$$$reportNull$$$0(0);
        }
        if ("google.appengine.ext.db.Model".equals(clazz.getQualifiedName())) {
            return true;
        }
        for (PyClassLikeType type : clazz.getAncestorTypes(TypeEvalContext.userInitiated((Project)clazz.getProject(), (PsiFile)clazz.getContainingFile()))) {
            if (type == null || !AppEngineNames.APP_ENGINE_MODELS.contains(type.getClassQName())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void calculateRelations() {
        for (DiagramNode fromNode : this.myNodes) {
            PyClass fromClass = (PyClass)fromNode.getIdentifyingElement();
            Map<PyClass, String> res = this.getRelation(fromClass);
            this.addEdges((DiagramNode<PyClass>)fromNode, res, "", (DiagramProvider<PyClass>)this.getProvider());
        }
    }

    private Map<PyClass, String> getRelation(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            AppEngineDiagramModel.$$$reportNull$$$0(1);
        }
        HashMap<PyClass, String> result = new HashMap<PyClass, String>();
        TypeEvalContext context = TypeEvalContext.userInitiated((Project)pyClass.getProject(), (PsiFile)pyClass.getContainingFile());
        List classAttributes = pyClass.getClassAttributes();
        for (PyTargetExpression expression : classAttributes) {
            PyReferenceExpression refClassRef;
            PyType refClassType;
            QualifiedName calleeQName = expression.getCalleeName();
            if (calleeQName == null) continue;
            if (calleeQName.endsWith("SelfReferenceProperty")) {
                result.put(pyClass, "");
                continue;
            }
            if (!calleeQName.endsWith("ReferenceProperty")) continue;
            PyCallExpression initCall = (PyCallExpression)expression.findAssignedValue();
            assert (initCall != null);
            PyExpression toClass = (PyExpression)initCall.getArgument(0, "reference_class", PyExpression.class);
            if (!(toClass instanceof PyReferenceExpression) || !((refClassType = context.getType((PyTypedElement)(refClassRef = (PyReferenceExpression)toClass))) instanceof PyClassType)) continue;
            PyStringLiteralExpression collectionName = (PyStringLiteralExpression)initCall.getArgument(1, "collection_name", PyStringLiteralExpression.class);
            String label = collectionName == null ? "" : collectionName.getStringValue();
            PyClass aClass = ((PyClassType)refClassType).getPyClass();
            this.additionalFields(pyClass, label, aClass);
            result.put(aClass, "");
        }
        return result;
    }

    private void additionalFields(PyClass pyClass, String relatedName, PyClass aClass) {
        if (!this.myClasses.contains((Object)pyClass)) {
            this.myClasses.add((Object)pyClass);
        }
        if (relatedName.isEmpty()) {
            String aClassName = pyClass.getName();
            String string = relatedName = aClassName != null ? StringUtil.toLowerCase((String)aClassName) + "_set" : "";
        }
        if (!StringUtil.isEmptyOrSpaces((String)relatedName)) {
            ourAdditionalFields.put(aClass, new ERDiagramModel.MyEntry<String, String>(relatedName, "Query"));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/appengine/uml/AppEngineDiagramModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isModelDescendant";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getRelation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

