/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import com.jetbrains.ERDummyModelInit;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public abstract class ERUmlElementManager
extends AbstractDiagramElementManager<PyClass> {
    public PyClass findInDataContext(DataContext context) {
        Module module = this.getModule(context);
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        if (module != null) {
            ERDummyModelInit umlElement = new ERDummyModelInit(module);
            PsiDirectory directory = null;
            if (element != null) {
                if (element instanceof PsiDirectory) {
                    directory = (PsiDirectory)element;
                } else if (element instanceof PsiFile) {
                    directory = ((PsiFile)element).getContainingDirectory();
                } else {
                    PsiFile file = element.getContainingFile();
                    if (file == null) {
                        return null;
                    }
                    directory = file.getContainingDirectory();
                }
            } else {
                PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
                if (psiFile != null) {
                    directory = psiFile.getContainingDirectory();
                }
            }
            if (directory != null) {
                umlElement.setElement(directory);
                return umlElement;
            }
        }
        return null;
    }

    @Nullable
    protected abstract Module getModule(DataContext var1);

    public String getElementTitle(PyClass element) {
        if (element instanceof ERDummyModelInit) {
            return "#" + ((ERDummyModelInit)element).getModule().getName();
        }
        return element.getQualifiedName();
    }

    public SimpleColoredText getItemName(Object element, DiagramState presentation) {
        String text = "";
        if (element instanceof ERDummyModelInit) {
            return new SimpleColoredText(((ERDummyModelInit)element).getModule().getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        if (element instanceof PyClass) {
            PyClass parentClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)((PyClass)element), PyClass.class);
            while (parentClass != null) {
                text = text + parentClass.getName() + ".";
                parentClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)parentClass, PyClass.class);
            }
            text = text + ((PyClass)element).getName();
        } else if (element instanceof PyFunction) {
            text = text + ((PyFunction)element).getName() + ((PyFunction)element).getParameterList().getText();
        } else if (element instanceof PyTargetExpression) {
            text = text + ((PyTargetExpression)element).getName();
        } else if (element instanceof Map.Entry) {
            text = (String)((Map.Entry)element).getKey();
        }
        if (text == null) {
            text = "";
        }
        return new SimpleColoredText(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    public SimpleColoredText getItemType(Object element) {
        if (element instanceof Map.Entry) {
            return new SimpleColoredText((String)((Map.Entry)element).getValue(), new SimpleTextAttributes(0, Color.GRAY));
        }
        return super.getItemType(element);
    }

    @Nullable
    public String getNodeTooltip(PyClass element) {
        return null;
    }

    public Icon getItemIcon(Object element, DiagramState presentation) {
        if (element instanceof Map.Entry) {
            return PlatformIcons.FIELD_ICON;
        }
        return super.getItemIcon(element, presentation);
    }

    public Object[] getNodeItems(PyClass parent) {
        List<Map.Entry<String, String>> elements = this.getElements(parent);
        Collections.sort(elements, (o, o1) -> {
            if (o instanceof Map.Entry && o1 instanceof Map.Entry) {
                return ((String)o.getKey()).compareTo((String)o1.getKey());
            }
            return 0;
        });
        return elements.isEmpty() ? PsiElement.EMPTY_ARRAY : elements.toArray();
    }

    protected abstract List<Map.Entry<String, String>> getElements(PyClass var1);
}

