/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.profiler.lines;

import com.google.common.collect.Maps;
import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.jetbrains.python.coverage.PyCoverageEngine;
import com.jetbrains.python.profiler.CallTreeNode;
import com.jetbrains.python.profiler.ProfileStats;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\u0006\u0010\u0016\u001a\u00020\u0015J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR~\u0010\t\u001ar\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012$\u0012\"\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f \f*\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\r0\r \f*8\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012$\u0012\"\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f \f*\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\r0\r\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/python/profiler/lines/LineProfileSuite;", "Lcom/intellij/coverage/BaseCoverageSuite;", "stats", "Lcom/jetbrains/python/profiler/ProfileStats;", "(Lcom/jetbrains/python/profiler/ProfileStats;)V", "engine", "Lcom/jetbrains/python/coverage/PyCoverageEngine;", "getEngine", "()Lcom/jetbrains/python/coverage/PyCoverageEngine;", "myFilesWithLines", "Ljava/util/HashMap;", "", "kotlin.jvm.PlatformType", "", "", "Lcom/intellij/rt/coverage/data/LineData;", "getCoverageEngine", "Lcom/intellij/coverage/CoverageEngine;", "isCoverageByTestApplicable", "", "loadProjectInfo", "Lcom/intellij/rt/coverage/data/ProjectData;", "projectData", "walkTree", "", "tree", "Lcom/jetbrains/python/profiler/CallTreeNode;", "intellij.python.profiler"})
public final class LineProfileSuite
extends BaseCoverageSuite {
    @NotNull
    private final PyCoverageEngine engine;
    private final HashMap<String, Map<Integer, LineData>> myFilesWithLines;

    @NotNull
    public final PyCoverageEngine getEngine() {
        return this.engine;
    }

    @NotNull
    public CoverageEngine getCoverageEngine() {
        return (CoverageEngine)this.engine;
    }

    public boolean isCoverageByTestApplicable() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void walkTree(CallTreeNode tree) {
        Object object;
        Map.Entry<Integer, Integer> $receiver$iv;
        if (tree == null) {
            return;
        }
        HashMap<String, Map<Integer, LineData>> hashMap = this.myFilesWithLines;
        Intrinsics.checkExpressionValueIsNotNull(hashMap, (String)"myFilesWithLines");
        Map map = hashMap;
        String key$iv = tree.getFile();
        Object value$iv = $receiver$iv.get(key$iv);
        if (value$iv == null) {
            HashMap answer$iv = Maps.newHashMap();
            $receiver$iv.put((Integer)((Object)key$iv), (Integer)((Object)answer$iv));
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Map lineDataMap = (Map)object;
        Iterator<Object> iterator = tree.getLineHits().entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2;
            void $receiver$iv2;
            Map.Entry<Integer, Integer> $i$f$getOrPut = $receiver$iv = iterator.next();
            int line = ((Number)$i$f$getOrPut.getKey()).intValue();
            $i$f$getOrPut = $receiver$iv;
            int hits = ((Number)$i$f$getOrPut.getValue()).intValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)lineDataMap, (String)"lineDataMap");
            Integer key$iv2 = line;
            Object value$iv2 = $receiver$iv2.get(key$iv2);
            if (value$iv2 == null) {
                LineData answer$iv = new LineData(line, "");
                $receiver$iv2.put(key$iv2, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv2;
            }
            LineData lineData = (LineData)object2;
            lineData.setHits(lineData.getHits() + hits);
        }
        for (CallTreeNode c : tree.getChildren()) {
            this.walkTree(c);
        }
    }

    @Nullable
    protected ProjectData loadProjectInfo() {
        return this.projectData();
    }

    @NotNull
    public final ProjectData projectData() {
        ProjectData data = new ProjectData();
        HashMap<String, Map<Integer, LineData>> hashMap = this.myFilesWithLines;
        Intrinsics.checkExpressionValueIsNotNull(hashMap, (String)"myFilesWithLines");
        Map map = hashMap;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map map2;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            String k = (String)entry2.getKey();
            entry2 = entry;
            Map lines = (Map)entry2.getValue();
            ClassData file2 = data.getOrCreateClassData(k);
            Integer max = (Integer)CollectionsKt.max((Iterable)lines.keySet());
            LineData[] linesArray = new LineData[max != null ? max + 1 : 0];
            Intrinsics.checkExpressionValueIsNotNull((Object)lines, (String)"lines");
            Iterator iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                LineData v;
                Map.Entry entry3;
                Map.Entry entry4 = entry3 = iterator2.next();
                int k2 = ((Number)entry4.getKey()).intValue();
                entry4 = entry3;
                linesArray[k2] = v = (LineData)entry4.getValue();
            }
            file2.setLines(linesArray);
        }
        return data;
    }

    public LineProfileSuite(@NotNull ProfileStats stats) {
        Intrinsics.checkParameterIsNotNull((Object)stats, (String)"stats");
        super("LineProfiling", new CoverageFileProvider(){

            @NotNull
            public String getCoverageDataFilePath() {
                return "";
            }

            public boolean ensureFileExists() {
                return true;
            }

            public boolean isValid() {
                return true;
            }
        }, System.currentTimeMillis(), false, false, false, null);
        this.engine = new PyCoverageEngine(){

            @NotNull
            public Object[] postProcessExecutableLines(@NotNull Object[] executableLines, @Nullable Editor editor) {
                Intrinsics.checkParameterIsNotNull((Object)executableLines, (String)"executableLines");
                return executableLines;
            }
        };
        this.myFilesWithLines = Maps.newHashMap();
        this.walkTree(stats.getCallTree());
    }
}

