/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.profiler.callgraph;

import com.intellij.diagram.DiagramNode;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.renderer.AbstractColoredNodeCellRenderer;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiManager;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.Gray;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.profiler.FunctionStat;
import com.jetbrains.python.profiler.ProfileDataKt;
import com.jetbrains.python.profiler.UtilsKt;
import com.jetbrains.python.profiler.callgraph.CallGraphBuilder;
import com.jetbrains.python.profiler.callgraph.CallGraphNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J*\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020\u000eH\u0014J\u0018\u0010!\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u0011H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006#"}, d2={"Lcom/jetbrains/python/profiler/callgraph/CallGraphNodeRenderer;", "Lcom/intellij/openapi/graph/builder/renderer/AbstractColoredNodeCellRenderer;", "project", "Lcom/intellij/openapi/project/Project;", "builder", "Lcom/jetbrains/python/profiler/callgraph/CallGraphBuilder;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/python/profiler/callgraph/CallGraphBuilder;)V", "getBuilder", "()Lcom/jetbrains/python/profiler/callgraph/CallGraphBuilder;", "addTime", "", "labelName", "", "time", "", "totalTime", "propertiesPanel", "Ljavax/swing/JPanel;", "colorIntensity", "Ljava/awt/Color;", "totalTimeMs", "baseTotalTime", "getRendererComponent", "Ljavax/swing/JComponent;", "view", "Lcom/intellij/openapi/graph/view/Graph2DView;", "realizer", "Lcom/intellij/openapi/graph/view/NodeRealizer;", "obj", "", "sel", "", "getSelectionBorderWidth", "tuneNode", "wrapper", "intellij.python.profiler"})
public final class CallGraphNodeRenderer
extends AbstractColoredNodeCellRenderer {
    @NotNull
    private final CallGraphBuilder builder;

    @NotNull
    protected JComponent getRendererComponent(@NotNull Graph2DView view, @NotNull NodeRealizer realizer, @Nullable Object obj, boolean sel) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)realizer, (String)"realizer");
        CellRendererPanel.SuperPreferredSize innerPanel = new CellRendererPanel.SuperPreferredSize();
        innerPanel.setLayout((LayoutManager)new BorderLayout());
        CellRendererPanel.SuperPreferredSize outerPanel = new CellRendererPanel.SuperPreferredSize();
        outerPanel.setLayout((LayoutManager)new BorderLayout());
        outerPanel.add((Component)innerPanel, (Object)"Center");
        if (GraphViewUtil.isPrintMode()) {
            outerPanel.setBorder((Border)new LineBorder((Color)Gray._168, 2));
            innerPanel.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        } else if (!UIUtil.isUnderDarcula()) {
            outerPanel.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
            innerPanel.setBorder(sel ? (Border)new LineBorder(this.getSelectionColor(), this.getSelectionBorderWidth(), false) : (Border)new EmptyBorder(0, 0, 0, 0));
        } else {
            outerPanel.setBorder(sel ? (Border)new LineBorder(this.getSelectionColor()) : (Border)new EmptyBorder(0, 0, 0, 0));
            innerPanel.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        }
        outerPanel.setFocusable(false);
        innerPanel.setFocusable(false);
        this.tuneNode(realizer, (JPanel)innerPanel);
        return (JComponent)outerPanel;
    }

    public void tuneNode(@NotNull NodeRealizer realizer, @NotNull JPanel wrapper) {
        Intrinsics.checkParameterIsNotNull((Object)realizer, (String)"realizer");
        Intrinsics.checkParameterIsNotNull((Object)wrapper, (String)"wrapper");
        Node node = realizer.getNode();
        DiagramNode beansNode = (DiagramNode)this.builder.getNodeObject(node);
        if (beansNode != null) {
            FunctionStat callStat = ((CallGraphNode)beansNode).getCallStat();
            JLabel nameLabel = new JLabel(ProfileDataKt.functionPresentableName(callStat.getName(), callStat.getFile()), (Icon)((Object)((CallGraphNode)beansNode).getIcon()), 0);
            Font font = nameLabel.getFont();
            Font font2 = nameLabel.getFont();
            Intrinsics.checkExpressionValueIsNotNull((Object)font2, (String)"nameLabel.font");
            nameLabel.setFont(font.deriveFont(1, (float)((double)font2.getSize() * 1.2)));
            nameLabel.setBorder(JBUI.Borders.empty((int)3));
            nameLabel.setHorizontalAlignment(2);
            nameLabel.setForeground(Color.BLACK);
            Color colorIntensity = this.colorIntensity(callStat.getTotalTimeMs(), callStat.getBaseTotalTime());
            CellRendererPanel.SuperPreferredSizeWithBackground namePanel = new CellRendererPanel.SuperPreferredSizeWithBackground();
            namePanel.setLayout((LayoutManager)new BorderLayout());
            namePanel.add((Component)nameLabel, (Object)"Center");
            namePanel.setBackground(colorIntensity);
            wrapper.add((Component)namePanel, "North");
            CellRendererPanel.SuperPreferredSizeWithBackground propertiesPanel = new CellRendererPanel.SuperPreferredSizeWithBackground();
            propertiesPanel.setLayout((LayoutManager)new GridBagLayout());
            propertiesPanel.setBorder((Border)JBUI.Borders.empty((int)2, (int)5));
            propertiesPanel.setBackground(colorIntensity);
            wrapper.add((Component)propertiesPanel, "Center");
            this.addTime("Total:", callStat.getTotalTimeMs(), callStat.getBaseTotalTime(), (JPanel)propertiesPanel);
            this.addTime("Own:", callStat.getOwnTimeMs(), callStat.getBaseTotalTime(), (JPanel)propertiesPanel);
            JLabel callCountVal = new JLabel("<html>&times;" + String.valueOf(callStat.getCallCount()) + "</html>");
            callCountVal.setForeground(Color.BLACK);
            callCountVal.setFont(callCountVal.getFont().deriveFont(1));
            callCountVal.setHorizontalAlignment(4);
            callCountVal.setBorder(new EmptyBorder(1, 2, 1, 3));
            namePanel.add((Component)callCountVal, (Object)"East");
            GridBagConstraints horizontalFill = new GridBagConstraints();
            horizontalFill.gridx = 3;
            horizontalFill.gridy = 0;
            horizontalFill.anchor = 17;
            horizontalFill.fill = 2;
            horizontalFill.weightx = 1.0;
            propertiesPanel.add(Box.createHorizontalGlue(), (Object)horizontalFill);
        }
    }

    private final Color colorIntensity(int totalTimeMs, int baseTotalTime) {
        float power = 1.0f - (float)totalTimeMs / (float)baseTotalTime;
        double H = (double)power * 0.4;
        double S = 0.5;
        boolean B = true;
        Color color = Color.getHSBColor((float)H, (float)S, (float)B);
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"Color.getHSBColor(H.toFl\u2026S.toFloat(), B.toFloat())");
        return color;
    }

    private final void addTime(String labelName, int time, int totalTime, JPanel propertiesPanel) {
        JLabel timeLabel = new JLabel(labelName);
        timeLabel.setForeground(Color.BLACK);
        JLabel timeVal = new JLabel(String.valueOf(time) + "ms");
        timeVal.setForeground(Color.BLACK);
        JLabel timePc = new JLabel(UtilsKt.percent(time, totalTime));
        timePc.setForeground(Color.DARK_GRAY);
        timeVal.setFont(timeVal.getFont().deriveFont(1));
        propertiesPanel.add((Component)timeLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 21, 0, new Insets(2, 2, 2, 2), 0, 0));
        propertiesPanel.add((Component)timeVal, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 22, 0, new Insets(2, 2, 2, 2), 0, 0));
        propertiesPanel.add((Component)timePc, new GridBagConstraints(2, -1, 1, 1, 0.0, 0.0, 22, 0, new Insets(2, 2, 2, 2), 0, 0));
    }

    protected int getSelectionBorderWidth() {
        return 2;
    }

    @NotNull
    public final CallGraphBuilder getBuilder() {
        return this.builder;
    }

    public CallGraphNodeRenderer(@NotNull Project project, @NotNull CallGraphBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)builder), (String)"builder");
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"PsiManager.getInstance(project)");
        super((ModificationTracker)psiManager.getModificationTracker());
        this.builder = builder;
    }
}

