/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.profiler;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.jetbrains.python.profiler.ProfilerCommunication;
import com.jetbrains.python.profiler.ProfilerCommunicationKt;
import com.jetbrains.python.profiler.ProfilerResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u0013\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/python/profiler/SnapshotAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "profilerCommunication", "Lcom/jetbrains/python/profiler/ProfilerCommunication;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/python/profiler/ProfilerCommunication;Lcom/intellij/execution/process/ProcessHandler;)V", "getProcessHandler", "()Lcom/intellij/execution/process/ProcessHandler;", "getProfilerCommunication", "()Lcom/jetbrains/python/profiler/ProfilerCommunication;", "getProject", "()Lcom/intellij/openapi/project/Project;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.python.profiler"})
public final class SnapshotAction
extends AnAction {
    @NotNull
    private final Project project;
    @NotNull
    private final ProfilerCommunication profilerCommunication;
    @NotNull
    private final ProcessHandler processHandler;

    public void actionPerformed(@Nullable AnActionEvent e) {
        FutureCallback value2 = (FutureCallback)new FutureCallback<ProfilerResponse>(this){
            final /* synthetic */ SnapshotAction this$0;

            public void onFailure(@NotNull Throwable t) {
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                throw (Throwable)new UnsupportedOperationException();
            }

            public void onSuccess(@Nullable ProfilerResponse response) {
                Project project = this.this$0.getProject();
                Sdk sdk = this.this$0.getProfilerCommunication().getSdk();
                ProfilerResponse profilerResponse = response;
                if (profilerResponse == null) {
                    Intrinsics.throwNpe();
                }
                ProfilerCommunicationKt.processResponse(project, sdk, profilerResponse, this.this$0.getProcessHandler());
            }
            {
                this.this$0 = $outer;
            }
        };
        Futures.addCallback(this.profilerCommunication.captureSnapshot(), (FutureCallback)value2);
    }

    public void update(@Nullable AnActionEvent e) {
        if (e != null) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setEnabled(!this.processHandler.isProcessTerminated());
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ProfilerCommunication getProfilerCommunication() {
        return this.profilerCommunication;
    }

    @NotNull
    public final ProcessHandler getProcessHandler() {
        return this.processHandler;
    }

    public SnapshotAction(@NotNull Project project, @NotNull ProfilerCommunication profilerCommunication, @NotNull ProcessHandler processHandler) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)profilerCommunication, (String)"profilerCommunication");
        Intrinsics.checkParameterIsNotNull((Object)processHandler, (String)"processHandler");
        super("Capture Snapshot", "Dumps profiling snapshot to a file and opens it", AllIcons.Actions.ProfileCPU);
        this.project = project;
        this.profilerCommunication = profilerCommunication;
        this.processHandler = processHandler;
    }
}

