/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.profiler;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.jetbrains.python.profiler.FunctionStat;
import com.jetbrains.python.profiler.ProfilerViewKt;
import com.jetbrains.python.profiler.callgraph.CallGraphView;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/python/profiler/ShowOnCallGraphAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.python.profiler"})
public final class ShowOnCallGraphAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        FunctionStat functionStat = (FunctionStat)e.getData(ProfilerViewKt.getFUNCTION_STAT());
        if (functionStat == null) {
            return;
        }
        FunctionStat funcStat = functionStat;
        CallGraphView callGraphView = (CallGraphView)e.getData(ProfilerViewKt.getCALL_GRAPH_VIEW());
        try {
            CallGraphView callGraphView2 = callGraphView;
            if (callGraphView2 != null) {
                FunctionStat functionStat2 = funcStat;
                Intrinsics.checkExpressionValueIsNotNull((Object)functionStat2, (String)"funcStat");
                callGraphView2.select(functionStat2);
            }
        }
        catch (IllegalArgumentException exc) {
            JBPopupFactory.getInstance().createBalloonBuilder((JComponent)new JLabel("This call is not shown on the graph because of it's little impact on overall performance")).setFadeoutTime(3000L).setFillColor(HintUtil.getErrorColor()).createBalloon().show(JBPopupFactory.getInstance().guessBestPopupLocation(e.getDataContext()), Balloon.Position.above);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setEnabled(e.getData(ProfilerViewKt.getCALL_GRAPH_VIEW()) != null);
    }

    public ShowOnCallGraphAction() {
        super("Show on Call Graph");
    }
}

