/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.profiler;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.profiler.ProfileData;
import com.jetbrains.python.profiler.ProfileSession;
import com.jetbrains.python.profiler.ProfilerCommunicationKt;
import com.jetbrains.python.profiler.ProfilerExecutor;
import com.jetbrains.python.profiler.PythonProfilerCustomizer;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonRunner;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J5\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010$\u001a\u00020\u0006H\u0016\u00a8\u0006&"}, d2={"Lcom/jetbrains/python/profiler/PythonProfileRunner;", "Lcom/jetbrains/python/run/PythonRunner;", "()V", "canRun", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "createCommandLinePatchers", "", "Lcom/jetbrains/python/run/CommandLinePatcher;", "project", "Lcom/intellij/openapi/project/Project;", "state", "Lcom/jetbrains/python/run/PythonCommandLineState;", "serverLocalPort", "", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/python/run/PythonCommandLineState;Lcom/intellij/execution/configurations/RunProfile;I)[Lcom/jetbrains/python/run/CommandLinePatcher;", "createConfigurationData", "Lcom/jetbrains/python/profiler/ProfileData;", "settingsProvider", "Lcom/intellij/execution/configurations/ConfigurationInfoProvider;", "createProfileServerPatcher", "createRunConfigPatcher", "Lcom/intellij/execution/configurations/RunProfileState;", "doExecute", "Lcom/intellij/execution/ui/RunContentDescriptor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "fillProfileParameters", "", "debugParams", "Lcom/intellij/execution/configurations/ParamsGroup;", "cmdLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "getRunnerId", "Companion", "intellij.python.profiler"})
public final class PythonProfileRunner
extends PythonRunner {
    @NotNull
    private static final String PYTHON_PROFILER_RUNNER = "PythonProfile";
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) {
        ServerSocket serverSocket;
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        FileDocumentManager.getInstance().saveAllDocuments();
        PythonCommandLineState pyState = (PythonCommandLineState)state;
        ServerSocket serverSocket2 = serverSocket = PythonCommandLineState.createServerSocket();
        Intrinsics.checkExpressionValueIsNotNull((Object)serverSocket2, (String)"serverSocket");
        int serverLocalPort = serverSocket2.getLocalPort();
        Executor executor = environment.getExecutor();
        Project project = environment.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"environment.project");
        RunProfile runProfile = environment.getRunProfile();
        Intrinsics.checkExpressionValueIsNotNull((Object)runProfile, (String)"environment.runProfile");
        CommandLinePatcher[] commandLinePatcherArray = this.createCommandLinePatchers(project, pyState, runProfile, serverLocalPort);
        ExecutionResult result = pyState.execute(executor, Arrays.copyOf(commandLinePatcherArray, commandLinePatcherArray.length));
        Project project2 = environment.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"environment.project");
        Sdk sdk = pyState.getSdk();
        if (sdk == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)sdk, (String)"pyState.sdk!!");
        ExecutionResult executionResult = result;
        Intrinsics.checkExpressionValueIsNotNull((Object)executionResult, (String)"result");
        RunProfile runProfile2 = environment.getRunProfile();
        Intrinsics.checkExpressionValueIsNotNull((Object)runProfile2, (String)"environment.runProfile");
        String string = runProfile2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"environment.runProfile.name");
        return new ProfileSession(project2, sdk, executionResult, serverSocket, string).getContentDescriptor();
    }

    private final CommandLinePatcher createRunConfigPatcher(RunProfileState state, RunProfile profile) {
        return state instanceof PythonCommandLineState && profile instanceof AbstractPythonRunConfiguration ? (CommandLinePatcher)profile : null;
    }

    private final CommandLinePatcher[] createCommandLinePatchers(Project project, PythonCommandLineState state, RunProfile profile, int serverLocalPort) {
        List patchers = CollectionsKt.mutableListOf((Object[])new CommandLinePatcher[]{this.createProfileServerPatcher(project, serverLocalPort, state), this.createRunConfigPatcher((RunProfileState)state, profile)});
        ExtensionPointName<PythonProfilerCustomizer> extensionPointName = PythonProfilerCustomizer.Companion.getEP_NAME();
        Intrinsics.checkExpressionValueIsNotNull(extensionPointName, (String)"PythonProfilerCustomizer.EP_NAME");
        Object[] objectArray = extensionPointName.getExtensions();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"PythonProfilerCustomizer.EP_NAME.extensions");
        Object $receiver$iv = objectArray;
        for (Object element$iv$iv : $receiver$iv) {
            CommandLinePatcher commandLinePatcher;
            Object element$iv = element$iv$iv;
            PythonProfilerCustomizer it = (PythonProfilerCustomizer)element$iv;
            if (it.createCommandLinePatcher() == null) continue;
            CommandLinePatcher it$iv = commandLinePatcher;
            ((Collection)patchers).add(it$iv);
        }
        Object object = $receiver$iv = (Collection)patchers;
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Object thisCollection$iv = object;
        CommandLinePatcher[] commandLinePatcherArray = thisCollection$iv.toArray(new CommandLinePatcher[0]);
        if (commandLinePatcherArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return commandLinePatcherArray;
    }

    private final CommandLinePatcher createProfileServerPatcher(Project project, int serverLocalPort, PythonCommandLineState state) {
        return new CommandLinePatcher(this, serverLocalPort, state, project){
            final /* synthetic */ PythonProfileRunner this$0;
            final /* synthetic */ int $serverLocalPort;
            final /* synthetic */ PythonCommandLineState $state;
            final /* synthetic */ Project $project;

            public final void patchCommandLine(GeneralCommandLine commandLine) {
                ParamsGroup debugParams;
                GeneralCommandLine generalCommandLine = commandLine;
                Intrinsics.checkExpressionValueIsNotNull((Object)generalCommandLine, (String)"commandLine");
                ParametersList parametersList = generalCommandLine.getParametersList();
                ParamsGroup paramsGroup = parametersList.getParamsGroup("Profiler");
                if (paramsGroup == null) {
                    Intrinsics.throwNpe();
                }
                ParamsGroup paramsGroup2 = debugParams = paramsGroup;
                Intrinsics.checkExpressionValueIsNotNull((Object)paramsGroup2, (String)"debugParams");
                PythonProfileRunner.access$fillProfileParameters(this.this$0, paramsGroup2, commandLine, this.$serverLocalPort);
                boolean bl = true;
                Map map = commandLine.getEnvironment();
                ArrayList<E> arrayList = new ArrayList<E>();
                PythonSdkFlavor.initPythonPath((Map)map, (boolean)bl, (Collection)arrayList);
                if (PySdkUtil.isRemote((Sdk)this.$state.getSdk())) {
                    commandLine.getEnvironment().put("PYCHARM_REMOTE_RUN", "1");
                }
                commandLine.getEnvironment().put("PYCHARM_SNAPSHOT_PATH", ProfilerCommunicationKt.generateSnapshotPath(this.$project));
            }
            {
                this.this$0 = pythonProfileRunner;
                this.$serverLocalPort = n;
                this.$state = pythonCommandLineState;
                this.$project = project;
            }
        };
    }

    private final void fillProfileParameters(ParamsGroup debugParams, GeneralCommandLine cmdLine, int serverLocalPort) {
        PythonHelper.PROFILER.addToGroup(debugParams, cmdLine);
        for (String s : new String[]{"127.0.0.1", String.valueOf(serverLocalPort)}) {
            debugParams.addParameter(s);
        }
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkParameterIsNotNull((Object)executorId, (String)"executorId");
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        return Intrinsics.areEqual((Object)executorId, (Object)ProfilerExecutor.Companion.getPROFILE_EXECUTOR_ID()) && profile instanceof AbstractPythonRunConfiguration;
    }

    @NotNull
    public ProfileData createConfigurationData(@NotNull ConfigurationInfoProvider settingsProvider) {
        Intrinsics.checkParameterIsNotNull((Object)settingsProvider, (String)"settingsProvider");
        return new ProfileData();
    }

    @NotNull
    public String getRunnerId() {
        return Companion.getPYTHON_PROFILER_RUNNER();
    }

    static {
        PYTHON_PROFILER_RUNNER = PYTHON_PROFILER_RUNNER;
    }

    public static final /* synthetic */ void access$fillProfileParameters(PythonProfileRunner $this, @NotNull ParamsGroup debugParams, @NotNull GeneralCommandLine cmdLine, int serverLocalPort) {
        $this.fillProfileParameters(debugParams, cmdLine, serverLocalPort);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/profiler/PythonProfileRunner$Companion;", "", "()V", "PYTHON_PROFILER_RUNNER", "", "getPYTHON_PROFILER_RUNNER", "()Ljava/lang/String;", "intellij.python.profiler"})
    public static final class Companion {
        @NotNull
        public final String getPYTHON_PROFILER_RUNNER() {
            return PYTHON_PROFILER_RUNNER;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

