/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.profiler;

import com.google.common.collect.Maps;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.profiler.CallStat;
import com.jetbrains.python.profiler.CallTreeNodeData;
import com.jetbrains.python.profiler.CallTreeStat;
import com.jetbrains.python.profiler.CallTreeStatData;
import com.jetbrains.python.profiler.FuncStat;
import com.jetbrains.python.profiler.Function;
import com.jetbrains.python.profiler.FunctionStat;
import com.jetbrains.python.profiler.FunctionStatData;
import com.jetbrains.python.profiler.ProfileStatData;
import com.jetbrains.python.profiler.Stats;
import com.jetbrains.python.profiler.TreeStats;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u0080\u0001\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u001a0\u0010\u0005\u001a$\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00030\u0003\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00030\u0003\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000b\u001a\u00020\f\u001a0\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0007\u001a?\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002\u00a2\u0006\u0002\u0010\u001b\u001a.\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u0014\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u00072\b\u0010 \u001a\u0004\u0018\u00010\u001e2\u0006\u0010!\u001a\u00020\"H\u0002\u001a\u0016\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a7\u0010%\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\u00112\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00010(2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002\u00a2\u0006\u0002\u0010)\u001a\u0016\u0010*\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u0007\u001a\u0018\u0010,\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\u0010\u0010-\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\u0010\u0010.\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\u0011H\u0002\u001a#\u0010/\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00032\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002\u00a2\u0006\u0002\u00100\u001a\u0018\u00101\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001aP\u00102\u001a\u0002032\b\u0010 \u001a\u0004\u0018\u0001042\b\u00105\u001a\u0004\u0018\u00010\u001e2\u0006\u0010!\u001a\u00020\"2$\u00106\u001a \u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u000204072\u0006\u0010\u0016\u001a\u00020\u0017\u00a8\u00068"}, d2={"allowedFunctionName", "", "functionName", "", "file", "callId", "Lkotlin/Triple;", "", "call", "Lcom/jetbrains/python/profiler/CallStat;", "kotlin.jvm.PlatformType", "funcStat", "Lcom/jetbrains/python/profiler/FuncStat;", "name", "line", "createCallStatsList", "", "Lcom/jetbrains/python/profiler/FunctionStat;", "stats", "Lcom/jetbrains/python/profiler/Stats;", "tree", "Lcom/jetbrains/python/profiler/TreeStats;", "profileStats", "Lcom/jetbrains/python/profiler/ProfileStatData;", "projectRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/jetbrains/python/profiler/Stats;Lcom/jetbrains/python/profiler/TreeStats;Lcom/jetbrains/python/profiler/ProfileStatData;[Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/util/List;", "createCallTree", "Lcom/jetbrains/python/profiler/CallTreeNodeData;", "Lcom/jetbrains/python/profiler/CallTreeStat;", "total", "parent", "samplingInterval", "", "functionPresentableName", "funcName", "hasOnlyInternalCallers", "stat", "map", "Ljava/util/HashMap;", "(Lcom/jetbrains/python/profiler/FunctionStat;Ljava/util/HashMap;[Lcom/intellij/openapi/vfs/VirtualFile;)Z", "hitsToOwnTimeMs", "hits", "isEntryPoint", "isHelper", "isInternalCall", "isProjectRoot", "(Ljava/lang/String;[Lcom/intellij/openapi/vfs/VirtualFile;)Z", "moduleName", "walkTree", "", "Lcom/jetbrains/python/profiler/CallTreeStatData;", "node", "idToCallFuncStat", "", "intellij.python.profiler"})
public final class ProfileDataKt {
    private static final CallTreeNodeData createCallTree(CallTreeStat tree, int total, CallTreeStat parent, double samplingInterval) {
        if (tree == null) {
            return null;
        }
        double perc = 1.0 * (double)tree.count / (double)total;
        double percOfParent = 1.0 * (double)tree.count / (double)(parent != null ? parent.count : tree.count);
        CallTreeNodeData node = new CallTreeNodeData(tree, perc, percOfParent, samplingInterval);
        for (CallTreeStat child : tree.children) {
            CallTreeNodeData childNode = ProfileDataKt.createCallTree(child, total, tree, samplingInterval);
            if (childNode == null) continue;
            node.addChild(childNode);
        }
        return node;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<FunctionStat> createCallStatsList(Stats stats, TreeStats tree, ProfileStatData profileStats, VirtualFile[] projectRoots) {
        if (tree != null) {
            HashMap hashMap = Maps.newHashMap();
            Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"Maps.newHashMap()");
            Map idToCallFuncStat = hashMap;
            ProfileDataKt.walkTree(null, tree.call_tree, tree.sampling_interval, idToCallFuncStat, profileStats);
            return CollectionsKt.toList((Iterable)idToCallFuncStat.values());
        }
        if (stats != null) {
            List list;
            FunctionStatData stat;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            FuncStat call;
            Object callStat;
            void $receiver$iv$iv2;
            Triple<String, String, Integer> triple;
            Iterator<Object> funcStat;
            Object object;
            void $receiver$iv$iv3;
            void $receiver$iv2;
            List<Function> list2 = stats.getFunc_stats();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"stats.getFunc_stats()");
            Iterable iterable = list2;
            void var6_7 = $receiver$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv3) {
                Function function = (Function)item$iv$iv;
                object = destination$iv$iv;
                FuncStat funcStat2 = ((Function)((Object)funcStat)).func_stat;
                Intrinsics.checkExpressionValueIsNotNull((Object)funcStat2, (String)"funcStat.func_stat");
                triple = new Triple<String, String, Integer>(funcStat2, profileStats);
                object.add(triple);
            }
            List callsList = (List)destination$iv$iv;
            Iterable $receiver$iv3 = callsList;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10)), (int)16);
            Iterable iterable2 = $receiver$iv3;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            for (Object element$iv$iv : $receiver$iv$iv2) {
                void it;
                FunctionStatData $i$f$mapTo = (FunctionStatData)element$iv$iv;
                object = destination$iv$iv2;
                triple = ProfileDataKt.callId((CallStat)it);
                object.put(triple, element$iv$iv);
            }
            Map idToCallFuncStat = destination$iv$iv2;
            for (Function f : stats.func_stats) {
                FuncStat funcStat3 = f.func_stat;
                Intrinsics.checkExpressionValueIsNotNull((Object)funcStat3, (String)"f.func_stat");
                callStat = (FunctionStatData)idToCallFuncStat.get(ProfileDataKt.callId(funcStat3));
                if (callStat == null) continue;
                funcStat = f.getCallers().iterator();
                while (funcStat.hasNext()) {
                    FuncStat funcStat4 = call = (FuncStat)funcStat.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)funcStat4, (String)"call");
                    FunctionStatData caller = (FunctionStatData)idToCallFuncStat.get(ProfileDataKt.callId(funcStat4));
                    if (caller == null) continue;
                    ((FunctionStatData)callStat).addCaller(caller);
                }
            }
            HashMap<FunctionStat, Boolean> map = new HashMap<FunctionStat, Boolean>();
            callStat = callsList;
            call = $receiver$iv;
            Collection destination$iv$iv3 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                stat = (FunctionStatData)element$iv$iv;
                if (!(ProfileDataKt.allowedFunctionName(stat.getName(), stat.getFile()) && !ProfileDataKt.hasOnlyInternalCallers(stat, map, projectRoots))) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List filteredCallsList = (List)destination$iv$iv3;
            if (!filteredCallsList.isEmpty()) {
                list = filteredCallsList;
            } else {
                $receiver$iv$iv = $receiver$iv = (Iterable)callsList;
                destination$iv$iv3 = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    stat = (FunctionStatData)element$iv$iv;
                    if (!ProfileDataKt.allowedFunctionName(stat.getName(), stat.getFile())) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                list = (List)destination$iv$iv3;
            }
            return list;
        }
        return null;
    }

    public static final void walkTree(@Nullable CallTreeStatData parent, @Nullable CallTreeStat node, double samplingInterval, @NotNull Map<Triple<String, String, Integer>, CallTreeStatData> idToCallFuncStat, @NotNull ProfileStatData profileStats) {
        Intrinsics.checkParameterIsNotNull(idToCallFuncStat, (String)"idToCallFuncStat");
        Intrinsics.checkParameterIsNotNull((Object)profileStats, (String)"profileStats");
        if (node == null) {
            return;
        }
        String string = node.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node.getName()");
        List parts = StringsKt.split$default((CharSequence)string, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
        if (parts.size() == 4) {
            String string2;
            int n;
            Object object;
            String funname = (String)parts.get(1);
            String funline = (String)parts.get(2);
            String filename = (String)parts.get(3);
            Object object2 = filename;
            Triple<String, String, Integer> key = ProfileDataKt.callId((String)object2, (String)(object = funname), n = Integer.parseInt(string2 = funline));
            Object stat = idToCallFuncStat.get(key);
            if (stat == null) {
                CallTreeStatData callTreeStatData;
                String string3 = funline;
                String string4 = funname;
                String string5 = filename;
                object = callTreeStatData;
                object2 = callTreeStatData;
                int n2 = Integer.parseInt(string3);
                ((CallTreeStatData)object)(string5, string4, n2, 0, samplingInterval, profileStats);
                stat = object2;
                idToCallFuncStat.put(key, (CallTreeStatData)stat);
            }
            CallTreeStatData callTreeStatData = stat;
            callTreeStatData.setHits(callTreeStatData.getHits() + node.count);
            if (parent != null) {
                parent.addChild((FunctionStat)stat);
                ((CallTreeStatData)stat).addCaller(parent);
            }
            for (CallTreeStat child : node.children) {
                ProfileDataKt.walkTree((CallTreeStatData)stat, child, samplingInterval, idToCallFuncStat, profileStats);
            }
        }
    }

    private static final boolean hasOnlyInternalCallers(FunctionStat stat, HashMap<FunctionStat, Boolean> map, VirtualFile[] projectRoots) {
        if (map.get(stat) == null) {
            if (ProfileDataKt.isEntryPoint(stat.getName(), stat.getFile()) || ProfileDataKt.isProjectRoot(stat.getFile(), projectRoots)) {
                map.put(stat, false);
            } else if (ProfileDataKt.isInternalCall(stat)) {
                map.put(stat, true);
            } else {
                map.put(stat, true);
            }
            if (stat.getCallers().size() > 0) {
                for (FunctionStat c : stat.getCallers()) {
                    if (ProfileDataKt.hasOnlyInternalCallers(c, map, projectRoots)) continue;
                    map.put(stat, false);
                    break;
                }
            }
        }
        Boolean bl = map.get(stat);
        if (bl == null) {
            Intrinsics.throwNpe();
        }
        return bl;
    }

    private static final boolean isProjectRoot(String file2, VirtualFile[] projectRoots) {
        boolean bl;
        block1: {
            for (Object element$iv : (Object[])projectRoots) {
                VirtualFile root = (VirtualFile)element$iv;
                String string = FileUtil.toSystemIndependentName((String)file2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.toSystemIndependentName(file)");
                CharSequence charSequence = string;
                String string2 = FileUtil.toSystemIndependentName((String)root.getPath());
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"FileUtil.toSystemIndependentName(root.path)");
                if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string2, (boolean)false, (int)2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean isEntryPoint(String name, String file2) {
        return Intrinsics.areEqual((Object)"<execfile>", (Object)name) || Intrinsics.areEqual((Object)"<built-in method exec>", (Object)name) || Intrinsics.areEqual((Object)"<built-in method builtins.exec>", (Object)name) || Intrinsics.areEqual((Object)"run", (Object)name) && StringsKt.contains$default((CharSequence)file2, (CharSequence)"tcunittest.py", (boolean)false, (int)2, null);
    }

    private static final boolean isInternalCall(FunctionStat stat) {
        return !ProfileDataKt.allowedFunctionName(stat.getName(), stat.getFile()) || ProfileDataKt.isHelper(stat.getFile());
    }

    private static final boolean isHelper(String file2) {
        return FileUtil.isAncestor((File)PythonHelpersLocator.getHelpersRoot(), (File)new File(file2), (boolean)false);
    }

    private static final boolean allowedFunctionName(String functionName, String file2) {
        return !ProfileDataKt.isEntryPoint(functionName, file2) && !StringsKt.contains$default((CharSequence)functionName, (CharSequence)"_lsprof.Profiler", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)functionName, (Object)"stop_profiling") ^ true;
    }

    @NotNull
    public static final Triple<String, String, Integer> callId(@NotNull String file2, @NotNull String name, int line) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return new Triple((Object)file2, (Object)name, (Object)line);
    }

    @NotNull
    public static final Triple<String, String, Integer> callId(@NotNull CallStat call) {
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        return new Triple((Object)call.getFile(), (Object)call.getName(), (Object)call.getLine());
    }

    @NotNull
    public static final Triple<String, String, Integer> callId(@NotNull FuncStat funcStat) {
        Intrinsics.checkParameterIsNotNull((Object)funcStat, (String)"funcStat");
        return new Triple((Object)funcStat.file, (Object)funcStat.func_name, (Object)funcStat.line);
    }

    private static final String moduleName(String funcName, String file2) {
        String string = PathUtil.getFileName((String)file2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PathUtil.getFileName(file)");
        return string;
    }

    @NotNull
    public static final String functionPresentableName(@NotNull String funcName, @NotNull String file2) {
        Intrinsics.checkParameterIsNotNull((Object)funcName, (String)"funcName");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return Intrinsics.areEqual((Object)funcName, (Object)"<module>") ? ProfileDataKt.moduleName(funcName, file2) : funcName;
    }

    public static final int hitsToOwnTimeMs(double samplingInterval, int hits) {
        return (int)((double)hits * samplingInterval * (double)1000);
    }

    @Nullable
    public static final /* synthetic */ List access$createCallStatsList(@Nullable Stats stats, @Nullable TreeStats tree, @NotNull ProfileStatData profileStats, @NotNull VirtualFile[] projectRoots) {
        return ProfileDataKt.createCallStatsList(stats, tree, profileStats, projectRoots);
    }

    @Nullable
    public static final /* synthetic */ CallTreeNodeData access$createCallTree(@Nullable CallTreeStat tree, int total, @Nullable CallTreeStat parent, double samplingInterval) {
        return ProfileDataKt.createCallTree(tree, total, parent, samplingInterval);
    }
}

