/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.profiler;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.jetbrains.python.profiler.CallTreeCellRenderer;
import com.jetbrains.python.profiler.CallTreeNode;
import com.jetbrains.python.profiler.ProfileStats;
import com.jetbrains.python.profiler.ProfilerViewKt;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0001H\u0002J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/python/profiler/CallTreeView;", "Ljavax/swing/JTree;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "callTreeRoot", "Lcom/jetbrains/python/profiler/CallTreeNode;", "profileStats", "Lcom/jetbrains/python/profiler/ProfileStats;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/python/profiler/CallTreeNode;Lcom/jetbrains/python/profiler/ProfileStats;)V", "getCallTreeRoot", "()Lcom/jetbrains/python/profiler/CallTreeNode;", "getProfileStats", "()Lcom/jetbrains/python/profiler/ProfileStats;", "getProject", "()Lcom/intellij/openapi/project/Project;", "expandAllNodes", "", "tree", "getData", "", "dataId", "", "walk", "treeItem", "Ljavax/swing/tree/DefaultMutableTreeNode;", "intellij.python.profiler"})
public final class CallTreeView
extends JTree
implements DataProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final CallTreeNode callTreeRoot;
    @NotNull
    private final ProfileStats profileStats;

    private final void expandAllNodes(JTree tree) {
        int j = tree.getRowCount();
        for (int i = 0; i < j; ++i) {
            tree.expandRow(i);
            j = tree.getRowCount();
        }
    }

    public final void walk(@NotNull DefaultMutableTreeNode treeItem) {
        Intrinsics.checkParameterIsNotNull((Object)treeItem, (String)"treeItem");
        Object object = treeItem.getUserObject();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.python.profiler.CallTreeNode");
        }
        CallTreeNode value2 = (CallTreeNode)object;
        for (CallTreeNode childNode : value2.getChildren()) {
            if (!childNode.isVisible()) continue;
            DefaultMutableTreeNode childItem = new DefaultMutableTreeNode(childNode);
            treeItem.add(childItem);
            this.walk(childItem);
        }
    }

    @Nullable
    public Object getData(@Nullable String dataId) {
        if (ProfilerViewKt.getCALL_GRAPH_VIEW().is(dataId)) {
            return null;
        }
        if (ProfilerViewKt.getFUNCTION_STAT().is(dataId)) {
            TreePath treePath = this.getSelectionPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)treePath, (String)"selectionPath");
            return treePath.getLastPathComponent();
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            Object selectedObject;
            TreePath treePath = this.getSelectionPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)treePath, (String)"selectionPath");
            Object object = treePath.getLastPathComponent();
            if (object == null) {
                return null;
            }
            Object object2 = selectedObject = object;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            }
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)object2;
            Object object3 = treeNode.getUserObject();
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.python.profiler.CallTreeNode");
            }
            return ProfilerViewKt.findNavigatables(this.project, (CallTreeNode)object3, this.profileStats);
        }
        return null;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final CallTreeNode getCallTreeRoot() {
        return this.callTreeRoot;
    }

    @NotNull
    public final ProfileStats getProfileStats() {
        return this.profileStats;
    }

    public CallTreeView(@NotNull Project project, @NotNull CallTreeNode callTreeRoot, @NotNull ProfileStats profileStats) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)callTreeRoot, (String)"callTreeRoot");
        Intrinsics.checkParameterIsNotNull((Object)profileStats, (String)"profileStats");
        super(new DefaultTreeModel(new DefaultMutableTreeNode(callTreeRoot)));
        this.project = project;
        this.callTreeRoot = callTreeRoot;
        this.profileStats = profileStats;
        TreeModel treeModel = this.treeModel;
        Intrinsics.checkExpressionValueIsNotNull((Object)treeModel, (String)"treeModel");
        Object object = treeModel.getRoot();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        }
        this.walk((DefaultMutableTreeNode)object);
        CallTreeCellRenderer renderer = new CallTreeCellRenderer();
        renderer.getIcon();
        this.setCellRenderer(renderer);
        this.expandAllNodes(this);
    }
}

