/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.profiler;

import com.google.common.collect.Lists;
import com.jetbrains.python.profiler.CallStat;
import com.jetbrains.python.profiler.FunctionStat;
import com.jetbrains.python.profiler.ProfileDataKt;
import com.jetbrains.python.profiler.ProfileStatData;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0001J\u000e\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0096\u0002J\b\u0010$\u001a\u00020\u0006H\u0016J\b\u0010%\u001a\u00020\u0006H\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00010'H\u0016J\b\u0010(\u001a\u00020\u0003H\u0016J\b\u0010)\u001a\u00020\u0006H\u0016J\b\u0010*\u001a\u00020\u0003H\u0016J\b\u0010+\u001a\u00020\u0006H\u0016J\b\u0010,\u001a\u00020\u0006H\u0016J\b\u0010-\u001a\u00020\u0006H\u0016R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006."}, d2={"Lcom/jetbrains/python/profiler/CallTreeStatData;", "Lcom/jetbrains/python/profiler/FunctionStat;", "fileName", "", "funcName", "lineNumber", "", "hits", "samplingInterval", "", "profileStatData", "Lcom/jetbrains/python/profiler/ProfileStatData;", "(Ljava/lang/String;Ljava/lang/String;IIDLcom/jetbrains/python/profiler/ProfileStatData;)V", "callersList", "Ljava/util/ArrayList;", "childrenList", "getFileName", "()Ljava/lang/String;", "getFuncName", "getHits", "()I", "setHits", "(I)V", "getLineNumber", "getProfileStatData", "()Lcom/jetbrains/python/profiler/ProfileStatData;", "getSamplingInterval", "()D", "addCaller", "", "func", "addChild", "equals", "", "other", "", "getBaseTotalTime", "getCallCount", "getCallers", "", "getFile", "getLine", "getName", "getOwnTimeMs", "getTotalTimeMs", "hashCode", "intellij.python.profiler"})
public final class CallTreeStatData
implements FunctionStat {
    private final ArrayList<FunctionStat> callersList;
    private final ArrayList<FunctionStat> childrenList;
    @NotNull
    private final String fileName;
    @NotNull
    private final String funcName;
    private final int lineNumber;
    private int hits;
    private final double samplingInterval;
    @NotNull
    private final ProfileStatData profileStatData;

    public final void addCaller(@NotNull FunctionStat func) {
        Intrinsics.checkParameterIsNotNull((Object)func, (String)"func");
        if (!this.callersList.contains(func)) {
            this.callersList.add(func);
        }
    }

    public final void addChild(@NotNull FunctionStat func) {
        Intrinsics.checkParameterIsNotNull((Object)func, (String)"func");
        if (!this.childrenList.contains(func)) {
            this.childrenList.add(func);
        }
    }

    @Override
    @NotNull
    public List<FunctionStat> getCallers() {
        CopyOnWriteArrayList copyOnWriteArrayList = Lists.newCopyOnWriteArrayList((Iterable)this.callersList);
        Intrinsics.checkExpressionValueIsNotNull((Object)copyOnWriteArrayList, (String)"Lists.newCopyOnWriteArrayList(callersList)");
        return copyOnWriteArrayList;
    }

    @Override
    @NotNull
    public String getFile() {
        return this.fileName;
    }

    @Override
    @NotNull
    public String getName() {
        return this.funcName;
    }

    @Override
    public int getLine() {
        return this.lineNumber;
    }

    @Override
    public int getCallCount() {
        return this.hits;
    }

    @Override
    public int getTotalTimeMs() {
        return (int)((double)this.hits * this.samplingInterval * (double)1000);
    }

    @Override
    public int getOwnTimeMs() {
        int calleesTotal = 0;
        for (FunctionStat s : this.childrenList) {
            calleesTotal += s.getTotalTimeMs();
        }
        int own = this.getTotalTimeMs() - calleesTotal;
        return own > 0 ? own : 0;
    }

    @Override
    public int getBaseTotalTime() {
        return this.profileStatData.getBaseTotalTimeMs();
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof CallTreeStatData) {
            return ProfileDataKt.callId(this).equals(ProfileDataKt.callId((CallStat)other));
        }
        return super.equals(other);
    }

    public int hashCode() {
        return ProfileDataKt.callId(this).hashCode();
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    @NotNull
    public final String getFuncName() {
        return this.funcName;
    }

    public final int getLineNumber() {
        return this.lineNumber;
    }

    public final int getHits() {
        return this.hits;
    }

    public final void setHits(int n) {
        this.hits = n;
    }

    public final double getSamplingInterval() {
        return this.samplingInterval;
    }

    @NotNull
    public final ProfileStatData getProfileStatData() {
        return this.profileStatData;
    }

    public CallTreeStatData(@NotNull String fileName, @NotNull String funcName, int lineNumber, int hits, double samplingInterval, @NotNull ProfileStatData profileStatData) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)funcName, (String)"funcName");
        Intrinsics.checkParameterIsNotNull((Object)profileStatData, (String)"profileStatData");
        this.fileName = fileName;
        this.funcName = funcName;
        this.lineNumber = lineNumber;
        this.hits = hits;
        this.samplingInterval = samplingInterval;
        this.profileStatData = profileStatData;
        this.callersList = new ArrayList();
        this.childrenList = new ArrayList();
    }
}

