/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.profiler;

import com.jetbrains.python.profiler.CallStat;
import com.jetbrains.python.profiler.FuncStat;
import com.jetbrains.python.profiler.ProfileStatData;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0016\b\u0016\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B=\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u001c\u001a\u00020\u000bH\u0016J\b\u0010\u001d\u001a\u00020\u000bH\u0016J\b\u0010\u001e\u001a\u00020\bH\u0016J\b\u0010\u001f\u001a\u00020\u000bH\u0016J\b\u0010 \u001a\u00020\bH\u0016J\b\u0010!\u001a\u00020\u000bH\u0016J\b\u0010\"\u001a\u00020\u000bH\u0016J\b\u0010#\u001a\u00020\bH\u0016R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018\u00a8\u0006$"}, d2={"Lcom/jetbrains/python/profiler/CallStatData;", "Lcom/jetbrains/python/profiler/CallStat;", "stats", "Lcom/jetbrains/python/profiler/FuncStat;", "profileStatData", "Lcom/jetbrains/python/profiler/ProfileStatData;", "(Lcom/jetbrains/python/profiler/FuncStat;Lcom/jetbrains/python/profiler/ProfileStatData;)V", "fileName", "", "funcName", "lineNumber", "", "callCnt", "totalTime", "", "ownTime", "(Ljava/lang/String;Ljava/lang/String;IIDDLcom/jetbrains/python/profiler/ProfileStatData;)V", "getCallCnt", "()I", "getFileName", "()Ljava/lang/String;", "getFuncName", "getLineNumber", "getOwnTime", "()D", "getProfileStatData", "()Lcom/jetbrains/python/profiler/ProfileStatData;", "getTotalTime", "getBaseTotalTime", "getCallCount", "getFile", "getLine", "getName", "getOwnTimeMs", "getTotalTimeMs", "toString", "intellij.python.profiler"})
public class CallStatData
implements CallStat {
    @NotNull
    private final String fileName;
    @NotNull
    private final String funcName;
    private final int lineNumber;
    private final int callCnt;
    private final double totalTime;
    private final double ownTime;
    @NotNull
    private final ProfileStatData profileStatData;

    @Override
    @NotNull
    public String getFile() {
        return this.fileName;
    }

    @Override
    @NotNull
    public String getName() {
        return this.funcName;
    }

    @Override
    public int getLine() {
        return this.lineNumber;
    }

    @Override
    public int getCallCount() {
        return this.callCnt;
    }

    @Override
    public int getTotalTimeMs() {
        return (int)(this.totalTime * (double)1000);
    }

    @Override
    public int getOwnTimeMs() {
        return (int)(this.ownTime * (double)1000);
    }

    @Override
    public int getBaseTotalTime() {
        return this.profileStatData.getBaseTotalTimeMs();
    }

    @NotNull
    public String toString() {
        return this.getName();
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    @NotNull
    public final String getFuncName() {
        return this.funcName;
    }

    public final int getLineNumber() {
        return this.lineNumber;
    }

    public final int getCallCnt() {
        return this.callCnt;
    }

    public final double getTotalTime() {
        return this.totalTime;
    }

    public final double getOwnTime() {
        return this.ownTime;
    }

    @NotNull
    public final ProfileStatData getProfileStatData() {
        return this.profileStatData;
    }

    public CallStatData(@NotNull String fileName, @NotNull String funcName, int lineNumber, int callCnt, double totalTime, double ownTime, @NotNull ProfileStatData profileStatData) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)funcName, (String)"funcName");
        Intrinsics.checkParameterIsNotNull((Object)profileStatData, (String)"profileStatData");
        this.fileName = fileName;
        this.funcName = funcName;
        this.lineNumber = lineNumber;
        this.callCnt = callCnt;
        this.totalTime = totalTime;
        this.ownTime = ownTime;
        this.profileStatData = profileStatData;
    }

    public CallStatData(@NotNull FuncStat stats, @NotNull ProfileStatData profileStatData) {
        Intrinsics.checkParameterIsNotNull((Object)stats, (String)"stats");
        Intrinsics.checkParameterIsNotNull((Object)profileStatData, (String)"profileStatData");
        String string = stats.file;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"stats.file");
        String string2 = stats.func_name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"stats.func_name");
        this(string, string2, stats.line, stats.calls_count, stats.total_time, stats.own_time, profileStatData);
    }
}

