/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.model;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.plugins.watcher.config.FileWatchersState;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TasksPersistentComponent
implements PersistentStateComponent<Element> {
    private final List<Pair<TaskOptions, Boolean>> myTasks = new CopyOnWriteArrayList<Pair<TaskOptions, Boolean>>();
    public static final String TASK_OPTIONS = "TaskOptions";
    public static final String TASK_ENABLED = "isEnabled";
    private static final String SUPPRESSED_TASK_NAMES = "suppressed-tasks";

    @NotNull
    public List<Pair<TaskOptions, Boolean>> getTasks() {
        List<Pair<TaskOptions, Boolean>> list = this.myTasks;
        if (list == null) {
            TasksPersistentComponent.$$$reportNull$$$0(0);
        }
        return list;
    }

    public void setTasks(List<Pair<TaskOptions, Boolean>> tasks) {
        this.myTasks.clear();
        this.myTasks.addAll(tasks);
    }

    @Nullable
    public Element getState() {
        return TasksPersistentComponent.getElement(this.getTasks(), this.getSuppressedTaskNames());
    }

    @NotNull
    public abstract List<String> getSuppressedTaskNames();

    public abstract void setSuppressedTaskNames(@NotNull List<String> var1);

    @NotNull
    public static Element getElement(List<Pair<TaskOptions, Boolean>> tasks, @NotNull List<String> suppressedTaskNames) {
        if (suppressedTaskNames == null) {
            TasksPersistentComponent.$$$reportNull$$$0(1);
        }
        Element element = new Element(TASK_OPTIONS);
        for (Pair<TaskOptions, Boolean> task : tasks) {
            Element taskElement = XmlSerializer.serialize((Object)task.getFirst(), (SerializationFilter)new SerializationFilter(){

                public boolean accepts(@NotNull Accessor accessor, @NotNull Object bean) {
                    if (accessor == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (bean == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return accessor.getGenericType() != EnvironmentVariablesData.class;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "accessor";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "bean";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/plugins/watcher/model/TasksPersistentComponent$1";
                    objectArray[2] = "accepts";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            ((TaskOptions)task.getFirst()).getEnvData().writeExternal(taskElement);
            if (task.getSecond() != null) {
                taskElement.setAttribute(TASK_ENABLED, Boolean.toString((Boolean)task.getSecond()));
            }
            element.addContent(taskElement);
        }
        if (!suppressedTaskNames.isEmpty()) {
            String allSuppressedTaskNames = StringUtil.join(suppressedTaskNames, (String)";");
            element.setAttribute(SUPPRESSED_TASK_NAMES, allSuppressedTaskNames);
        }
        Element element2 = element;
        if (element2 == null) {
            TasksPersistentComponent.$$$reportNull$$$0(2);
        }
        return element2;
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            TasksPersistentComponent.$$$reportNull$$$0(3);
        }
        FileWatchersState state = TasksPersistentComponent.getTaskOptions(element);
        this.setTasks(state.getTasks());
        this.setSuppressedTaskNames((List<String>)state.getSuppressedTaskNames());
    }

    @NotNull
    public static FileWatchersState getTaskOptions(@NotNull Element state) {
        if (state == null) {
            TasksPersistentComponent.$$$reportNull$$$0(4);
        }
        ArrayList<Pair<TaskOptions, Boolean>> tasks = new ArrayList<Pair<TaskOptions, Boolean>>();
        for (Object item : state.getChildren(TASK_OPTIONS)) {
            Element element = (Element)item;
            TaskOptions options = (TaskOptions)XmlSerializer.deserialize((Element)element, TaskOptions.class);
            EnvironmentVariablesData envData = EnvironmentVariablesData.readExternal((Element)element);
            options.setEnvData(envData);
            tasks.add((Pair<TaskOptions, Boolean>)Pair.create((Object)options, (Object)Boolean.parseBoolean(element.getAttributeValue(TASK_ENABLED))));
        }
        List suppressedTaskNames = Collections.emptyList();
        String suppressedTaskNamesStr = state.getAttributeValue(SUPPRESSED_TASK_NAMES);
        if (!StringUtil.isEmptyOrSpaces((String)suppressedTaskNamesStr)) {
            suppressedTaskNames = StringUtil.split((String)suppressedTaskNamesStr, (String)";");
        }
        FileWatchersState fileWatchersState = new FileWatchersState(tasks, suppressedTaskNames);
        if (fileWatchersState == null) {
            TasksPersistentComponent.$$$reportNull$$$0(5);
        }
        return fileWatchersState;
    }

    @Nullable
    public Pair<TaskOptions, Boolean> findTaskByName(String name) {
        return (Pair)ContainerUtil.find(this.getTasks(), pair -> name.equalsIgnoreCase(((TaskOptions)pair.getFirst()).getName()));
    }

    public void setEnabledForTask(String name, boolean isEnabled) {
        List<Pair<TaskOptions, Boolean>> oldTasks = this.getTasks();
        int size = oldTasks.size();
        ArrayList<Pair<TaskOptions, Boolean>> newTasks = new ArrayList<Pair<TaskOptions, Boolean>>(size);
        for (Pair<TaskOptions, Boolean> pair : oldTasks) {
            TaskOptions options = (TaskOptions)pair.getFirst();
            if (name.equals(options.getName())) {
                newTasks.add((Pair<TaskOptions, Boolean>)Pair.create((Object)options, (Object)isEnabled));
                continue;
            }
            newTasks.add(pair);
        }
        this.setTasks(newTasks);
    }

    public void addTask(TaskOptions options, boolean isEnabled) {
        this.getTasks().add((Pair<TaskOptions, Boolean>)Pair.create((Object)options, (Object)isEnabled));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/watcher/model/TasksPersistentComponent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suppressedTaskNames";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasks";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/watcher/model/TasksPersistentComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskOptions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTaskOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

